/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.store;

import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import io.vavr.Tuple2;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface KeyValueStore {
    public static final KeyValueStore NO_OP = new NoopStore();

    public static KeyValueStore noop() {
        return NO_OP;
    }

    public static KeyValueStore inMemory() {
        return new InMemoryStore();
    }

    default public Map<String, Map<String, String>> getAllRows(String tableName) throws IOException {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        for (String pKey : this.getAllPartitionKeys(tableName)) {
            results.computeIfAbsent(pKey, k -> new HashMap());
            ((Map)results.get(pKey)).putAll(this.getAll(tableName, pKey));
        }
        return results;
    }

    public List<String> getAllPartitionKeys(String var1) throws IOException;

    default public String get(String tableName, String partitionKey, String secondaryKey) throws IOException {
        return this.getAll(tableName, partitionKey).get(secondaryKey);
    }

    public Map<String, String> getAll(String var1, String var2) throws IOException;

    default public boolean upsert(String tableName, String partitionKey, String secondaryKey, String data) throws IOException {
        return this.upsertAll(tableName, partitionKey, (Map<String, String>)ImmutableMap.of((Object)secondaryKey, (Object)data));
    }

    default public boolean upsert(String tableName, String partitionKey, String secondaryKey, String data, Duration ttl) throws IOException {
        return this.upsertAll(tableName, partitionKey, (Map<String, String>)ImmutableMap.of((Object)secondaryKey, (Object)data), ttl);
    }

    default public boolean upsertAll(String tableName, String partitionKey, Map<String, String> all) throws IOException {
        return this.upsertAll(tableName, partitionKey, all, Duration.ZERO);
    }

    public boolean upsertAll(String var1, String var2, Map<String, String> var3, Duration var4) throws IOException;

    default public boolean upsertOrdered(String tableName, String partitionKey, Long orderingId, String value, Duration ttl) throws IOException {
        return this.upsertOrdered(tableName, partitionKey, (Map<Long, String>)ImmutableMap.of((Object)orderingId, (Object)value), ttl);
    }

    default public boolean upsertOrdered(String tableName, String partitionKey, Map<Long, String> all, Duration ttl) throws IOException {
        Map<String, String> items = all.entrySet().stream().map(e -> new Tuple2((Object)Long.toString((Long)e.getKey()), e.getValue())).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        return this.upsertAll(tableName, partitionKey, items, ttl);
    }

    default public Map<Long, String> getAllOrdered(String tableName, String partitionKey, int limit) throws IOException {
        Map<String, String> items = this.getAll(tableName, partitionKey);
        Comparator<Tuple2> longOrder = Comparator.comparing(Tuple2::_1);
        Comparator<Tuple2> reverseOrder = longOrder.reversed();
        return items.entrySet().stream().map(e -> new Tuple2((Object)Long.parseLong((String)e.getKey()), e.getValue())).sorted(reverseOrder).limit(limit).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
    }

    default public Map<Long, String> getAllOrdered(String tableName, String partitionKey, int limit, long endExclusive) throws IOException {
        Map<String, String> items = this.getAll(tableName, partitionKey);
        Comparator<Tuple2> longOrder = Comparator.comparing(Tuple2::_1);
        Comparator<Tuple2> reverseOrder = longOrder.reversed();
        return items.entrySet().stream().map(e -> new Tuple2((Object)Long.parseLong((String)e.getKey()), e.getValue())).sorted(reverseOrder).filter(e -> (Long)e._1 < endExclusive).limit(limit).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
    }

    public boolean delete(String var1, String var2, String var3) throws IOException;

    public boolean deleteAll(String var1, String var2) throws IOException;

    default public boolean isRowExists(String tableName, String partitionKey, String secondaryKey) throws IOException {
        Map<String, String> items = this.getAll(tableName, partitionKey);
        return items != null && items.containsKey(secondaryKey);
    }

    default public Map<String, String> getAllWithPrefix(String tableName, String partitionKey, String prefix) throws IOException {
        String pr = (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"");
        return this.getAll(tableName, partitionKey).entrySet().stream().filter(x -> StringUtils.startsWith((CharSequence)((CharSequence)x.getKey()), (CharSequence)pr)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static class InMemoryStore
    implements KeyValueStore {
        private final Map<String, Map<String, SortedMap<String, String>>> store = new ConcurrentHashMap<String, Map<String, SortedMap<String, String>>>();

        @Override
        public List<String> getAllPartitionKeys(String tableName) {
            if (this.store.get(tableName) == null) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(this.store.get(tableName).keySet());
        }

        @Override
        public Map<String, String> getAll(String tableName, String partitionKey) throws IOException {
            if (this.store.get(tableName) == null) {
                return Collections.emptyMap();
            }
            if (this.store.get(tableName).get(partitionKey) == null) {
                return Collections.emptyMap();
            }
            return this.store.get(tableName).get(partitionKey);
        }

        @Override
        public boolean upsertAll(String tableName, String partitionKey, Map<String, String> all, Duration ttl) throws IOException {
            this.store.putIfAbsent(tableName, new ConcurrentHashMap());
            SortedMap items = this.store.get(tableName).getOrDefault(partitionKey, new ConcurrentSkipListMap(Comparator.reverseOrder()));
            items.putAll(all);
            this.store.get(tableName).put(partitionKey, items);
            return true;
        }

        @Override
        public boolean delete(String tableName, String partitionKey, String secondaryKey) throws IOException {
            if (this.store.containsKey(tableName) && this.store.get(tableName).containsKey(partitionKey) && this.store.get(tableName).get(partitionKey).containsKey(secondaryKey)) {
                this.store.get(tableName).get(partitionKey).remove(secondaryKey);
                return true;
            }
            return false;
        }

        @Override
        public boolean deleteAll(String tableName, String partitionKey) throws IOException {
            if (this.store.containsKey(tableName) && this.store.get(tableName).containsKey(partitionKey)) {
                this.store.get(tableName).remove(partitionKey);
                return true;
            }
            return false;
        }
    }

    public static class NoopStore
    implements KeyValueStore {
        @Override
        public Map<String, Map<String, String>> getAllRows(String tableName) {
            return null;
        }

        @Override
        public List<String> getAllPartitionKeys(String tableName) {
            return null;
        }

        @Override
        public String get(String tableName, String partitionKey, String secondaryKey) {
            return null;
        }

        @Override
        public Map<String, String> getAll(String tableName, String partitionKey) {
            return null;
        }

        @Override
        public boolean upsertAll(String tableName, String partitionKey, Map<String, String> all, Duration ttl) {
            return false;
        }

        @Override
        public boolean delete(String tableName, String partitionKey, String secondaryKey) {
            return false;
        }

        @Override
        public boolean deleteAll(String tableName, String partitionKey) {
            return false;
        }
    }
}

