/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.ActorContext;
import akka.actor.ActorPaths;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.pattern.PatternsCS;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.GaugeCallback;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.master.IJobClustersManager;
import io.mantisrx.master.JobListHelperActor;
import io.mantisrx.master.akka.MantisActorSupervisorStrategy;
import io.mantisrx.master.events.LifecycleEventPublisher;
import io.mantisrx.master.jobcluster.IJobClusterMetadata;
import io.mantisrx.master.jobcluster.JobClusterActor;
import io.mantisrx.master.jobcluster.job.CostsCalculator;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.JobHelper;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.master.jobcluster.proto.JobClusterProto;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.server.core.JobCompletedReason;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.domain.IJobClusterDefinition;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.server.master.domain.JobDefinition;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.server.master.scheduler.MantisSchedulerFactory;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class JobClustersManagerActor
extends AbstractActorWithTimers
implements IJobClustersManager {
    private static final String CHECK_CLUSTERS_TIMER_KEY = "CHECK_CLUSTER_TIMER";
    public static final int STATE_TRANSITION_TIMEOUT_MSECS = 5000;
    private final Logger logger = LoggerFactory.getLogger(JobClustersManagerActor.class);
    private final long checkAgainInSecs = 30L;
    private final Counter numJobClusterInitFailures;
    private final Counter numJobClusterInitSuccesses;
    private AbstractActor.Receive initializedBehavior;
    private final MantisJobStore jobStore;
    private final LifecycleEventPublisher eventPublisher;
    private final CostsCalculator costsCalculator;
    private MantisSchedulerFactory mantisSchedulerFactory = null;
    JobClusterInfoManager jobClusterInfoManager;
    private ActorRef jobListHelperActor;

    public static Props props(MantisJobStore jobStore, LifecycleEventPublisher eventPublisher, CostsCalculator costsCalculator) {
        return Props.create(JobClustersManagerActor.class, (Object[])new Object[]{jobStore, eventPublisher, costsCalculator}).withMailbox("akka.actor.metered-mailbox");
    }

    public JobClustersManagerActor(MantisJobStore store, LifecycleEventPublisher eventPublisher, CostsCalculator costsCalculator) {
        this.jobStore = store;
        this.eventPublisher = eventPublisher;
        this.costsCalculator = costsCalculator;
        MetricGroupId metricGroupId = this.getMetricGroupId();
        Metrics m = new Metrics.Builder().id(metricGroupId).addCounter("numJobClusterInitFailures").addCounter("numJobClusterInitSuccesses").build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.numJobClusterInitFailures = m.getCounter("numJobClusterInitFailures");
        this.numJobClusterInitSuccesses = m.getCounter("numJobClusterInitSuccesses");
        this.initializedBehavior = this.getInitializedBehavior();
    }

    MetricGroupId getMetricGroupId() {
        return new MetricGroupId("JobClustersManagerActor");
    }

    private AbstractActor.Receive getInitializedBehavior() {
        String state = "initialized";
        return this.receiveBuilder().match(JobClusterManagerProto.ReconcileJobCluster.class, this::onReconcileJobClusters).match(JobClusterManagerProto.CreateJobClusterRequest.class, this::onJobClusterCreate).match(JobClusterProto.InitializeJobClusterResponse.class, this::onJobClusterInitializeResponse).match(JobClusterManagerProto.DeleteJobClusterRequest.class, this::onJobClusterDelete).match(JobClusterProto.DeleteJobClusterResponse.class, this::onJobClusterDeleteResponse).match(JobClusterManagerProto.UpdateJobClusterRequest.class, this::onJobClusterUpdate).match(JobClusterManagerProto.UpdateJobClusterSLARequest.class, this::onJobClusterUpdateSLA).match(JobClusterManagerProto.UpdateJobClusterArtifactRequest.class, this::onJobClusterUpdateArtifact).match(UpdateSchedulingInfo.class, this::onJobClusterUpdateSchedulingInfo).match(JobClusterManagerProto.UpdateJobClusterLabelsRequest.class, this::onJobClusterUpdateLabels).match(JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyRequest.class, this::onJobClusterUpdateWorkerMigrationConfig).match(JobClusterManagerProto.EnableJobClusterRequest.class, this::onJobClusterEnable).match(JobClusterManagerProto.DisableJobClusterRequest.class, this::onJobClusterDisable).match(JobClusterManagerProto.GetJobClusterRequest.class, this::onJobClusterGet).match(JobClusterManagerProto.ListCompletedJobsInClusterRequest.class, this::onJobListCompleted).match(JobClusterManagerProto.GetLastSubmittedJobIdStreamRequest.class, this::onGetLastSubmittedJobIdSubject).match(JobClusterManagerProto.ListArchivedWorkersRequest.class, this::onListArchivedWorkers).match(JobClusterManagerProto.ListJobClustersRequest.class, this::onJobClustersList).match(JobClusterManagerProto.ListJobsRequest.class, this::onJobList).match(JobClusterManagerProto.ListJobIdsRequest.class, this::onJobIdList).match(JobClusterManagerProto.ListWorkersRequest.class, this::onListActiveWorkers).match(JobClusterManagerProto.SubmitJobRequest.class, this::onJobSubmit).match(JobClusterManagerProto.KillJobRequest.class, this::onJobKillRequest).match(JobClusterManagerProto.GetJobDetailsRequest.class, this::onGetJobDetailsRequest).match(JobClusterManagerProto.GetJobSchedInfoRequest.class, this::onGetJobStatusSubject).match(JobClusterManagerProto.GetLatestJobDiscoveryInfoRequest.class, this::onGetLatestJobDiscoveryInfo).match(JobClusterManagerProto.ScaleStageRequest.class, this::onScaleStage).match(JobClusterManagerProto.ResubmitWorkerRequest.class, this::onResubmitWorker).match(WorkerEvent.class, this::onWorkerEvent).match(Terminated.class, this::onTerminated).match(JobClusterManagerProto.JobClustersManagerInitialize.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.JobClustersManagerInitializeResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).matchAny(x -> this.logger.warn("unexpected message {} received by Job Cluster Manager actor. In initialized state ", x)).build();
    }

    private String genUnexpectedMsg(String event, String state) {
        return String.format("Unexpected message %s received by JobClustersManager actor in %s State", event, state);
    }

    private AbstractActor.Receive getInitializingBehavior() {
        String state = "initializing";
        return this.receiveBuilder().match(JobClusterManagerProto.JobClustersManagerInitialize.class, this::initialize).match(JobClusterManagerProto.ReconcileJobCluster.class, x -> this.logger.warn(this.genUnexpectedMsg(x.toString(), state))).match(JobClusterManagerProto.CreateJobClusterRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.CreateJobClusterResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), x.getJobClusterDefinition().getName()), this.getSelf())).match(JobClusterProto.InitializeJobClusterResponse.class, x -> this.logger.warn(this.genUnexpectedMsg(x.toString(), state))).match(JobClusterManagerProto.DeleteJobClusterRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.DeleteJobClusterResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(JobClusterProto.DeleteJobClusterResponse.class, x -> this.logger.warn(this.genUnexpectedMsg(x.toString(), state))).match(JobClusterManagerProto.UpdateJobClusterRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.UpdateJobClusterResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(JobClusterManagerProto.UpdateJobClusterSLARequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.UpdateJobClusterSLAResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(JobClusterManagerProto.UpdateJobClusterArtifactRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.UpdateJobClusterArtifactResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(UpdateSchedulingInfo.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.UpdateSchedulingInfoResponse(((UpdateSchedulingInfo)x).requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(JobClusterManagerProto.UpdateJobClusterLabelsRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.UpdateJobClusterLabelsResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(JobClusterManagerProto.EnableJobClusterRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.EnableJobClusterResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(JobClusterManagerProto.DisableJobClusterRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.DisableJobClusterResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(JobClusterManagerProto.GetJobClusterRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.GetJobClusterResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Optional.empty()), this.getSelf())).match(JobClusterManagerProto.ListCompletedJobsInClusterRequest.class, x -> this.logger.warn(this.genUnexpectedMsg(x.toString(), state))).match(JobClusterManagerProto.GetLastSubmittedJobIdStreamRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.GetLastSubmittedJobIdStreamResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Optional.empty()), this.getSelf())).match(JobClusterManagerProto.ListArchivedWorkersRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.ListArchivedWorkersResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Lists.newArrayList()), this.getSelf())).match(JobClusterManagerProto.ListJobClustersRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.ListJobClustersResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Lists.newArrayList()), this.getSelf())).match(JobClusterManagerProto.ListJobsRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.ListJobsResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Lists.newArrayList()), this.getSelf())).match(JobClusterManagerProto.ListJobIdsRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.ListJobIdsResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Lists.newArrayList()), this.getSelf())).match(JobClusterManagerProto.ListWorkersRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.ListWorkersResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Lists.newArrayList()), this.getSelf())).match(JobClusterManagerProto.SubmitJobRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.SubmitJobResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Optional.empty()), this.getSelf())).match(JobClusterManagerProto.KillJobRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.KillJobResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, JobState.Noop, this.genUnexpectedMsg(x.toString(), state), x.getJobId(), x.getUser()), this.getSelf())).match(JobClusterProto.KillJobResponse.class, x -> this.logger.warn(this.genUnexpectedMsg(x.toString(), state))).match(JobClusterManagerProto.GetJobDetailsRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.GetJobDetailsResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Optional.empty()), this.getSelf())).match(JobClusterManagerProto.GetJobSchedInfoRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.GetJobSchedInfoResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Optional.empty()), this.getSelf())).match(JobClusterManagerProto.GetLatestJobDiscoveryInfoRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.GetLatestJobDiscoveryInfoResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), Optional.empty()), this.getSelf())).match(JobClusterManagerProto.ScaleStageRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.ScaleStageResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state), 0), this.getSelf())).match(JobClusterManagerProto.ResubmitWorkerRequest.class, x -> this.getSender().tell((Object)new JobClusterManagerProto.ResubmitWorkerResponse(x.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, this.genUnexpectedMsg(x.toString(), state)), this.getSelf())).match(WorkerEvent.class, x -> this.logger.warn(this.genUnexpectedMsg(x.toString(), state))).matchAny(x -> this.logger.warn("unexpected message {} received by Job Cluster Manager actor. It needs to be initialized first ", x)).build();
    }

    private void initialize(JobClusterManagerProto.JobClustersManagerInitialize initMsg) {
        ActorRef sender = this.getSender();
        try {
            this.logger.info("In JobClustersManagerActor:initialize");
            this.jobListHelperActor = this.getContext().actorOf(JobListHelperActor.props(), "JobListHelperActor");
            this.getContext().watch(this.jobListHelperActor);
            this.mantisSchedulerFactory = initMsg.getScheduler();
            HashMap<String, IJobClusterMetadata> jobClusterMap = new HashMap<String, IJobClusterMetadata>();
            this.jobClusterInfoManager = new JobClusterInfoManager(this.jobStore, this.mantisSchedulerFactory, this.eventPublisher, this.costsCalculator);
            if (!initMsg.isLoadJobsFromStore()) {
                this.getContext().become(this.initializedBehavior);
                sender.tell((Object)new JobClusterManagerProto.JobClustersManagerInitializeResponse(initMsg.requestId, BaseResponse.ResponseCode.SUCCESS, "JobClustersManager successfully inited"), this.getSelf());
            } else {
                List<IJobClusterMetadata> jobClusters = this.jobStore.loadAllJobClusters();
                this.logger.info("Read {} job clusters from storage", (Object)jobClusters.size());
                List<IMantisJobMetadata> activeJobs = this.jobStore.loadAllActiveJobs();
                this.logger.info("Read {} jobs from storage", (Object)activeJobs.size());
                for (IJobClusterMetadata iJobClusterMetadata : jobClusters) {
                    String clusterName = iJobClusterMetadata.getJobClusterDefinition().getName();
                    jobClusterMap.put(clusterName, iJobClusterMetadata);
                }
                HashMap<String, List> clusterToJobMap = new HashMap<String, List>();
                for (IMantisJobMetadata jobMeta : activeJobs) {
                    String clusterName = jobMeta.getClusterName();
                    clusterToJobMap.computeIfAbsent(clusterName, k -> new ArrayList()).add(jobMeta);
                }
                long l = ConfigurationProvider.getConfig().getMasterInitTimeoutSecs();
                long timeout = l - 60L > 0L ? l - 60L : l;
                Observable.from(jobClusterMap.values()).filter(jobClusterMeta -> jobClusterMeta != null && jobClusterMeta.getJobClusterDefinition() != null).flatMap(jobClusterMeta -> {
                    Duration t = Duration.ofSeconds(timeout);
                    Optional<JobClusterInfo> jobClusterInfoO = this.jobClusterInfoManager.createClusterActorAndRegister(jobClusterMeta.getJobClusterDefinition());
                    if (!jobClusterInfoO.isPresent()) {
                        this.logger.info("skipping job cluster {} on bootstrap as actor creating failed", (Object)jobClusterMeta.getJobClusterDefinition().getName());
                        return Observable.empty();
                    }
                    JobClusterInfo jobClusterInfo = jobClusterInfoO.get();
                    ArrayList jobList = Lists.newArrayList();
                    List jList = (List)clusterToJobMap.get(jobClusterMeta.getJobClusterDefinition().getName());
                    if (jList != null) {
                        jobList.addAll(jList);
                    }
                    ArrayList completedJobsList = Lists.newArrayList();
                    JobClusterProto.InitializeJobClusterRequest req = new JobClusterProto.InitializeJobClusterRequest((JobClusterDefinitionImpl)jobClusterMeta.getJobClusterDefinition(), jobClusterMeta.isDisabled(), jobClusterMeta.getLastJobCount(), jobList, "system", this.getSelf(), false);
                    return this.jobClusterInfoManager.initializeCluster(jobClusterInfo, req, t);
                }).filter(Objects::nonNull).toBlocking().subscribe(clusterInit -> {
                    this.logger.info("JobCluster {} inited with code {}", (Object)clusterInit.jobClusterName, (Object)clusterInit.responseCode);
                    this.numJobClusterInitSuccesses.increment();
                }, error -> {
                    this.logger.warn("Exception initializing clusters {}", (Object)error.getMessage(), error);
                    this.logger.error("JobClusterManagerActor had errors during initialization NOT transitioning to initialized behavior");
                    sender.tell((Object)new JobClusterManagerProto.JobClustersManagerInitializeResponse(initMsg.requestId, BaseResponse.ResponseCode.SERVER_ERROR, "JobClustersManager  inited with errors"), this.getSelf());
                }, () -> {
                    this.logger.info("JobClusterManagerActor transitioning to initialized behavior");
                    this.getContext().become(this.initializedBehavior);
                    sender.tell((Object)new JobClusterManagerProto.JobClustersManagerInitializeResponse(initMsg.requestId, BaseResponse.ResponseCode.SUCCESS, "JobClustersManager successfully inited"), this.getSelf());
                });
                this.getTimers().startPeriodicTimer((Object)CHECK_CLUSTERS_TIMER_KEY, (Object)new JobClusterManagerProto.ReconcileJobCluster(), Duration.ofSeconds(30L));
                this.logger.info("Kicking off archived job load asynchronously");
                this.jobStore.loadAllArchivedJobsAsync();
            }
        }
        catch (Exception e) {
            this.logger.error("caught exception", (Throwable)e);
            sender.tell((Object)new JobClusterManagerProto.JobClustersManagerInitializeResponse(initMsg.requestId, BaseResponse.ResponseCode.SERVER_ERROR, e.getMessage()), this.getSelf());
        }
        this.logger.info("JobClustersManagerActor:initialize ends");
    }

    @Override
    public void onReconcileJobClusters(JobClusterManagerProto.ReconcileJobCluster p) {
        Set jobClusterInfos = this.jobClusterInfoManager.getAllJobClusterInfo().values().stream().filter(jci -> (((JobClusterInfo)jci).currentState == JobClusterInfo.JobClusterState.INITIALIZING || ((JobClusterInfo)jci).currentState == JobClusterInfo.JobClusterState.DELETING) && p.timeOfEnforcement.toEpochMilli() - jci.stateUpdateTime > 5000L).collect(Collectors.toSet());
        if (jobClusterInfos.size() > 0) {
            this.logger.warn("{} JobClusters stuck in initializing/deleting state ", (Object)jobClusterInfos.size());
            jobClusterInfos.stream().forEach(jci -> {
                if (((JobClusterInfo)jci).currentState.equals((Object)JobClusterInfo.JobClusterState.INITIALIZING)) {
                    this.logger.warn("Retrying init on JobCluster {} stuck in {} state since {}", new Object[]{jci.clusterName, ((JobClusterInfo)jci).currentState, jci.stateUpdateTime});
                    jci.stateUpdateTime = p.timeOfEnforcement.toEpochMilli();
                    jci.jobClusterActor.tell((Object)((JobClusterInfo)jci).initRequest, this.getSelf());
                } else {
                    this.logger.warn("Deregistering JobCluster {} stuck in {} state since {}", new Object[]{jci.clusterName, ((JobClusterInfo)jci).currentState, jci.stateUpdateTime});
                    this.jobClusterInfoManager.deregisterJobCluster(jci.clusterName);
                }
            });
        }
    }

    @Override
    public void onJobClusterCreate(JobClusterManagerProto.CreateJobClusterRequest request) {
        block5: {
            String name = request.getJobClusterDefinition().getName();
            if (!this.jobClusterInfoManager.isClusterExists(name)) {
                try {
                    Optional<JobClusterInfo> jobClusterInfoO = this.jobClusterInfoManager.createClusterActorAndRegister(request.getJobClusterDefinition());
                    if (jobClusterInfoO.isPresent()) {
                        this.jobClusterInfoManager.initializeClusterAsync(jobClusterInfoO.get(), new JobClusterProto.InitializeJobClusterRequest(request.getJobClusterDefinition(), request.getUser(), this.getSender()));
                        break block5;
                    }
                    this.getSender().tell((Object)new JobClusterManagerProto.CreateJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, "Job Cluster " + request.getJobClusterDefinition().getName() + " could not be created due to invalid name", request.getJobClusterDefinition().getName()), this.getSelf());
                }
                catch (Exception e) {
                    this.getSender().tell((Object)new JobClusterManagerProto.CreateJobClusterResponse(request.requestId, BaseResponse.ResponseCode.SERVER_ERROR, "Job Cluster " + request.getJobClusterDefinition().getName() + " could not be created due to " + e.getMessage(), request.getJobClusterDefinition().getName()), this.getSelf());
                }
            } else {
                this.getSender().tell((Object)new JobClusterManagerProto.CreateJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_CONFLICT, "Job Cluster " + request.getJobClusterDefinition().getName() + " already exists", request.getJobClusterDefinition().getName()), this.getSelf());
            }
        }
    }

    @Override
    public void onJobClusterInitializeResponse(JobClusterProto.InitializeJobClusterResponse createResp) {
        this.logger.info("Got JobClusterInitializeResponse {}", (Object)createResp);
        this.jobClusterInfoManager.processInitializeResponse(createResp);
    }

    @Override
    public void onJobClusterDelete(JobClusterManagerProto.DeleteJobClusterRequest request) {
        this.jobClusterInfoManager.processDeleteRequest(request);
    }

    @Override
    public void onJobClusterDeleteResponse(JobClusterProto.DeleteJobClusterResponse resp) {
        this.jobClusterInfoManager.processDeleteResponse(resp);
    }

    @Override
    public void onJobClusterUpdate(JobClusterManagerProto.UpdateJobClusterRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getJobClusterDefinition().getName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.UpdateJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getJobClusterDefinition().getName() + " doesn't exist"), this.getSelf());
        }
    }

    @Override
    public void onJobClustersList(JobClusterManagerProto.ListJobClustersRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info("In onJobClustersListRequest {}", (Object)request);
        }
        ActorRef sender = this.getSender();
        Map<String, JobClusterInfo> jobClusterInfoMap = this.jobClusterInfoManager.getAllJobClusterInfo();
        this.jobListHelperActor.tell((Object)new JobListHelperActor.ListJobClusterRequestWrapper(request, sender, jobClusterInfoMap), this.getSelf());
    }

    @Override
    public void onJobClusterGet(JobClusterManagerProto.GetJobClusterRequest r) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(r.getJobClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)r, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.GetJobClusterResponse(r.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "No such Job cluster " + r.getJobClusterName(), Optional.empty()), this.getSelf());
        }
    }

    @Override
    public void onGetLastSubmittedJobIdSubject(JobClusterManagerProto.GetLastSubmittedJobIdStreamRequest r) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(r.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)r, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.GetLastSubmittedJobIdStreamResponse(r.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "No such Job cluster " + r.getClusterName(), Optional.empty()), this.getSelf());
        }
    }

    @Override
    public void onWorkerEvent(WorkerEvent workerEvent) {
        String clusterName;
        Optional<JobClusterInfo> jobClusterInfo;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering JobClusterManagerActor:onWorkerEvent {}", (Object)workerEvent);
        }
        if ((jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(clusterName = workerEvent.getWorkerId().getJobCluster())).isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)workerEvent, (ActorContext)this.getContext());
        } else if (!JobHelper.isTerminalWorkerEvent(workerEvent)) {
            this.logger.warn("Event from Worker {} for a cluster {} that no longer exists. Terminate worker", (Object)workerEvent, (Object)workerEvent.getWorkerId().getJobCluster());
            Optional<String> host = JobHelper.getWorkerHostFromWorkerEvent(workerEvent);
            Optional<JobDefinition> archivedJobDefinition = this.jobClusterInfoManager.getArchivedJobDefinition(workerEvent.getWorkerId().getJobId());
            if (archivedJobDefinition.isPresent()) {
                this.mantisSchedulerFactory.forJob(archivedJobDefinition.get()).unscheduleAndTerminateWorker(workerEvent.getWorkerId(), host);
            } else {
                this.logger.error("Non-Terminal Event {} from worker {} for a cluster {} that no longer exists and the job definition not yet archived", new Object[]{workerEvent, workerEvent.getWorkerId(), workerEvent.getWorkerId().getJobCluster()});
            }
        } else {
            this.logger.warn("Terminal Event from Worker {} for a cluster {} that no longer exists. Ignore worker", (Object)workerEvent, (Object)workerEvent.getWorkerId().getJobCluster());
        }
    }

    private void onTerminated(Terminated terminated) {
        this.logger.warn("onTerminated {}", (Object)terminated.actor());
    }

    @Override
    public void onJobSubmit(JobClusterManagerProto.SubmitJobRequest request) {
        this.logger.info("Submitting job " + request);
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.SubmitJobResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "Job Cluster " + request.getClusterName() + " doesn't exist", Optional.empty()), this.getSelf());
        }
    }

    @Override
    public void onJobKillRequest(JobClusterManagerProto.KillJobRequest request) {
        this.logger.info("Killing job " + request);
        ActorRef sender = this.getSender();
        JobId jobIdToKill = request.getJobId();
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(jobIdToKill.getCluster());
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.tell((Object)new JobClusterProto.KillJobRequest(request.getJobId(), request.getReason(), JobCompletedReason.Killed, request.getUser(), sender), this.getSelf());
        } else {
            this.logger.info("Job cluster {} not found", (Object)jobIdToKill.getCluster());
            sender.tell((Object)new JobClusterManagerProto.KillJobResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, JobState.Noop, "Job cluster " + jobIdToKill.getCluster() + " doesn't exist", jobIdToKill, request.getUser()), this.getSelf());
        }
    }

    public void preStart() throws Exception {
        this.logger.info("JobClusterManager Actor started");
        super.preStart();
    }

    public void postStop() throws Exception {
        this.logger.info("JobClusterManager Actor stopped");
        super.postStop();
    }

    public void preRestart(Throwable t, Optional<Object> m) throws Exception {
        this.logger.info("preRestart {} (exc: {})", m, (Object)t.getMessage());
    }

    public void postRestart(Throwable reason) throws Exception {
        this.logger.info("postRestart (exc={})", (Object)reason.getMessage());
        super.postRestart(reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return MantisActorSupervisorStrategy.getInstance().create();
    }

    public AbstractActor.Receive createReceive() {
        return this.getInitializingBehavior();
    }

    private void logError(Throwable e) {
        this.logger.error("Exception occurred retrieving job cluster list {}", (Object)e.getMessage());
    }

    @Override
    public void onJobClusterUpdateSLA(JobClusterManagerProto.UpdateJobClusterSLARequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.UpdateJobClusterSLAResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getClusterName() + " doesn't exist"), this.getSelf());
        }
    }

    @Override
    public void onJobClusterUpdateArtifact(JobClusterManagerProto.UpdateJobClusterArtifactRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.UpdateJobClusterArtifactResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getClusterName() + " doesn't exist"), this.getSelf());
        }
    }

    @Override
    public void onJobClusterUpdateSchedulingInfo(UpdateSchedulingInfo request) {
        ActorRef sender = this.getSender();
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.UpdateJobClusterArtifactResponse(request.getRequestId(), BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getClusterName() + " doesn't exist"), this.getSelf());
        }
    }

    @Override
    public void onJobClusterUpdateLabels(JobClusterManagerProto.UpdateJobClusterLabelsRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.UpdateJobClusterLabelsResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getClusterName() + " doesn't exist"), this.getSelf());
        }
    }

    @Override
    public void onJobClusterUpdateWorkerMigrationConfig(JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getClusterName() + " doesn't exist"), this.getSelf());
        }
    }

    @Override
    public void onJobClusterEnable(JobClusterManagerProto.EnableJobClusterRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.EnableJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getClusterName() + " doesn't exist"), this.getSelf());
        }
    }

    @Override
    public void onJobClusterDisable(JobClusterManagerProto.DisableJobClusterRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.DisableJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getClusterName() + " doesn't exist"), this.getSelf());
        }
    }

    @Override
    public void onGetJobDetailsRequest(JobClusterManagerProto.GetJobDetailsRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getJobId().getCluster());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.GetJobDetailsResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "Job " + request.getJobId().getId() + " doesn't exist", Optional.empty()), this.getSelf());
        }
    }

    @Override
    public void onGetJobStatusSubject(JobClusterManagerProto.GetJobSchedInfoRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getJobId().getCluster());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.GetJobSchedInfoResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getJobId().getCluster() + " doesn't exist", Optional.empty()), this.getSelf());
        }
    }

    @Override
    public void onGetLatestJobDiscoveryInfo(JobClusterManagerProto.GetLatestJobDiscoveryInfoRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getJobCluster());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.GetLatestJobDiscoveryInfoResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getJobCluster() + " doesn't exist", Optional.empty()), this.getSelf());
        }
    }

    @Override
    public void onJobListCompleted(JobClusterManagerProto.ListCompletedJobsInClusterRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getClusterName());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.ListCompletedJobsInClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getClusterName() + " doesn't exist", Lists.newArrayList()), this.getSelf());
        }
    }

    @Override
    public void onJobIdList(JobClusterManagerProto.ListJobIdsRequest request) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Enter onJobIdList");
        }
        ActorRef sender = this.getSender();
        this.jobListHelperActor.tell((Object)new JobListHelperActor.ListJobIdRequestWrapper(request, sender, this.jobClusterInfoManager.getAllJobClusterInfo()), this.getSelf());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Exit onJobIdList");
        }
    }

    @Override
    public void onListArchivedWorkers(JobClusterManagerProto.ListArchivedWorkersRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getJobId().getCluster());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            this.getSender().tell((Object)new JobClusterManagerProto.ListArchivedWorkersResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, "Job Cluster " + request.getJobId().getCluster() + " Not found", Lists.newArrayList()), this.getSelf());
        }
    }

    @Override
    public void onListActiveWorkers(JobClusterManagerProto.ListWorkersRequest request) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(request.getJobId().getCluster());
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)request, (ActorContext)this.getContext());
        } else {
            this.getSender().tell((Object)new JobClusterManagerProto.ListWorkersResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, "Job Cluster " + request.getJobId().getCluster() + " Not found", Lists.newArrayList()), this.getSelf());
        }
    }

    @Override
    public void onJobList(JobClusterManagerProto.ListJobsRequest request) {
        ActorRef sender = this.getSender();
        this.jobListHelperActor.tell((Object)new JobListHelperActor.ListJobRequestWrapper(request, sender, this.jobClusterInfoManager.getAllJobClusterInfo()), this.getSelf());
    }

    @Override
    public void onScaleStage(JobClusterManagerProto.ScaleStageRequest scaleStage) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(scaleStage.getJobId().getCluster());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)scaleStage, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.ScaleStageResponse(scaleStage.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + scaleStage.getJobId().getCluster() + " doesn't exist", 0), this.getSelf());
        }
    }

    @Override
    public void onResubmitWorker(JobClusterManagerProto.ResubmitWorkerRequest r) {
        Optional<JobClusterInfo> jobClusterInfo = this.jobClusterInfoManager.getJobClusterInfo(r.getJobId().getCluster());
        ActorRef sender = this.getSender();
        if (jobClusterInfo.isPresent()) {
            jobClusterInfo.get().jobClusterActor.forward((Object)r, (ActorContext)this.getContext());
        } else {
            sender.tell((Object)new JobClusterManagerProto.ResubmitWorkerResponse(r.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + r.getJobId().getCluster() + " doesn't exist"), this.getSelf());
        }
    }

    static class JobClusterInfo {
        private static final Logger logger = LoggerFactory.getLogger(JobClusterInfo.class);
        private JobClusterProto.InitializeJobClusterRequest initRequest;
        final String clusterName;
        final ActorRef jobClusterActor;
        private volatile JobClusterState currentState;
        volatile long stateUpdateTime;
        final IJobClusterDefinition jobClusterDefinition;

        JobClusterInfo(String clusterName, IJobClusterDefinition clusterDefn, ActorRef actor) {
            this.clusterName = clusterName;
            this.jobClusterActor = actor;
            this.jobClusterDefinition = clusterDefn;
            this.currentState = JobClusterState.UNINITIALIZED;
            this.stateUpdateTime = System.currentTimeMillis();
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public IJobClusterDefinition getJobClusterDefinition() {
            return this.jobClusterDefinition;
        }

        void markInitializing(JobClusterProto.InitializeJobClusterRequest req, long time) {
            if (this.currentState == JobClusterState.UNINITIALIZED) {
                this.stateUpdateTime = time;
                this.currentState = JobClusterState.INITIALIZING;
                this.initRequest = req;
            } else {
                logger.warn("Invalid state transition from {} to {} for job cluster {}", new Object[]{this.currentState, JobClusterState.INITIALIZING, this.clusterName});
            }
        }

        void markInitialized(long time) {
            if (this.currentState == JobClusterState.INITIALIZING) {
                this.stateUpdateTime = time;
                this.currentState = JobClusterState.INITIALIZED;
            } else {
                logger.warn("Invalid state transition from {} to {} for job cluster {}", new Object[]{this.currentState, JobClusterState.INITIALIZED, this.clusterName});
            }
        }

        void markDeleting(long time) {
            this.currentState = JobClusterState.DELETING;
            this.stateUpdateTime = time;
        }

        void markDeleted(long time) {
            this.currentState = JobClusterState.DELETED;
            this.stateUpdateTime = time;
        }

        public String toString() {
            return "JobClusterInfo{clusterName='" + this.clusterName + '\'' + ", jobClusterActor=" + this.jobClusterActor + ", currentState=" + (Object)((Object)this.currentState) + ", stateUpdateTime=" + this.stateUpdateTime + ", jobClusterDefinition=" + this.jobClusterDefinition + '}';
        }

        public static enum JobClusterState {
            UNINITIALIZED,
            INITIALIZING,
            INITIALIZED,
            DELETING,
            DELETED;

        }
    }

    public static final class UpdateSchedulingInfo {
        private final long requestId;
        private final String clusterName;
        private final SchedulingInfo schedulingInfo;
        private final String version;

        @ConstructorProperties(value={"requestId", "clusterName", "schedulingInfo", "version"})
        public UpdateSchedulingInfo(long requestId, String clusterName, SchedulingInfo schedulingInfo, String version) {
            this.requestId = requestId;
            this.clusterName = clusterName;
            this.schedulingInfo = schedulingInfo;
            this.version = version;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public SchedulingInfo getSchedulingInfo() {
            return this.schedulingInfo;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateSchedulingInfo)) {
                return false;
            }
            UpdateSchedulingInfo other = (UpdateSchedulingInfo)o;
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$clusterName = this.getClusterName();
            String other$clusterName = other.getClusterName();
            if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
                return false;
            }
            SchedulingInfo this$schedulingInfo = this.getSchedulingInfo();
            SchedulingInfo other$schedulingInfo = other.getSchedulingInfo();
            if (this$schedulingInfo == null ? other$schedulingInfo != null : !this$schedulingInfo.equals(other$schedulingInfo)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $clusterName = this.getClusterName();
            result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
            SchedulingInfo $schedulingInfo = this.getSchedulingInfo();
            result = result * 59 + ($schedulingInfo == null ? 43 : $schedulingInfo.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "JobClustersManagerActor.UpdateSchedulingInfo(requestId=" + this.getRequestId() + ", clusterName=" + this.getClusterName() + ", schedulingInfo=" + this.getSchedulingInfo() + ", version=" + this.getVersion() + ")";
        }
    }

    class JobClusterInfoManager {
        private final Map<String, JobClusterInfo> jobClusterNameToInfoMap = new HashMap<String, JobClusterInfo>();
        private final LifecycleEventPublisher eventPublisher;
        private MantisSchedulerFactory mantisSchedulerFactory;
        private final MantisJobStore jobStore;
        private final Metrics metrics;
        private final CostsCalculator costsCalculator;

        JobClusterInfoManager(MantisJobStore jobStore, MantisSchedulerFactory mantisSchedulerFactory, LifecycleEventPublisher eventPublisher, CostsCalculator costsCalculator) {
            this.eventPublisher = eventPublisher;
            this.mantisSchedulerFactory = mantisSchedulerFactory;
            this.jobStore = jobStore;
            this.costsCalculator = costsCalculator;
            MetricGroupId metricGroupId = new MetricGroupId("JobClusterInfoManager");
            Metrics m = new Metrics.Builder().id(metricGroupId).addGauge((Gauge)new GaugeCallback(metricGroupId, "jobClustersGauge", () -> 1.0 * (double)this.jobClusterNameToInfoMap.size())).build();
            this.metrics = MetricsRegistry.getInstance().registerAndGet(m);
        }

        Optional<JobClusterInfo> createClusterActorAndRegister(IJobClusterDefinition jobClusterDefn) {
            String clusterName = jobClusterDefn.getName();
            if (!this.isClusterExists(clusterName)) {
                if (!ActorPaths.isValidPathElement((String)clusterName)) {
                    JobClustersManagerActor.this.logger.error("Cannot create actor for cluster with invalid name {}", (Object)clusterName);
                    return Optional.empty();
                }
                ActorRef jobClusterActor = JobClustersManagerActor.this.getContext().actorOf(JobClusterActor.props(clusterName, this.jobStore, this.mantisSchedulerFactory, this.eventPublisher, this.costsCalculator), "JobClusterActor-" + clusterName);
                JobClustersManagerActor.this.getContext().watch(jobClusterActor);
                JobClusterInfo jobClusterInfo = new JobClusterInfo(clusterName, jobClusterDefn, jobClusterActor);
                this.jobClusterNameToInfoMap.put(clusterName, jobClusterInfo);
                return Optional.ofNullable(jobClusterInfo);
            }
            return Optional.ofNullable(this.jobClusterNameToInfoMap.get(clusterName));
        }

        void deregisterJobCluster(String jobClusterName) {
            Optional<JobClusterInfo> jobClusterInfo = this.getJobClusterInfo(jobClusterName);
            if (jobClusterInfo.isPresent()) {
                jobClusterInfo.get().markDeleted(System.currentTimeMillis());
                ActorRef jobClusterActor = jobClusterInfo.get().jobClusterActor;
                JobClustersManagerActor.this.getContext().unwatch(jobClusterActor);
                JobClustersManagerActor.this.getContext().stop(jobClusterActor);
                this.jobClusterNameToInfoMap.remove(jobClusterName);
            } else {
                JobClustersManagerActor.this.logger.warn("Job Cluster does not exist {}", jobClusterInfo);
            }
        }

        Observable<JobClusterProto.InitializeJobClusterResponse> initializeCluster(JobClusterInfo jobClusterInfo, JobClusterProto.InitializeJobClusterRequest req, Duration t) {
            jobClusterInfo.markInitializing(req, System.currentTimeMillis());
            CompletionStage<JobClusterProto.InitializeJobClusterResponse> respCS = PatternsCS.ask((ActorRef)jobClusterInfo.jobClusterActor, (Object)req, (Duration)t).thenApply(JobClusterProto.InitializeJobClusterResponse.class::cast);
            return Observable.from(respCS.toCompletableFuture(), (Scheduler)Schedulers.io()).map(resp -> {
                JobClustersManagerActor.this.logger.info("JobCluster {} inited with code {}", (Object)resp.jobClusterName, (Object)resp.responseCode);
                Optional<JobClusterInfo> jClusterInfo = JobClustersManagerActor.this.jobClusterInfoManager.getJobClusterInfo(resp.jobClusterName);
                if (resp.responseCode == BaseResponse.ResponseCode.SUCCESS) {
                    jClusterInfo.ifPresent(jci -> jci.markInitialized(System.currentTimeMillis()));
                }
                return resp;
            }).onErrorResumeNext(ex -> {
                JobClustersManagerActor.this.logger.warn("caught exception {}", (Object)ex.getMessage(), ex);
                JobClustersManagerActor.this.numJobClusterInitFailures.increment();
                this.deregisterJobCluster(jobClusterInfo.clusterName);
                return Observable.just((Object)new JobClusterProto.InitializeJobClusterResponse(req.requestId, BaseResponse.ResponseCode.SERVER_ERROR, ex.getMessage(), jobClusterInfo.clusterName, ActorRef.noSender()));
            });
        }

        void initializeClusterAsync(JobClusterInfo jobClusterInfo, JobClusterProto.InitializeJobClusterRequest req) {
            jobClusterInfo.markInitializing(req, System.currentTimeMillis());
            jobClusterInfo.jobClusterActor.tell((Object)req, JobClustersManagerActor.this.getSelf());
        }

        Optional<JobClusterInfo> getJobClusterInfo(String jobClusterName) {
            return Optional.ofNullable(this.jobClusterNameToInfoMap.get(jobClusterName));
        }

        Optional<JobDefinition> getArchivedJobDefinition(String jobId) {
            return this.jobStore.getArchivedJob(jobId).map(IMantisJobMetadata::getJobDefinition);
        }

        Map<String, JobClusterInfo> getAllJobClusterInfo() {
            return Collections.unmodifiableMap(this.jobClusterNameToInfoMap);
        }

        boolean isClusterExists(String clusterName) {
            return this.jobClusterNameToInfoMap.containsKey(clusterName);
        }

        void processInitializeResponse(JobClusterProto.InitializeJobClusterResponse createResp) {
            Optional<JobClusterInfo> jClusterInfo = this.getJobClusterInfo(createResp.jobClusterName);
            if (jClusterInfo.isPresent()) {
                JobClusterInfo jobClusterInfo = jClusterInfo.get();
                if (createResp.responseCode == BaseResponse.ResponseCode.SUCCESS) {
                    jobClusterInfo.markInitialized(System.currentTimeMillis());
                    createResp.requestor.tell((Object)new JobClusterManagerProto.CreateJobClusterResponse(createResp.requestId, BaseResponse.ResponseCode.SUCCESS_CREATED, createResp.jobClusterName + " created", createResp.jobClusterName), JobClustersManagerActor.this.getSelf());
                } else if (createResp.responseCode == BaseResponse.ResponseCode.SERVER_ERROR) {
                    this.deregisterJobCluster(createResp.jobClusterName);
                    createResp.requestor.tell((Object)new JobClusterManagerProto.CreateJobClusterResponse(createResp.requestId, createResp.responseCode, createResp.message, createResp.jobClusterName), JobClustersManagerActor.this.getSelf());
                }
            } else {
                JobClustersManagerActor.this.logger.warn("Received JobClusterInitializeResponse {} for unknown Job Cluster {}", (Object)createResp, (Object)createResp.jobClusterName);
            }
        }

        void processDeleteRequest(JobClusterManagerProto.DeleteJobClusterRequest request) {
            Optional<JobClusterInfo> jobClusterInfoOp = this.getJobClusterInfo(request.getName());
            ActorRef sender = JobClustersManagerActor.this.getSender();
            if (jobClusterInfoOp.isPresent()) {
                JobClusterInfo jobClusterInfo = jobClusterInfoOp.get();
                jobClusterInfo.jobClusterActor.tell((Object)new JobClusterProto.DeleteJobClusterRequest(request.getUser(), request.getName(), sender), JobClustersManagerActor.this.getSelf());
                jobClusterInfo.markDeleting(System.currentTimeMillis());
            } else {
                sender.tell((Object)new JobClusterManagerProto.DeleteJobClusterResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, "JobCluster " + request.getName() + " doesn't exist"), JobClustersManagerActor.this.getSelf());
            }
        }

        void processDeleteResponse(JobClusterProto.DeleteJobClusterResponse resp) {
            Optional<JobClusterInfo> jobClusterInfoOp = this.getJobClusterInfo(resp.clusterName);
            if (jobClusterInfoOp.isPresent()) {
                if (resp.responseCode == BaseResponse.ResponseCode.SUCCESS) {
                    this.deregisterJobCluster(resp.clusterName);
                }
            } else {
                JobClustersManagerActor.this.logger.warn("Received delete job cluster response {} for unknown job cluster {}", (Object)resp, (Object)resp.clusterName);
            }
            resp.requestingActor.tell((Object)new JobClusterManagerProto.DeleteJobClusterResponse(resp.requestId, resp.responseCode, resp.message), JobClustersManagerActor.this.getSelf());
        }
    }
}

