/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.akka;

import akka.actor.ActorRef;
import akka.dispatch.Envelope;
import akka.dispatch.MessageQueue;
import akka.dispatch.UnboundedMessageQueueSemantics;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import io.mantisrx.common.metrics.spectator.SpectatorRegistryFactory;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class MeteredMessageQueue
implements MessageQueue,
UnboundedMessageQueueSemantics {
    private final String path;
    private final Counter insertCounter;
    private final Timer waitTimer;
    private final ConcurrentLinkedQueue<Entry> queue = new ConcurrentLinkedQueue();

    public MeteredMessageQueue(String path) {
        Registry registry = SpectatorRegistryFactory.getRegistry();
        this.path = path;
        this.insertCounter = registry.counter("akka.queue.insert", new String[]{"path", path});
        this.waitTimer = registry.timer("akka.queue.wait", new String[]{"path", path});
        ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("akka.queue.size")).withTag("path", path)).monitorSize(this.queue);
    }

    public void enqueue(ActorRef receiver, Envelope handle) {
        this.insertCounter.increment();
        this.queue.offer(new Entry(handle));
    }

    public Envelope dequeue() {
        Entry tmp = this.queue.poll();
        if (tmp == null) {
            return null;
        }
        long dur = System.nanoTime() - tmp.t;
        this.waitTimer.record(dur, TimeUnit.NANOSECONDS);
        return tmp.v;
    }

    public int numberOfMessages() {
        return this.queue.size();
    }

    public boolean hasMessages() {
        return !this.queue.isEmpty();
    }

    public void cleanUp(ActorRef owner, MessageQueue deadLetters) {
        this.queue.clear();
    }

    static final class Entry {
        private final Envelope v;
        private final long t;

        Entry(Envelope v) {
            this.v = v;
            this.t = System.nanoTime();
        }
    }
}

