/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.http.javadsl.Http;
import akka.http.javadsl.ServerBinding;
import akka.http.javadsl.settings.ServerSettings;
import akka.http.javadsl.settings.WebSocketSettings;
import akka.japi.function.Procedure;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.Flow;
import akka.stream.javadsl.Sink;
import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.master.api.akka.route.MantisMasterRoute;
import io.mantisrx.master.api.akka.route.MasterApiMetrics;
import io.mantisrx.master.api.akka.route.handlers.JobArtifactRouteHandlerImpl;
import io.mantisrx.master.api.akka.route.handlers.JobClusterRouteHandlerAkkaImpl;
import io.mantisrx.master.api.akka.route.handlers.JobDiscoveryRouteHandlerAkkaImpl;
import io.mantisrx.master.api.akka.route.handlers.JobRouteHandlerAkkaImpl;
import io.mantisrx.master.api.akka.route.handlers.JobStatusRouteHandlerAkkaImpl;
import io.mantisrx.master.api.akka.route.handlers.ResourceClusterRouteHandlerAkkaImpl;
import io.mantisrx.master.api.akka.route.v0.JobClusterRoute;
import io.mantisrx.master.api.akka.route.v0.JobDiscoveryRoute;
import io.mantisrx.master.api.akka.route.v0.JobRoute;
import io.mantisrx.master.api.akka.route.v0.JobStatusRoute;
import io.mantisrx.master.api.akka.route.v0.MasterDescriptionRoute;
import io.mantisrx.master.api.akka.route.v1.AdminMasterRoute;
import io.mantisrx.master.api.akka.route.v1.JobArtifactsRoute;
import io.mantisrx.master.api.akka.route.v1.JobClustersRoute;
import io.mantisrx.master.api.akka.route.v1.JobDiscoveryStreamRoute;
import io.mantisrx.master.api.akka.route.v1.JobStatusStreamRoute;
import io.mantisrx.master.api.akka.route.v1.JobsRoute;
import io.mantisrx.master.api.akka.route.v1.LastSubmittedJobIdStreamRoute;
import io.mantisrx.master.events.LifecycleEventPublisher;
import io.mantisrx.server.core.BaseService;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.server.master.ILeadershipManager;
import io.mantisrx.server.master.LeaderRedirectionFilter;
import io.mantisrx.server.master.persistence.IMantisPersistenceProvider;
import io.mantisrx.server.master.resourcecluster.ResourceClusters;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

public class MasterApiAkkaService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(MasterApiAkkaService.class);
    private final MasterMonitor masterMonitor;
    private final MasterDescription masterDescription;
    private final ActorRef jobClustersManagerActor;
    private final ActorRef resourceClustersHostManagerActor;
    private final ResourceClusters resourceClusters;
    private final ActorRef statusEventBrokerActor;
    private final int port;
    private final IMantisPersistenceProvider storageProvider;
    private final LifecycleEventPublisher lifecycleEventPublisher;
    private final MantisMasterRoute mantisMasterRoute;
    private final ILeadershipManager leadershipManager;
    private final ActorSystem system;
    private final Materializer materializer;
    private final ExecutorService executorService;
    private final CountDownLatch serviceLatch = new CountDownLatch(1);

    public MasterApiAkkaService(MasterMonitor masterMonitor, MasterDescription masterDescription, ActorRef jobClustersManagerActor, ActorRef statusEventBrokerActor, ResourceClusters resourceClusters, ActorRef resourceClustersHostManagerActor, int serverPort, IMantisPersistenceProvider mantisStorageProvider, LifecycleEventPublisher lifecycleEventPublisher, ILeadershipManager leadershipManager) {
        super(true);
        Preconditions.checkNotNull((Object)masterMonitor, (String)"MasterMonitor");
        Preconditions.checkNotNull((Object)masterDescription, (String)"masterDescription");
        Preconditions.checkNotNull((Object)jobClustersManagerActor, (String)"jobClustersManagerActor");
        Preconditions.checkNotNull((Object)statusEventBrokerActor, (String)"statusEventBrokerActor");
        Preconditions.checkNotNull((Object)mantisStorageProvider, (String)"mantisStorageProvider");
        Preconditions.checkNotNull((Object)lifecycleEventPublisher, (String)"lifecycleEventPublisher");
        Preconditions.checkNotNull((Object)leadershipManager, (String)"leadershipManager");
        this.masterMonitor = masterMonitor;
        this.masterDescription = masterDescription;
        this.jobClustersManagerActor = jobClustersManagerActor;
        this.resourceClustersHostManagerActor = resourceClustersHostManagerActor;
        this.statusEventBrokerActor = statusEventBrokerActor;
        this.resourceClusters = resourceClusters;
        this.port = serverPort;
        this.storageProvider = mantisStorageProvider;
        this.lifecycleEventPublisher = lifecycleEventPublisher;
        this.leadershipManager = leadershipManager;
        this.system = ActorSystem.create((String)"MasterApiActorSystem");
        this.materializer = Materializer.createMaterializer((ClassicActorSystemProvider)this.system);
        this.mantisMasterRoute = this.configureApiRoutes(this.system);
        this.executorService = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "MasterApiAkkaServiceThread");
            t.setDaemon(true);
            return t;
        });
        this.executorService.execute(() -> {
            try {
                this.startAPIServer();
            }
            catch (Exception e) {
                logger.warn("caught exception starting API server", (Throwable)e);
            }
        });
    }

    private MantisMasterRoute configureApiRoutes(ActorSystem actorSystem) {
        JobClusterRouteHandlerAkkaImpl jobClusterRouteHandler = new JobClusterRouteHandlerAkkaImpl(this.jobClustersManagerActor);
        JobRouteHandlerAkkaImpl jobRouteHandler = new JobRouteHandlerAkkaImpl(this.jobClustersManagerActor);
        MasterDescriptionRoute masterDescriptionRoute = new MasterDescriptionRoute(this.masterDescription);
        JobRoute v0JobRoute = new JobRoute(jobRouteHandler, actorSystem);
        java.time.Duration idleTimeout = actorSystem.settings().config().getDuration("akka.http.server.idle-timeout");
        logger.info("idle timeout {} sec ", (Object)idleTimeout.getSeconds());
        JobStatusRouteHandlerAkkaImpl jobStatusRouteHandler = new JobStatusRouteHandlerAkkaImpl(actorSystem, this.statusEventBrokerActor);
        JobDiscoveryRouteHandlerAkkaImpl jobDiscoveryRouteHandler = new JobDiscoveryRouteHandlerAkkaImpl(this.jobClustersManagerActor, idleTimeout);
        JobDiscoveryRoute v0JobDiscoveryRoute = new JobDiscoveryRoute(jobDiscoveryRouteHandler);
        JobClusterRoute v0JobClusterRoute = new JobClusterRoute(jobClusterRouteHandler, jobRouteHandler, actorSystem);
        JobStatusRoute v0JobStatusRoute = new JobStatusRoute(jobStatusRouteHandler);
        JobClustersRoute v1JobClusterRoute = new JobClustersRoute(jobClusterRouteHandler, actorSystem);
        JobsRoute v1JobsRoute = new JobsRoute(jobClusterRouteHandler, jobRouteHandler, actorSystem);
        AdminMasterRoute v1AdminMasterRoute = new AdminMasterRoute(this.masterDescription);
        JobDiscoveryStreamRoute v1JobDiscoveryStreamRoute = new JobDiscoveryStreamRoute(jobDiscoveryRouteHandler);
        LastSubmittedJobIdStreamRoute v1LastSubmittedJobIdStreamRoute = new LastSubmittedJobIdStreamRoute(jobDiscoveryRouteHandler);
        JobStatusStreamRoute v1JobStatusStreamRoute = new JobStatusStreamRoute(jobStatusRouteHandler);
        JobArtifactRouteHandlerImpl jobArtifactRouteHandler = new JobArtifactRouteHandlerImpl(this.storageProvider);
        JobArtifactsRoute v1JobArtifactsRoute = new JobArtifactsRoute(jobArtifactRouteHandler);
        LeaderRedirectionFilter leaderRedirectionFilter = new LeaderRedirectionFilter(this.masterMonitor, this.leadershipManager);
        ResourceClusterRouteHandlerAkkaImpl resourceClusterRouteHandler = new ResourceClusterRouteHandlerAkkaImpl(this.resourceClustersHostManagerActor);
        return new MantisMasterRoute(actorSystem, leaderRedirectionFilter, masterDescriptionRoute, v0JobClusterRoute, v0JobRoute, v0JobDiscoveryRoute, v0JobStatusRoute, v1JobClusterRoute, v1JobsRoute, v1JobArtifactsRoute, v1AdminMasterRoute, v1JobDiscoveryStreamRoute, v1LastSubmittedJobIdStreamRoute, v1JobStatusStreamRoute, this.resourceClusters, resourceClusterRouteHandler);
    }

    private void startAPIServer() {
        Flow routeFlow = this.mantisMasterRoute.createRoute().flow(this.system, this.materializer);
        ServerSettings defaultSettings = ServerSettings.create((ActorSystem)this.system);
        java.time.Duration idleTimeout = this.system.settings().config().getDuration("akka.http.server.idle-timeout");
        logger.info("idle timeout {} sec ", (Object)idleTimeout.getSeconds());
        WebSocketSettings customWebsocketSettings = defaultSettings.getWebsocketSettings().withPeriodicKeepAliveMaxIdle((Duration)Duration.create((long)(idleTimeout.getSeconds() - 1L), (TimeUnit)TimeUnit.SECONDS)).withPeriodicKeepAliveMode("pong");
        ServerSettings customServerSettings = defaultSettings.withWebsocketSettings(customWebsocketSettings);
        CompletionStage<ServerBinding> binding = ((CompletionStage)Http.get((ActorSystem)this.system).newServerAt("0.0.0.0", this.port).withSettings(customServerSettings).connectionSource().to((Graph)Sink.foreach((Procedure & Serializable)connection -> {
            MasterApiMetrics.getInstance().incrementIncomingRequestCount();
            connection.handleWith(routeFlow, this.materializer);
        })).run(this.materializer)).exceptionally(failure -> {
            System.err.println("API service exited, committing suicide !" + failure.getMessage());
            logger.info("Master API service exited in error, committing suicide !");
            this.system.terminate();
            System.exit(2);
            return null;
        });
        logger.info("Starting Mantis Master API on port {}", (Object)this.port);
        try {
            this.serviceLatch.await();
        }
        catch (InterruptedException e) {
            logger.error("Master API thread interrupted, committing suicide", (Throwable)e);
            System.exit(2);
        }
        binding.thenCompose(ServerBinding::unbind).thenAccept(unbound -> {
            logger.error("Master API service unbind, committing suicide");
            this.system.terminate();
            System.exit(2);
        });
    }

    public void start() {
        super.awaitActiveModeAndStart(() -> {
            logger.info("marking leader READY");
            this.leadershipManager.setLeaderReady();
        });
    }

    public void shutdown() {
        super.shutdown();
        logger.info("Shutting down Mantis Master API");
        this.serviceLatch.countDown();
        this.executorService.shutdownNow();
        this.system.terminate();
    }
}

