/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.handlers;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.http.javadsl.model.ws.Message;
import akka.http.scaladsl.model.ws.TextMessage;
import akka.japi.function.Function;
import akka.stream.Graph;
import akka.stream.OverflowStrategy;
import akka.stream.javadsl.Flow;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.handlers.JobStatusRouteHandler;
import io.mantisrx.master.events.JobStatusConnectedWSActor;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusRouteHandlerAkkaImpl
implements JobStatusRouteHandler {
    private static final Logger logger = LoggerFactory.getLogger(JobStatusRouteHandlerAkkaImpl.class);
    private final ActorRef statusEventBrokerActor;
    private final ActorSystem actorSystem;

    public JobStatusRouteHandlerAkkaImpl(ActorSystem actorSystem, ActorRef statusEventBrokerActor) {
        this.actorSystem = actorSystem;
        this.statusEventBrokerActor = statusEventBrokerActor;
    }

    @Override
    public Flow<Message, Message, NotUsed> jobStatus(String jobId) {
        ActorRef jobStatusConnectedWSActor = this.actorSystem.actorOf(JobStatusConnectedWSActor.props(jobId, this.statusEventBrokerActor), "JobStatusConnectedWSActor-" + jobId + "-" + System.currentTimeMillis());
        Sink incomingMessagesIgnored = Flow.create().to((Graph)Sink.ignore());
        Source backToWebSocket = Source.actorRef((int)100, (OverflowStrategy)OverflowStrategy.dropHead()).mapMaterializedValue((Function & Serializable)outgoingActor -> {
            jobStatusConnectedWSActor.tell((Object)new JobStatusConnectedWSActor.Connected((ActorRef)outgoingActor), ActorRef.noSender());
            return NotUsed.getInstance();
        }).map((Function & Serializable)js -> new TextMessage.Strict(Jackson.toJson(js)));
        return Flow.fromSinkAndSource((Graph)incomingMessagesIgnored, (Graph)backToWebSocket);
    }
}

