/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.handlers;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import io.mantisrx.master.api.akka.route.handlers.ResourceClusterRouteHandler;
import io.mantisrx.master.resourcecluster.proto.GetResourceClusterSpecRequest;
import io.mantisrx.master.resourcecluster.proto.ListResourceClusterRequest;
import io.mantisrx.master.resourcecluster.proto.ProvisionResourceClusterRequest;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterAPIProto;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterScaleRuleProto;
import io.mantisrx.master.resourcecluster.proto.ScaleResourceRequest;
import io.mantisrx.master.resourcecluster.proto.ScaleResourceResponse;
import io.mantisrx.master.resourcecluster.proto.UpgradeClusterContainersRequest;
import io.mantisrx.master.resourcecluster.proto.UpgradeClusterContainersResponse;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClusterRouteHandlerAkkaImpl
implements ResourceClusterRouteHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceClusterRouteHandlerAkkaImpl.class);
    private final ActorRef resourceClustersHostManagerActor;
    private final Duration timeout;
    private final Duration longOperationTimeout;

    public ResourceClusterRouteHandlerAkkaImpl(ActorRef resourceClustersHostManagerActor) {
        this.resourceClustersHostManagerActor = resourceClustersHostManagerActor;
        this.timeout = Duration.ofMillis(ConfigurationProvider.getConfig().getMasterApiAskTimeoutMs());
        this.longOperationTimeout = Duration.ofMillis(ConfigurationProvider.getConfig().getMasterApiLongOperationAskTimeoutMs());
    }

    @Override
    public CompletionStage<ResourceClusterAPIProto.ListResourceClustersResponse> get(ListResourceClusterRequest request) {
        CompletionStage<ResourceClusterAPIProto.ListResourceClustersResponse> response = Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)request, (Duration)this.timeout).thenApply(ResourceClusterAPIProto.ListResourceClustersResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<ResourceClusterAPIProto.GetResourceClusterResponse> create(ProvisionResourceClusterRequest request) {
        CompletionStage<ResourceClusterAPIProto.GetResourceClusterResponse> response = Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)request, (Duration)this.timeout).thenApply(ResourceClusterAPIProto.GetResourceClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<ResourceClusterAPIProto.DeleteResourceClusterResponse> delete(ClusterID clusterId) {
        CompletionStage<ResourceClusterAPIProto.DeleteResourceClusterResponse> response = Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)ResourceClusterAPIProto.DeleteResourceClusterRequest.builder().clusterId(clusterId).build(), (Duration)this.timeout).thenApply(ResourceClusterAPIProto.DeleteResourceClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<ResourceClusterAPIProto.GetResourceClusterResponse> get(GetResourceClusterSpecRequest request) {
        CompletionStage<ResourceClusterAPIProto.GetResourceClusterResponse> response = Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)request, (Duration)this.timeout).thenApply(ResourceClusterAPIProto.GetResourceClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<ScaleResourceResponse> scale(ScaleResourceRequest request) {
        CompletionStage<ScaleResourceResponse> response = Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)request, (Duration)this.longOperationTimeout).thenApply(ScaleResourceResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<UpgradeClusterContainersResponse> upgrade(UpgradeClusterContainersRequest request) {
        CompletionStage<UpgradeClusterContainersResponse> response = Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)request, (Duration)this.longOperationTimeout).thenApply(UpgradeClusterContainersResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse> createSingleScaleRule(ResourceClusterScaleRuleProto.CreateResourceClusterScaleRuleRequest request) {
        return Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)request, (Duration)this.timeout).thenApply(ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse.class::cast);
    }

    @Override
    public CompletionStage<ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse> createAllScaleRule(ResourceClusterScaleRuleProto.CreateAllResourceClusterScaleRulesRequest request) {
        return Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)request, (Duration)this.timeout).thenApply(ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse.class::cast);
    }

    @Override
    public CompletionStage<ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse> getClusterScaleRules(ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesRequest request) {
        return Patterns.ask((ActorRef)this.resourceClustersHostManagerActor, (Object)request, (Duration)this.timeout).thenApply(ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse.class::cast);
    }
}

