/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.proto;

import io.mantisrx.common.Label;
import io.mantisrx.master.jobcluster.LabelManager;
import io.mantisrx.master.jobcluster.MantisJobClusterMetadataView;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.master.jobcluster.job.MantisJobMetadataView;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.runtime.MantisJobDefinition;
import io.mantisrx.runtime.MantisJobDurationType;
import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.runtime.NamedJobDefinition;
import io.mantisrx.runtime.command.InvalidJobException;
import io.mantisrx.server.master.domain.DataFormatAdapter;
import io.mantisrx.server.master.domain.IJobClusterDefinition;
import io.mantisrx.server.master.domain.JobClusterConfig;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.server.master.domain.JobDefinition;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.domain.SLA;
import io.mantisrx.server.master.http.api.CompactJobInfo;
import io.mantisrx.server.master.http.api.JobClusterInfo;
import io.mantisrx.server.master.store.MantisJobMetadata;
import io.mantisrx.server.master.store.MantisStageMetadata;
import io.mantisrx.server.master.store.MantisWorkerMetadata;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.google.common.base.Strings;
import io.mantisrx.shaded.com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class JobClusterProtoAdapter {
    private JobClusterProtoAdapter() {
    }

    public static final JobClusterManagerProto.CreateJobClusterRequest toCreateJobClusterRequest(NamedJobDefinition njd) {
        MantisJobDefinition jd = njd.getJobDefinition();
        JobClusterManagerProto.CreateJobClusterRequest request = new JobClusterManagerProto.CreateJobClusterRequest(new JobClusterDefinitionImpl(jd.getName(), Arrays.asList(new JobClusterConfig(jd.getJobJarFileLocation().toString(), System.currentTimeMillis(), jd.getVersion(), jd.getSchedulingInfo())), njd.getOwner(), jd.getUser(), new SLA(jd.getSlaMin(), jd.getSlaMax(), jd.getCronSpec(), jd.getCronPolicy() == NamedJobDefinition.CronPolicy.KEEP_EXISTING ? IJobClusterDefinition.CronPolicy.KEEP_EXISTING : IJobClusterDefinition.CronPolicy.KEEP_NEW), jd.getMigrationConfig(), jd.getIsReadyForJobMaster(), jd.getParameters(), JobClusterProtoAdapter.processLabels(jd)), "user");
        return request;
    }

    public static final JobClusterManagerProto.UpdateJobClusterRequest toUpdateJobClusterRequest(NamedJobDefinition njd) {
        MantisJobDefinition jd = njd.getJobDefinition();
        JobClusterManagerProto.UpdateJobClusterRequest request = new JobClusterManagerProto.UpdateJobClusterRequest(new JobClusterDefinitionImpl(jd.getName(), Arrays.asList(new JobClusterConfig(jd.getJobJarFileLocation().toString(), System.currentTimeMillis(), jd.getVersion(), jd.getSchedulingInfo())), njd.getOwner(), jd.getUser(), new SLA(jd.getSlaMin(), jd.getSlaMax(), jd.getCronSpec(), jd.getCronPolicy() == NamedJobDefinition.CronPolicy.KEEP_EXISTING ? IJobClusterDefinition.CronPolicy.KEEP_EXISTING : IJobClusterDefinition.CronPolicy.KEEP_NEW), jd.getMigrationConfig(), jd.getIsReadyForJobMaster(), jd.getParameters(), JobClusterProtoAdapter.processLabels(jd)), "user");
        return request;
    }

    public static final JobClusterManagerProto.SubmitJobRequest toSubmitJobClusterRequest(MantisJobDefinition jd) throws InvalidJobException {
        JobClusterManagerProto.SubmitJobRequest request = new JobClusterManagerProto.SubmitJobRequest(jd.getName(), jd.getUser(), new JobDefinition(jd.getName(), jd.getUser(), DataFormatAdapter.extractArtifactName(jd.getJobJarFileLocation()).orElse(""), jd.getVersion(), jd.getParameters(), jd.getJobSla(), jd.getSubscriptionTimeoutSecs(), jd.getSchedulingInfo(), jd.getSchedulingInfo() == null ? -1 : jd.getSchedulingInfo().getStages().size(), JobClusterProtoAdapter.processLabels(jd), jd.getDeploymentStrategy()));
        return request;
    }

    public static JobClusterInfo toJobClusterInfo(MantisJobClusterMetadataView jobClusterMetadataView) {
        List<JobClusterInfo.JarInfo> jarInfoList = DataFormatAdapter.convertNamedJobJarListToJarInfoList(jobClusterMetadataView.getJars());
        JobClusterInfo jobClusterInfo = new JobClusterInfo(jobClusterMetadataView.getName(), jobClusterMetadataView.getSla(), jobClusterMetadataView.getOwner(), jobClusterMetadataView.isDisabled(), jobClusterMetadataView.isCronActive(), jarInfoList, jobClusterMetadataView.getParameters(), jobClusterMetadataView.getLabels());
        return jobClusterInfo;
    }

    protected static List<Label> processLabels(MantisJobDefinition jd) {
        HashMap<String, Label> labelMap = new HashMap<String, Label>();
        jd.getLabels().forEach(l -> labelMap.put(l.getName(), (Label)l));
        if (jd.getDeploymentStrategy() != null && !Strings.isNullOrEmpty((String)jd.getDeploymentStrategy().getResourceClusterId())) {
            Label rcLabel = new Label(LabelManager.SystemLabels.MANTIS_RESOURCE_CLUSTER_NAME_LABEL.label, jd.getDeploymentStrategy().getResourceClusterId());
            labelMap.put(rcLabel.getName(), rcLabel);
        }
        return ImmutableList.copyOf(labelMap.values());
    }

    private static MantisJobState toJobState(JobState state) {
        switch (state) {
            case Accepted: {
                return MantisJobState.Accepted;
            }
            case Launched: {
                return MantisJobState.Launched;
            }
            case Terminating_normal: 
            case Completed: {
                return MantisJobState.Completed;
            }
            case Terminating_abnormal: 
            case Failed: {
                return MantisJobState.Failed;
            }
            case Noop: {
                return MantisJobState.Noop;
            }
        }
        throw new IllegalArgumentException("cannot translate JobState to MantisJobState " + (Object)((Object)state));
    }

    public static final CompactJobInfo toCompactJobInfo(MantisJobMetadataView view) {
        MantisJobMetadata jm = view.getJobMetadata();
        int workers = 0;
        double totCPUs = 0.0;
        double totMem = 0.0;
        HashMap<String, Integer> stSmry = new HashMap<String, Integer>();
        for (MantisStageMetadata mantisStageMetadata : view.getStageMetadataList()) {
            workers += mantisStageMetadata.getNumWorkers();
            totCPUs += (double)mantisStageMetadata.getNumWorkers() * mantisStageMetadata.getMachineDefinition().getCpuCores();
            totMem += (double)mantisStageMetadata.getNumWorkers() * mantisStageMetadata.getMachineDefinition().getMemoryMB();
        }
        for (MantisWorkerMetadata mantisWorkerMetadata : view.getWorkerMetadataList()) {
            Integer prevVal = (Integer)stSmry.get(mantisWorkerMetadata.getState() + "");
            if (prevVal == null) {
                stSmry.put(mantisWorkerMetadata.getState() + "", 1);
                continue;
            }
            stSmry.put(mantisWorkerMetadata.getState() + "", prevVal + 1);
        }
        return new CompactJobInfo(jm.getJobId(), jm.getJarUrl() != null ? jm.getJarUrl().toString() : "", jm.getSubmittedAt(), view.getTerminatedAt(), jm.getUser(), jm.getState(), jm.getSla() != null ? jm.getSla().getDurationType() : MantisJobDurationType.Transient, jm.getNumStages(), workers, totCPUs, totMem, stSmry, jm.getLabels());
    }

    public static class JobIdInfo {
        private final String jobId;
        private final String version;
        private final MantisJobState state;
        private final String submittedAt;
        private final String terminatedAt;
        private final String user;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public JobIdInfo(@JsonProperty(value="jobId") String jobId, @JsonProperty(value="version") String version, @JsonProperty(value="state") MantisJobState state, @JsonProperty(value="submittedAt") String submittedAt, @JsonProperty(value="terminatedAt") String terminatedAt, @JsonProperty(value="user") String user) {
            this.jobId = jobId;
            this.version = version;
            this.state = state;
            this.submittedAt = submittedAt;
            this.terminatedAt = terminatedAt;
            this.user = user;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getVersion() {
            return this.version;
        }

        public MantisJobState getState() {
            return this.state;
        }

        public String getSubmittedAt() {
            return this.submittedAt;
        }

        public String getTerminatedAt() {
            return this.terminatedAt;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return "JobIdInfo{jobId='" + this.jobId + '\'' + ", version='" + this.version + '\'' + ", state=" + this.state + ", submittedAt='" + this.submittedAt + '\'' + ", terminatedAt='" + this.terminatedAt + '\'' + ", user='" + this.user + '\'' + '}';
        }

        public static class Builder {
            private String jobId;
            private String version;
            private MantisJobState state;
            private String submittedAt = "";
            private String terminatedAt = "";
            private String user = "";

            public Builder withJobIdStr(String jobId) {
                this.jobId = jobId;
                return this;
            }

            public Builder withJobId(JobId jId) {
                this.jobId = jId.getId();
                return this;
            }

            public Builder withJobState(JobState st) {
                this.state = JobClusterProtoAdapter.toJobState(st);
                return this;
            }

            public Builder withVersion(String version) {
                this.version = version;
                return this;
            }

            public Builder withSubmittedAt(long time) {
                this.submittedAt = Long.toString(time);
                return this;
            }

            public Builder withTerminatedAt(long time) {
                if (time != -1L) {
                    this.terminatedAt = Long.toString(time);
                }
                return this;
            }

            public Builder withUser(String user) {
                this.user = user;
                return this;
            }

            public JobIdInfo build() {
                return new JobIdInfo(this.jobId, this.version, this.state, this.submittedAt, this.terminatedAt, this.user);
            }
        }
    }
}

