/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v0;

import akka.actor.ActorSystem;
import akka.http.caching.javadsl.Cache;
import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.HttpMethods;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.Uri;
import akka.http.javadsl.server.ExceptionHandler;
import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.RequestContext;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.RouteResult;
import akka.http.javadsl.server.directives.CachingDirectives;
import akka.http.javadsl.unmarshalling.StringUnmarshallers;
import akka.http.javadsl.unmarshalling.Unmarshaller;
import akka.japi.JavaPartialFunction;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.handlers.JobRouteHandler;
import io.mantisrx.master.api.akka.route.proto.JobClusterProtoAdapter;
import io.mantisrx.master.api.akka.route.utils.JobRouteUtils;
import io.mantisrx.master.api.akka.route.v0.BaseRoute;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.MantisJobMetadataView;
import io.mantisrx.master.jobcluster.job.worker.WorkerHeartbeat;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.server.core.PostJobStatusRequest;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.server.master.domain.DataFormatAdapter;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(JobRoute.class);
    private final JobRouteHandler jobRouteHandler;
    private final Metrics metrics;
    private final Counter jobListGET;
    private final Counter jobListJobIdGET;
    private final Counter jobListRegexGET;
    private final Counter jobListLabelMatchGET;
    private final Counter jobArchivedWorkersGET;
    private final Counter jobArchivedWorkersGETInvalid;
    private final Counter workerHeartbeatStatusPOST;
    private final Counter workerHeartbeatSkipped;
    private final Cache<Uri, RouteResult> cache;
    private final JavaPartialFunction<RequestContext, Uri> requestUriKeyer = new JavaPartialFunction<RequestContext, Uri>(){

        public Uri apply(RequestContext in, boolean isCheck) {
            boolean isGet;
            HttpRequest request = in.getRequest();
            boolean bl = isGet = request.method() == HttpMethods.GET;
            if (isGet) {
                return request.getUri();
            }
            throw 1.noMatch();
        }
    };
    private static final PathMatcher0 API_JOBS = PathMatchers.segment((String)"api").slash("jobs");
    private static final HttpHeader ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = HttpHeader.parse((String)"Access-Control-Allow-Origin", (String)"*");
    private static final Iterable<HttpHeader> DEFAULT_RESPONSE_HEADERS = Arrays.asList(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
    public static final String KILL_ENDPOINT = "kill";
    public static final String RESUBMIT_WORKER_ENDPOINT = "resubmitWorker";
    public static final String SCALE_STAGE_ENDPOINT = "scaleStage";
    public static final PathMatcher0 STATUS_ENDPOINT = PathMatchers.segment((String)"api").slash("postjobstatus");

    public JobRoute(JobRouteHandler jobRouteHandler, ActorSystem actorSystem) {
        this.jobRouteHandler = jobRouteHandler;
        MasterConfiguration config = ConfigurationProvider.getConfig();
        this.cache = this.createCache(actorSystem, config.getApiCacheMinSize(), config.getApiCacheMaxSize(), config.getApiCacheTtlMilliseconds());
        Metrics m = new Metrics.Builder().id("V0JobRoute", new Tag[0]).addCounter("jobListGET").addCounter("jobListJobIdGET").addCounter("jobListRegexGET").addCounter("jobListLabelMatchGET").addCounter("jobArchivedWorkersGET").addCounter("jobArchivedWorkersGETInvalid").addCounter("workerHeartbeatStatusPOST").addCounter("workerHeartbeatSkipped").build();
        this.metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.jobListGET = this.metrics.getCounter("jobListGET");
        this.jobListJobIdGET = this.metrics.getCounter("jobListJobIdGET");
        this.jobListRegexGET = this.metrics.getCounter("jobListRegexGET");
        this.jobListLabelMatchGET = this.metrics.getCounter("jobListLabelMatchGET");
        this.jobArchivedWorkersGET = this.metrics.getCounter("jobArchivedWorkersGET");
        this.jobArchivedWorkersGETInvalid = this.metrics.getCounter("jobArchivedWorkersGETInvalid");
        this.workerHeartbeatStatusPOST = this.metrics.getCounter("workerHeartbeatStatusPOST");
        this.workerHeartbeatSkipped = this.metrics.getCounter("workerHeartbeatSkipped");
    }

    private Route jobListRoute(Optional<String> regex) {
        return this.parameterOptional(StringUnmarshallers.BOOLEAN, "jobIdsOnly", jobIdsOnly -> this.parameterOptional(StringUnmarshallers.BOOLEAN, "compact", isCompact -> this.parameterMultiMap(params -> {
            if (jobIdsOnly.isPresent() && ((Boolean)jobIdsOnly.get()).booleanValue()) {
                logger.debug("/api/jobs/list jobIdsOnly called");
                return CachingDirectives.alwaysCache(this.cache, this.requestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.jobRouteHandler.listJobIds(JobRouteUtils.createListJobIdsRequest(params, regex, true)), resp -> this.completeOK(resp.getJobIds().stream().map(jobId -> jobId.getJobId()).collect(Collectors.toList()), Jackson.marshaller()))));
            }
            if (isCompact.isPresent() && ((Boolean)isCompact.get()).booleanValue()) {
                logger.debug("/api/jobs/list compact called");
                return CachingDirectives.alwaysCache(this.cache, this.requestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.jobRouteHandler.listJobs(JobRouteUtils.createListJobsRequest(params, regex, true)), resp -> this.completeOK(resp.getJobList().stream().map(jobMetadataView -> JobClusterProtoAdapter.toCompactJobInfo(jobMetadataView)).collect(Collectors.toList()), Jackson.marshaller()))));
            }
            logger.debug("/api/jobs/list called");
            return CachingDirectives.alwaysCache(this.cache, this.requestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.jobRouteHandler.listJobs(JobRouteUtils.createListJobsRequest(params, regex, true)), resp -> this.completeOK(resp.getJobList(), Jackson.marshaller()))));
        })));
    }

    private Route getJobRoutes() {
        return this.route(new Route[]{this.path(STATUS_ENDPOINT, () -> this.post(() -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), req -> {
            if (logger.isDebugEnabled()) {
                logger.debug("/api/postjobstatus called {}", req);
            }
            try {
                this.workerHeartbeatStatusPOST.increment();
                PostJobStatusRequest postJobStatusRequest = Jackson.fromJSON(req, PostJobStatusRequest.class);
                WorkerEvent workerStatusRequest = JobRouteUtils.createWorkerStatusRequest(postJobStatusRequest);
                if (workerStatusRequest instanceof WorkerHeartbeat && !ConfigurationProvider.getConfig().isHeartbeatProcessingEnabled()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("skipped heartbeat event {}", (Object)workerStatusRequest);
                    }
                    this.workerHeartbeatSkipped.increment();
                    return this.complete(StatusCodes.OK);
                }
                return this.completeWithFuture(this.jobRouteHandler.workerStatus(workerStatusRequest).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error handling job status {}", req, (Object)e);
                return this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"invalid JSON payload to post job status\"}");
            }
        })))), this.pathPrefix(API_JOBS, () -> this.route(new Route[]{this.post(() -> this.route(new Route[]{this.path(KILL_ENDPOINT, () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), req -> {
            logger.debug("/api/jobs/kill called {}", req);
            try {
                JobClusterManagerProto.KillJobRequest killJobRequest = Jackson.fromJSON(req, JobClusterManagerProto.KillJobRequest.class);
                return this.completeWithFuture(this.jobRouteHandler.kill(killJobRequest).thenApply(resp -> {
                    if (resp.responseCode == BaseResponse.ResponseCode.SUCCESS) {
                        return new JobClusterManagerProto.KillJobResponse(resp.requestId, resp.responseCode, resp.getState(), "[\"" + resp.getJobId().getId() + " Killed\"]", resp.getJobId(), resp.getUser());
                    }
                    if (resp.responseCode == BaseResponse.ResponseCode.CLIENT_ERROR) {
                        return new JobClusterManagerProto.KillJobResponse(resp.requestId, BaseResponse.ResponseCode.SUCCESS, resp.getState(), "[\"" + resp.message + " \"]", resp.getJobId(), resp.getUser());
                    }
                    return resp;
                }).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error on job kill {}", req, (Object)e);
                return this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"invalid json payload to kill job\"}");
            }
        }))), this.path(RESUBMIT_WORKER_ENDPOINT, () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), req -> {
            logger.debug("/api/jobs/resubmitWorker called {}", req);
            try {
                JobClusterManagerProto.ResubmitWorkerRequest resubmitWorkerRequest = Jackson.fromJSON(req, JobClusterManagerProto.ResubmitWorkerRequest.class);
                return this.completeWithFuture(this.jobRouteHandler.resubmitWorker(resubmitWorkerRequest).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error on worker resubmit {}", req, (Object)e);
                return this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"invalid json payload to resubmit worker\"}");
            }
        }))), this.path(SCALE_STAGE_ENDPOINT, () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), req -> {
            logger.debug("/api/jobs/scaleStage called {}", req);
            try {
                JobClusterManagerProto.ScaleStageRequest scaleStageRequest = Jackson.fromJSON(req, JobClusterManagerProto.ScaleStageRequest.class);
                int numWorkers = scaleStageRequest.getNumWorkers();
                int maxWorkersPerStage = ConfigurationProvider.getConfig().getMaxWorkersPerStage();
                if (numWorkers > maxWorkersPerStage) {
                    logger.warn("rejecting ScaleStageRequest {} with invalid num workers", (Object)scaleStageRequest);
                    return this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"num workers must be less than " + maxWorkersPerStage + "\"}");
                }
                return this.completeWithFuture(this.jobRouteHandler.scaleStage(scaleStageRequest).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error scaling stage {}", req, (Object)e);
                return this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"invalid json payload to scale stage " + e.getMessage() + "\"}");
            }
        })))})), this.get(() -> this.route(new Route[]{this.path(PathMatchers.segment((String)"list"), () -> {
            this.jobListGET.increment();
            return this.jobListRoute(Optional.empty());
        }), this.path(PathMatchers.segment((String)"list").slash("matchinglabels"), () -> {
            this.jobListLabelMatchGET.increment();
            return this.jobListRoute(Optional.empty());
        }), this.path(PathMatchers.segment((String)"list").slash(PathMatchers.segment()), jobId -> {
            logger.debug("/api/jobs/list/{} called", jobId);
            this.jobListJobIdGET.increment();
            return this.completeAsync(this.jobRouteHandler.getJobDetails(new JobClusterManagerProto.GetJobDetailsRequest("masterAPI", (String)jobId)), resp -> {
                Optional<MantisJobMetadataView> mantisJobMetadataView = resp.getJobMetadata().map(metaData -> new MantisJobMetadataView((IMantisJobMetadata)metaData, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false));
                return this.completeOK(mantisJobMetadataView, Jackson.marshaller());
            });
        }), this.path(PathMatchers.segment((String)"list").slash("matching").slash(PathMatchers.segment()), regex -> {
            this.jobListRegexGET.increment();
            return this.jobListRoute(Optional.ofNullable(regex).filter(r -> !r.isEmpty()));
        }), this.path(PathMatchers.segment((String)"archived").slash(PathMatchers.segment()), jobId -> this.parameterOptional(StringUnmarshallers.INTEGER, "limit", limit -> {
            this.jobArchivedWorkersGET.increment();
            Optional<JobId> jobIdO = JobId.fromId(jobId);
            if (jobIdO.isPresent()) {
                JobClusterManagerProto.ListArchivedWorkersRequest req = new JobClusterManagerProto.ListArchivedWorkersRequest(jobIdO.get(), limit.orElse(100));
                return CachingDirectives.alwaysCache(this.cache, this.requestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.jobRouteHandler.listArchivedWorkers(req), resp -> {
                    List workers = resp.getWorkerMetadata().stream().map(wm -> DataFormatAdapter.convertMantisWorkerMetadataToMantisWorkerMetadataWritable(wm)).collect(Collectors.toList());
                    return this.completeOK(workers, Jackson.marshaller());
                })));
            }
            return this.complete(StatusCodes.BAD_REQUEST, "error: 'archived/<jobId>' request must include a valid jobId");
        })), this.path(PathMatchers.segment((String)"archived"), () -> {
            this.jobArchivedWorkersGETInvalid.increment();
            return this.complete(StatusCodes.BAD_REQUEST, "error: 'archived' Request must include jobId");
        })}))}))});
    }

    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating routes");
        ExceptionHandler genericExceptionHandler = ExceptionHandler.newBuilder().match(Exception.class, x -> {
            logger.error("got exception", (Throwable)x);
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "{\"error\": \"" + x.getMessage() + "\"}");
        }).build();
        return this.respondWithHeaders(DEFAULT_RESPONSE_HEADERS, () -> this.handleExceptions(genericExceptionHandler, () -> (Route)routeFilter.apply(this.getJobRoutes())));
    }
}

