/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v0;

import akka.NotUsed;
import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.ws.Message;
import akka.http.javadsl.server.ExceptionHandler;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Route;
import akka.stream.javadsl.Flow;
import io.mantisrx.master.api.akka.route.handlers.JobStatusRouteHandler;
import io.mantisrx.master.api.akka.route.v0.BaseRoute;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(JobStatusRoute.class);
    private final JobStatusRouteHandler jobStatusRouteHandler;
    private static final HttpHeader ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = HttpHeader.parse((String)"Access-Control-Allow-Origin", (String)"*");
    private static final Iterable<HttpHeader> DEFAULT_RESPONSE_HEADERS = Arrays.asList(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);

    public JobStatusRoute(JobStatusRouteHandler jobStatusRouteHandler) {
        this.jobStatusRouteHandler = jobStatusRouteHandler;
    }

    private Route getJobStatusRoutes() {
        return this.route(new Route[]{this.get(() -> this.route(new Route[]{this.path(PathMatchers.segment((String)"job").slash("status").slash(PathMatchers.segment()), jobId -> {
            logger.info("/job/status/{} called", jobId);
            Flow<Message, Message, NotUsed> webSocketFlow = this.jobStatusRouteHandler.jobStatus((String)jobId);
            return this.handleWebSocketMessages(webSocketFlow);
        })}))});
    }

    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating routes");
        ExceptionHandler jsonExceptionHandler = ExceptionHandler.newBuilder().match(IOException.class, x -> {
            logger.error("got exception", (Throwable)x);
            return this.complete(StatusCodes.BAD_REQUEST, "caught exception " + x.getMessage());
        }).build();
        return this.respondWithHeaders(DEFAULT_RESPONSE_HEADERS, () -> this.handleExceptions(jsonExceptionHandler, () -> (Route)routeFilter.apply(this.getJobStatusRoutes())));
    }
}

