/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Route;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.handlers.JobArtifactRouteHandler;
import io.mantisrx.master.api.akka.route.v1.BaseRoute;
import io.mantisrx.master.api.akka.route.v1.HttpRequestMetrics;
import io.mantisrx.master.jobcluster.proto.JobArtifactProto;
import io.mantisrx.server.core.domain.JobArtifact;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.Module;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobArtifactsRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(JobArtifactsRoute.class);
    private static final PathMatcher0 JOB_ARTIFACTS_API_PREFIX = PathMatchers.segment((String)"api").slash("v1").slash("jobArtifacts");
    private final JobArtifactRouteHandler jobArtifactRouteHandler;
    private static final ObjectMapper JAVA_TIME_COMPATIBLE_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
    public static final SimpleFilterProvider DEFAULT_FILTER_PROVIDER = new SimpleFilterProvider();

    public JobArtifactsRoute(JobArtifactRouteHandler jobArtifactRouteHandler) {
        this.jobArtifactRouteHandler = jobArtifactRouteHandler;
    }

    @Override
    public Route constructRoutes() {
        return this.concat(this.pathPrefix(JOB_ARTIFACTS_API_PREFIX, () -> this.concat(this.pathEndOrSingleSlash(() -> this.concat(this.get(this::getJobArtifactsRoute), new Route[]{this.post(this::postJobArtifactRoute)})), new Route[]{this.path("names", () -> this.pathEndOrSingleSlash(() -> this.get(this::listJobArtifactsByNameRoute)))})), new Route[0]);
    }

    @Override
    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating /api/v1/jobArtifacts routes");
        return super.createRoute(routeFilter);
    }

    private Route getJobArtifactsRoute() {
        logger.trace("GET /api/v1/jobArtifacts called");
        return this.parameterMap(param -> this.completeAsync(this.jobArtifactRouteHandler.search(new JobArtifactProto.SearchJobArtifactsRequest((String)param.get("name"), (String)param.get("version"))), resp -> this.completeOK(resp.getJobArtifacts(), Jackson.marshaller(JAVA_TIME_COMPATIBLE_MAPPER)), "api.v1.jobArtifacts", HttpRequestMetrics.HttpVerb.GET));
    }

    private Route postJobArtifactRoute() {
        return this.entity(Jackson.unmarshaller(JAVA_TIME_COMPATIBLE_MAPPER, JobArtifact.class), jobArtifact -> {
            logger.trace("POST /api/v1/jobArtifacts called with payload: {}", jobArtifact);
            try {
                CompletionStage<JobArtifactProto.UpsertJobArtifactResponse> response = this.jobArtifactRouteHandler.upsert(new JobArtifactProto.UpsertJobArtifactRequest((JobArtifact)jobArtifact));
                return this.completeAsync(response, resp -> this.complete(StatusCodes.CREATED, resp.getArtifactID(), Jackson.marshaller(JAVA_TIME_COMPATIBLE_MAPPER)), "api.v1.jobArtifacts", HttpRequestMetrics.HttpVerb.POST);
            }
            catch (Exception e) {
                return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "Failed to store job artifact");
            }
        });
    }

    private Route listJobArtifactsByNameRoute() {
        logger.trace("GET /api/v1/jobArtifacts/names called");
        return this.parameterMap(param -> this.completeAsync(this.jobArtifactRouteHandler.listArtifactsByName(new JobArtifactProto.ListJobArtifactsByNameRequest(param.getOrDefault("prefix", ""), param.getOrDefault("contains", ""))), resp -> this.completeOK(resp.getNames(), Jackson.marshaller(JAVA_TIME_COMPATIBLE_MAPPER)), "api.v1.jobArtifacts.names", HttpRequestMetrics.HttpVerb.GET));
    }

    static {
        DEFAULT_FILTER_PROVIDER.setFailOnUnknownId(false);
    }
}

