/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import akka.actor.ActorSystem;
import akka.http.caching.javadsl.Cache;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.Uri;
import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.RouteResult;
import akka.http.javadsl.server.directives.CachingDirectives;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.handlers.ResourceClusterRouteHandler;
import io.mantisrx.master.api.akka.route.v1.BaseRoute;
import io.mantisrx.master.api.akka.route.v1.HttpRequestMetrics;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.resourcecluster.proto.DisableTaskExecutorsRequest;
import io.mantisrx.master.resourcecluster.proto.GetResourceClusterSpecRequest;
import io.mantisrx.master.resourcecluster.proto.GetTaskExecutorsRequest;
import io.mantisrx.master.resourcecluster.proto.ListResourceClusterRequest;
import io.mantisrx.master.resourcecluster.proto.ProvisionResourceClusterRequest;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterAPIProto;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterScaleRuleProto;
import io.mantisrx.master.resourcecluster.proto.ScaleResourceRequest;
import io.mantisrx.master.resourcecluster.proto.ScaleResourceResponse;
import io.mantisrx.master.resourcecluster.proto.SetResourceClusterScalerStatusRequest;
import io.mantisrx.master.resourcecluster.proto.UpgradeClusterContainersRequest;
import io.mantisrx.master.resourcecluster.proto.UpgradeClusterContainersResponse;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ResourceCluster;
import io.mantisrx.server.master.resourcecluster.ResourceClusters;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.PartialFunction;

public class ResourceClustersNonLeaderRedirectRoute
extends BaseRoute {
    private static final Logger log = LoggerFactory.getLogger(ResourceClustersNonLeaderRedirectRoute.class);
    private static final PathMatcher0 RESOURCECLUSTERS_API_PREFIX = PathMatchers.segment((String)"api").slash("v1").slash("resourceClusters");
    private final ResourceClusters gateway;
    private final ResourceClusterRouteHandler resourceClusterRouteHandler;
    private final Cache<Uri, RouteResult> routeResultCache;

    public ResourceClustersNonLeaderRedirectRoute(ResourceClusters gateway, ResourceClusterRouteHandler resourceClusterRouteHandler, ActorSystem actorSystem) {
        this.gateway = gateway;
        this.resourceClusterRouteHandler = resourceClusterRouteHandler;
        MasterConfiguration config = ConfigurationProvider.getConfig();
        this.routeResultCache = this.createCache(actorSystem, config.getApiCacheMinSize(), config.getApiCacheMaxSize(), config.getApiCacheTtlMilliseconds());
    }

    @Override
    protected Route constructRoutes() {
        Route result = this.pathPrefix(RESOURCECLUSTERS_API_PREFIX, () -> this.concat(this.pathEndOrSingleSlash(() -> this.concat(this.get(this::getRegisteredResourceClustersRoute), new Route[]{this.post(this::provisionResourceClustersRoute)})), new Route[]{this.pathPrefix("list", () -> this.concat(this.get(this::listClusters), new Route[0])), this.path(PathMatchers.segment(), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getResourceClusterInstanceRoute((String)clusterName)), new Route[]{this.delete(() -> this.deleteResourceClusterInstanceRoute((String)clusterName))}))), this.path(PathMatchers.segment().slash("scaleSku"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.scaleClusterSku((String)clusterName)), new Route[0]))), this.path(PathMatchers.segment().slash("disableTaskExecutors"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.disableTaskExecutors(this.getClusterID((String)clusterName))), new Route[0]))), this.path(PathMatchers.segment().slash("setScalerStatus"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.setScalerStatus((String)clusterName)), new Route[0]))), this.path(PathMatchers.segment().slash("upgrade"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.upgradeCluster((String)clusterName)), new Route[0]))), this.path(PathMatchers.segment().slash("getResourceOverview"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getResourceOverview(this.getClusterID((String)clusterName))), new Route[0]))), this.path(PathMatchers.segment().slash("activeJobOverview"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.parameterOptional("startingIndex", startingIndex -> this.parameterOptional("pageSize", pageSize -> this.getActiveJobOverview(this.getClusterID((String)clusterName), (Optional<String>)startingIndex, (Optional<String>)pageSize)))), new Route[0]))), this.path(PathMatchers.segment().slash("getRegisteredTaskExecutors"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.mkTaskExecutorsRoute(this.getClusterID((String)clusterName), (rc, req) -> rc.getRegisteredTaskExecutors(req.getAttributes()))), new Route[0]))), this.path(PathMatchers.segment().slash("getBusyTaskExecutors"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.mkTaskExecutorsRoute(this.getClusterID((String)clusterName), (rc, req) -> rc.getBusyTaskExecutors(req.getAttributes()))), new Route[0]))), this.path(PathMatchers.segment().slash("getAvailableTaskExecutors"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.mkTaskExecutorsRoute(this.getClusterID((String)clusterName), (rc, req) -> rc.getAvailableTaskExecutors(req.getAttributes()))), new Route[0]))), this.path(PathMatchers.segment().slash("getUnregisteredTaskExecutors"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.mkTaskExecutorsRoute(this.getClusterID((String)clusterName), (rc, req) -> rc.getUnregisteredTaskExecutors(req.getAttributes()))), new Route[0]))), this.path(PathMatchers.segment().slash("scaleRule"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.createSingleScaleRule((String)clusterName)), new Route[0]))), this.path(PathMatchers.segment().slash("scaleRules"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getScaleRules((String)clusterName)), new Route[]{this.post(() -> this.createAllScaleRules((String)clusterName))}))), this.path(PathMatchers.segment().slash("cacheJobArtifacts"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.withFuture(this.gateway.getClusterFor(this.getClusterID((String)clusterName)).getJobArtifactsToCache())), new Route[]{this.post(() -> this.cacheJobArtifacts((String)clusterName)), this.delete(() -> this.removeJobArtifactsToCache((String)clusterName))}))), this.pathPrefix(PathMatchers.segment().slash("taskExecutors"), clusterName -> this.concat(this.path(PathMatchers.segment().slash("getTaskExecutorState"), taskExecutorId -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getTaskExecutorState(this.getClusterID((String)clusterName), this.getTaskExecutorID((String)taskExecutorId))), new Route[0]))), new Route[0]))}));
        return result;
    }

    private Route listClusters() {
        return this.withFuture(this.gateway.listActiveClusters());
    }

    private Route getActiveJobOverview(ClusterID clusterID, Optional<String> startingIndex, Optional<String> pageSize) {
        CompletableFuture jobsOverview = this.gateway.getClusterFor(clusterID).getActiveJobOverview(startingIndex.map(Integer::parseInt), pageSize.map(Integer::parseInt));
        return this.withFuture(jobsOverview);
    }

    private Route getResourceOverview(ClusterID clusterID) {
        CompletableFuture resourceOverview = this.gateway.getClusterFor(clusterID).resourceOverview();
        return this.withFuture(resourceOverview);
    }

    private Route mkTaskExecutorsRoute(ClusterID clusterId, BiFunction<ResourceCluster, GetTaskExecutorsRequest, CompletableFuture<List<TaskExecutorID>>> taskExecutors) {
        GetTaskExecutorsRequest empty = new GetTaskExecutorsRequest((Map<String, String>)ImmutableMap.of());
        return this.entity(Jackson.optionalEntityUnmarshaller(GetTaskExecutorsRequest.class), request -> {
            if (request == null) {
                request = empty;
            }
            return this.withFuture((CompletableFuture)taskExecutors.apply(this.gateway.getClusterFor(clusterId), (GetTaskExecutorsRequest)request));
        });
    }

    private Route getTaskExecutorState(ClusterID clusterID, TaskExecutorID taskExecutorID) {
        CompletableFuture statusOverview = this.gateway.getClusterFor(clusterID).getTaskExecutorState(taskExecutorID);
        return this.withFuture(statusOverview);
    }

    private Route disableTaskExecutors(ClusterID clusterID) {
        return this.entity(Jackson.unmarshaller(DisableTaskExecutorsRequest.class), request -> {
            log.info("POST /api/v1/resourceClusters/{}/disableTaskExecutors called with body {}", (Object)clusterID, request);
            return this.withFuture(this.gateway.getClusterFor(clusterID).disableTaskExecutorsFor(request.getAttributes(), Instant.now().plus(Duration.ofHours(request.getExpirationDurationInHours())), request.getTaskExecutorID()));
        });
    }

    private Route setScalerStatus(String clusterID) {
        return this.entity(Jackson.unmarshaller(SetResourceClusterScalerStatusRequest.class), request -> {
            log.info("POST /api/v1/resourceClusters/{}/setScalerStatus called with body {}", (Object)clusterID, request);
            return this.withFuture(this.gateway.getClusterFor(request.getClusterID()).setScalerStatus(request.getClusterID(), request.getSkuId(), request.getEnabled(), request.getExpirationDurationInSeconds()));
        });
    }

    private ClusterID getClusterID(String clusterName) {
        return ClusterID.of((String)clusterName);
    }

    private TaskExecutorID getTaskExecutorID(String resourceName) {
        return TaskExecutorID.of((String)resourceName);
    }

    private Route getResourceClusterInstanceRoute(String clusterId) {
        log.info("GET /api/v1/resourceClusters/{} called", (Object)clusterId);
        return this.parameterMap(param -> CachingDirectives.alwaysCache(this.routeResultCache, (PartialFunction)this.getRequestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.resourceClusterRouteHandler.get(GetResourceClusterSpecRequest.builder().id(ClusterID.of((String)clusterId)).build()), resp -> this.completeOK(resp, Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.GET))));
    }

    private Route provisionResourceClustersRoute() {
        return this.entity(Jackson.unmarshaller(ProvisionResourceClusterRequest.class), resClusterSpec -> {
            log.info("POST /api/v1/resourceClusters called: {}", resClusterSpec);
            CompletionStage<ResourceClusterAPIProto.GetResourceClusterResponse> response = this.resourceClusterRouteHandler.create((ProvisionResourceClusterRequest)resClusterSpec);
            return this.completeAsync(response, resp -> this.complete(StatusCodes.ACCEPTED, resp.getClusterSpec(), Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route getRegisteredResourceClustersRoute() {
        log.info("GET /api/v1/resourceClusters called");
        return this.parameterMap(param -> CachingDirectives.alwaysCache(this.routeResultCache, (PartialFunction)this.getRequestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.resourceClusterRouteHandler.get(ListResourceClusterRequest.builder().build()), resp -> this.completeOK(resp, Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.GET))));
    }

    private Route deleteResourceClusterInstanceRoute(String clusterId) {
        log.info("DELETE api/v1/resourceClusters/{}", (Object)clusterId);
        return this.completeAsync(this.resourceClusterRouteHandler.delete(ClusterID.of((String)clusterId)), resp -> this.completeOK(resp, Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.DELETE);
    }

    private Route scaleClusterSku(String clusterId) {
        return this.entity(Jackson.unmarshaller(ScaleResourceRequest.class), skuScaleRequest -> {
            log.info("POST api/v1/resourceClusters/{}/scaleSku {}", (Object)clusterId, skuScaleRequest);
            CompletionStage<ScaleResourceResponse> response = this.resourceClusterRouteHandler.scale((ScaleResourceRequest)skuScaleRequest);
            return this.completeAsync(response, resp -> this.complete(StatusCodes.ACCEPTED, resp, Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route upgradeCluster(String clusterId) {
        return this.entity(Jackson.unmarshaller(UpgradeClusterContainersRequest.class), upgradeRequest -> {
            log.info("POST api/v1/resourceClusters/{}/upgrade {}", (Object)clusterId, upgradeRequest);
            CompletionStage<UpgradeClusterContainersResponse> response = this.resourceClusterRouteHandler.upgrade((UpgradeClusterContainersRequest)upgradeRequest);
            return this.completeAsync(response, resp -> this.complete(StatusCodes.ACCEPTED, resp, Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route createSingleScaleRule(String clusterId) {
        return this.entity(Jackson.unmarshaller(ResourceClusterScaleRuleProto.CreateResourceClusterScaleRuleRequest.class), scaleRuleReq -> {
            log.info("POST api/v1/resourceClusters/{}/scaleRule {}", (Object)clusterId, scaleRuleReq);
            CompletionStage<ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse> response = this.resourceClusterRouteHandler.createSingleScaleRule((ResourceClusterScaleRuleProto.CreateResourceClusterScaleRuleRequest)scaleRuleReq);
            return this.completeAsync(response, resp -> this.complete(StatusCodes.ACCEPTED, resp, Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route createAllScaleRules(String clusterId) {
        return this.entity(Jackson.unmarshaller(ResourceClusterScaleRuleProto.CreateAllResourceClusterScaleRulesRequest.class), scaleRuleReq -> {
            log.info("POST api/v1/resourceClusters/{}/scaleRules {}", (Object)clusterId, scaleRuleReq);
            CompletionStage<ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse> response = this.resourceClusterRouteHandler.createAllScaleRule((ResourceClusterScaleRuleProto.CreateAllResourceClusterScaleRulesRequest)scaleRuleReq);
            return this.completeAsync(response.thenCombineAsync(this.gateway.getClusterFor(this.getClusterID(clusterId)).refreshClusterScalerRuleSet(), (createResp, dontCare) -> createResp), resp -> this.complete(StatusCodes.ACCEPTED, resp, Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route getScaleRules(String clusterId) {
        log.info("GET /api/v1/resourceClusters/{}/scaleRules called", (Object)clusterId);
        return this.parameterMap(param -> CachingDirectives.alwaysCache(this.routeResultCache, (PartialFunction)this.getRequestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.resourceClusterRouteHandler.getClusterScaleRules(ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesRequest.builder().clusterId(this.getClusterID(clusterId)).build()), resp -> this.completeOK(resp, Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.GET))));
    }

    private Route cacheJobArtifacts(String clusterId) {
        return this.entity(Jackson.unmarshaller(ResourceClusterScaleRuleProto.JobArtifactsToCacheRequest.class), request -> {
            log.info("POST /api/v1/resourceClusters/{}/cacheJobArtifacts {}", (Object)clusterId, request);
            CompletableFuture response = this.gateway.getClusterFor(this.getClusterID(clusterId)).addNewJobArtifactsToCache(request.getClusterID(), request.getArtifacts());
            return this.completeAsync(response.thenApply(dontCare -> new BaseResponse(request.requestId, BaseResponse.ResponseCode.SUCCESS, "job artifacts stored successfully")), resp -> this.complete(StatusCodes.CREATED, request.getArtifacts(), Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route removeJobArtifactsToCache(String clusterId) {
        return this.entity(Jackson.unmarshaller(ResourceClusterScaleRuleProto.JobArtifactsToCacheRequest.class), request -> {
            log.info("DELETE /api/v1/resourceClusters/{}/cacheJobArtifacts {}", (Object)clusterId, request);
            CompletableFuture response = this.gateway.getClusterFor(this.getClusterID(clusterId)).removeJobArtifactsToCache(request.getArtifacts());
            return this.completeAsync(response.thenApply(dontCare -> new BaseResponse(request.requestId, BaseResponse.ResponseCode.SUCCESS, "job artifacts removed successfully")), resp -> this.complete(StatusCodes.OK, request.getArtifacts(), Jackson.marshaller()), "api.v1.resourceClusters", HttpRequestMetrics.HttpVerb.DELETE);
        });
    }
}

