/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.events;

import io.mantisrx.master.events.JobRegistry;
import io.mantisrx.master.jobcluster.IJobClusterMetadata;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.server.master.domain.JobId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JobRegistryImpl
implements JobRegistry {
    ConcurrentMap<String, IJobClusterMetadata> jobClusterMap = new ConcurrentHashMap<String, IJobClusterMetadata>();
    ConcurrentMap<JobId, IMantisJobMetadata> jobMap = new ConcurrentHashMap<JobId, IMantisJobMetadata>();
    ConcurrentMap<String, Set<IMantisJobMetadata>> clusterToJobsMap = new ConcurrentHashMap<String, Set<IMantisJobMetadata>>();

    @Override
    public void addClusters(List<IJobClusterMetadata> jobClusters) {
        jobClusters.forEach(jc -> this.jobClusterMap.put(jc.getJobClusterDefinition().getName(), (IJobClusterMetadata)jc));
    }

    @Override
    public void updateCluster(IJobClusterMetadata clusterMetadata) {
        this.jobClusterMap.put(clusterMetadata.getJobClusterDefinition().getName(), clusterMetadata);
    }

    @Override
    public void deleteJobCluster(String clusterName) {
        this.jobClusterMap.remove(clusterName);
    }

    @Override
    public void addJobs(String clusterName, List<IMantisJobMetadata> jobList) {
        jobList.forEach(jb -> this.jobMap.put(jb.getJobId(), (IMantisJobMetadata)jb));
        this.clusterToJobsMap.computeIfAbsent(clusterName, x -> new HashSet()).addAll(jobList);
    }

    @Override
    public void addCompletedJobs(List<JobClusterDefinitionImpl.CompletedJob> completedJobList) {
    }

    @Override
    public void updateJob(IMantisJobMetadata jobMetadata) {
    }

    @Override
    public void removeJob(JobId jobId) {
    }
}

