/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster;

import io.mantisrx.master.jobcluster.IJobClusterMetadata;
import io.mantisrx.server.master.domain.IJobClusterDefinition;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class JobClusterMetadataImpl
implements IJobClusterMetadata {
    private final IJobClusterDefinition jobClusterDefinition;
    private final long lastJobCount;
    private final boolean disabled;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobClusterMetadataImpl(@JsonProperty(value="jobClusterDefinition") JobClusterDefinitionImpl jcDefn, @JsonProperty(value="lastJobCount") long lastJobCount, @JsonProperty(value="disabled") boolean disabled) {
        this.jobClusterDefinition = jcDefn;
        this.lastJobCount = lastJobCount;
        this.disabled = disabled;
    }

    @Override
    public IJobClusterDefinition getJobClusterDefinition() {
        return this.jobClusterDefinition;
    }

    @Override
    public long getLastJobCount() {
        return this.lastJobCount;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobClusterMetadataImpl that = (JobClusterMetadataImpl)o;
        return this.lastJobCount == that.lastJobCount && this.disabled == that.disabled && Objects.equals(this.jobClusterDefinition, that.jobClusterDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.jobClusterDefinition, this.lastJobCount, this.disabled);
    }

    public String toString() {
        return "JobClusterMetadataImpl [jobClusterDefinition=" + this.jobClusterDefinition + ", lastJobCount=" + this.lastJobCount + ", disabled=" + this.disabled + "]";
    }

    public static class Builder {
        private JobClusterDefinitionImpl jobClusterDefinition;
        private long lastJobCount = 0L;
        private boolean disabled;

        public Builder withJobClusterDefinition(JobClusterDefinitionImpl jobClusterDef) {
            this.jobClusterDefinition = jobClusterDef;
            return this;
        }

        public Builder withLastJobCount(long lastJobCnt) {
            this.lastJobCount = lastJobCnt;
            return this;
        }

        public Builder withIsDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public IJobClusterMetadata build() {
            return new JobClusterMetadataImpl(this.jobClusterDefinition, this.lastJobCount, this.disabled);
        }

        public IJobClusterMetadata build(JobClusterDefinitionImpl def, long lastJobCnt, boolean isDisabled) {
            return new JobClusterMetadataImpl(def, this.lastJobCount, isDisabled);
        }
    }
}

