/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster;

import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.common.Label;
import io.mantisrx.master.jobcluster.IJobClusterMetadata;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.domain.JobClusterConfig;
import io.mantisrx.server.master.domain.JobDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDefinitionResolver {
    private final Logger logger = LoggerFactory.getLogger(JobDefinitionResolver.class);

    JobDefinition getResolvedJobDefinition(String user, JobDefinition givenJobDefnOp, IJobClusterMetadata jobClusterMetadata) throws Exception {
        Preconditions.checkNotNull((Object)givenJobDefnOp, (String)"JobDefinition cannot be null");
        Preconditions.checkNotNull((Object)jobClusterMetadata, (String)"JobClusterMetadata cannot be null");
        JobDefinition resolvedJobDefn = givenJobDefnOp;
        this.logger.info("Given JobDefn {}", (Object)resolvedJobDefn);
        List<Parameter> parameters = resolvedJobDefn.getParameters() != null && !resolvedJobDefn.getParameters().isEmpty() ? resolvedJobDefn.getParameters() : jobClusterMetadata.getJobClusterDefinition().getParameters();
        Map<String, Label> labelMap = jobClusterMetadata.getJobClusterDefinition().getLabels().stream().collect(Collectors.toMap(Label::getName, label -> label));
        if (resolvedJobDefn.getLabels() != null && !resolvedJobDefn.getLabels().isEmpty()) {
            resolvedJobDefn.getLabels().forEach(label -> labelMap.put(label.getName(), (Label)label));
        }
        List<Label> labels = Collections.unmodifiableList(new ArrayList<Label>(labelMap.values()));
        String artifactName = resolvedJobDefn.getArtifactName();
        SchedulingInfo schedulingInfo = resolvedJobDefn.getSchedulingInfo();
        String version = resolvedJobDefn.getVersion();
        JobClusterConfig jobClusterConfig = null;
        if (JobDefinitionResolver.isNull(artifactName) || JobDefinitionResolver.isNull(version) || JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
            if (!JobDefinitionResolver.isNull(artifactName) && !JobDefinitionResolver.isNull(version) && JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
                String msg = String.format("Scheduling info is not specified during Job Submit for cluster %s while new artifact is specified %s. Job Submit fails", jobClusterMetadata.getJobClusterDefinition().getName(), artifactName);
                this.logger.warn(msg);
                throw new Exception(msg);
            }
            if (!JobDefinitionResolver.isNull(artifactName) && JobDefinitionResolver.isNull(version) && !JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
                version = String.valueOf(System.currentTimeMillis());
            } else {
                Optional<JobClusterConfig> clusterConfigForVersion;
                if (!JobDefinitionResolver.isNull(artifactName) && JobDefinitionResolver.isNull(version) && JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
                    String msg = String.format("Scheduling info is not specified during Job Submit for cluster %s while new artifact %s is specified. Job Submit fails", jobClusterMetadata.getJobClusterDefinition().getName(), artifactName);
                    this.logger.warn(msg);
                    throw new Exception(msg);
                }
                if (JobDefinitionResolver.isNull(artifactName) && !JobDefinitionResolver.isNull(version) && !JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
                    clusterConfigForVersion = this.getJobClusterConfigForVersion(jobClusterMetadata, version);
                    if (!clusterConfigForVersion.isPresent()) {
                        String msg = String.format("No Job Cluster config could be found for version %s in JobCluster %s. Job Submit fails", version, jobClusterMetadata.getJobClusterDefinition().getName());
                        this.logger.warn(msg);
                        throw new Exception(msg);
                    }
                    jobClusterConfig = clusterConfigForVersion.get();
                    if (!this.validateSchedulingInfo(schedulingInfo, jobClusterConfig.getSchedulingInfo(), jobClusterMetadata)) {
                        String msg = String.format("Given SchedulingInfo %s is incompatible with that associated with the given version %s in JobCluster %s. Job Submit fails", schedulingInfo, version, jobClusterMetadata.getJobClusterDefinition().getName());
                        this.logger.warn(msg);
                        throw new Exception(msg);
                    }
                    artifactName = jobClusterConfig.getArtifactName();
                } else if (JobDefinitionResolver.isNull(artifactName) && !JobDefinitionResolver.isNull(version) && JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
                    clusterConfigForVersion = this.getJobClusterConfigForVersion(jobClusterMetadata, version);
                    if (!clusterConfigForVersion.isPresent()) {
                        String msg = String.format("No Job Cluster config could be found for version %s in JobCluster %s. Job Submit fails", version, jobClusterMetadata.getJobClusterDefinition().getName());
                        this.logger.warn(msg);
                        throw new Exception(msg);
                    }
                    jobClusterConfig = clusterConfigForVersion.get();
                    schedulingInfo = jobClusterConfig.getSchedulingInfo();
                    artifactName = jobClusterConfig.getArtifactName();
                } else if (JobDefinitionResolver.isNull(artifactName) && JobDefinitionResolver.isNull(version) && !JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
                    jobClusterConfig = jobClusterMetadata.getJobClusterDefinition().getJobClusterConfig();
                    version = jobClusterConfig.getVersion();
                    artifactName = jobClusterConfig.getArtifactName();
                    if (!this.validateSchedulingInfo(schedulingInfo, jobClusterConfig.getSchedulingInfo(), jobClusterMetadata)) {
                        String msg = String.format("Given SchedulingInfo %s is incompatible with that associated with the given version %s in JobCluster %s which is %s. Job Submit fails", schedulingInfo, version, jobClusterMetadata.getJobClusterDefinition().getName(), jobClusterMetadata.getJobClusterDefinition().getJobClusterConfig().getSchedulingInfo());
                        this.logger.warn(msg);
                        throw new Exception(msg);
                    }
                } else if (JobDefinitionResolver.isNull(artifactName) && JobDefinitionResolver.isNull(version) && JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
                    jobClusterConfig = jobClusterMetadata.getJobClusterDefinition().getJobClusterConfig();
                    version = jobClusterConfig.getVersion();
                    schedulingInfo = jobClusterConfig.getSchedulingInfo();
                    artifactName = jobClusterConfig.getArtifactName();
                } else {
                    throw new Exception(String.format("Invalid case for resolveJobDefinition artifactName %s version %s schedulingInfo %s", artifactName, version, schedulingInfo));
                }
            }
        }
        this.logger.info("Resolved version {}, schedulingInfo {}, artifactName {}", new Object[]{version, schedulingInfo, artifactName});
        if (JobDefinitionResolver.isNull(artifactName) || JobDefinitionResolver.isNull(version) || JobDefinitionResolver.schedulingInfoNotValid(schedulingInfo)) {
            String msg = String.format(" SchedulingInfo %s or artifact %s or version %s could not be resolved in JobCluster %s. Job Submit fails", schedulingInfo, artifactName, version, jobClusterMetadata.getJobClusterDefinition().getName());
            this.logger.warn(msg);
            throw new Exception(msg);
        }
        return new JobDefinition.Builder().from(resolvedJobDefn).withParameters(parameters).withLabels(labels).withSchedulingInfo(schedulingInfo).withUser(user).withVersion(version).withArtifactName(artifactName).build();
    }

    private static boolean schedulingInfoNotValid(SchedulingInfo schedulingInfo) {
        return schedulingInfo == null || schedulingInfo.getStages().isEmpty();
    }

    private static boolean isNull(String key) {
        return key == null || key.equals("null") || key.isEmpty();
    }

    Optional<JobClusterConfig> getJobClusterConfigForVersion(IJobClusterMetadata jobClusterMetadata, String version) {
        Preconditions.checkNotNull((Object)jobClusterMetadata, (String)"JobClusterMetadata cannot be null");
        Preconditions.checkNotNull((Object)version, (String)"Version cannot be null");
        String versionToFind = version;
        List configList = jobClusterMetadata.getJobClusterDefinition().getJobClusterConfigs().stream().filter(cfg -> cfg.getVersion().equals(versionToFind)).collect(Collectors.toList());
        if (!configList.isEmpty()) {
            return Optional.of(configList.get(0));
        }
        String msg = String.format("No config with version %s found for Job Cluster %s. Job Submit fails", versionToFind, jobClusterMetadata.getJobClusterDefinition().getName());
        this.logger.warn(msg);
        return Optional.empty();
    }

    private boolean validateSchedulingInfo(SchedulingInfo givenSchedulingInfo, SchedulingInfo configuredSchedulingInfo, IJobClusterMetadata jobClusterMetadata) throws Exception {
        int givenNumStages = givenSchedulingInfo.getStages().size();
        int existingNumStages = configuredSchedulingInfo.getStages().size();
        if (givenSchedulingInfo.forStage(0) != null) {
            --givenNumStages;
        }
        if (configuredSchedulingInfo.forStage(0) != null) {
            --existingNumStages;
        }
        if (givenNumStages != existingNumStages) {
            this.logger.warn("Mismatched scheduling info: expecting #stages=" + existingNumStages + " for given jar version [ ], where as, given scheduling info has #stages=" + givenNumStages);
            return false;
        }
        return true;
    }
}

