/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job;

import io.mantisrx.master.jobcluster.job.worker.WorkerHeartbeat;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.master.jobcluster.job.worker.WorkerStatus;
import io.mantisrx.master.jobcluster.job.worker.WorkerTerminate;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import io.mantisrx.server.master.scheduler.WorkerLaunched;
import io.mantisrx.server.master.scheduler.WorkerResourceStatus;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobHelper.class);

    private JobHelper() {
    }

    public static List<Integer> getUserStageNumbers(SchedulingInfo schedulingInfo, boolean hasJobMaster) {
        ArrayList<Integer> stageNumbers = new ArrayList<Integer>();
        int totalStages = schedulingInfo.getStages().size();
        if (hasJobMaster) {
            --totalStages;
        }
        for (int i = 1; i <= totalStages; ++i) {
            stageNumbers.add(i);
        }
        return stageNumbers;
    }

    public static boolean isTerminalWorkerEvent(WorkerEvent workerEvent) {
        WorkerResourceStatus.VMResourceState state;
        WorkerStatus status;
        if (workerEvent instanceof WorkerTerminate) {
            return true;
        }
        return workerEvent instanceof WorkerStatus ? WorkerState.isTerminalState((status = (WorkerStatus)workerEvent).getState()) : workerEvent instanceof WorkerResourceStatus && (WorkerResourceStatus.VMResourceState.FAILED.equals((Object)(state = ((WorkerResourceStatus)workerEvent).getState())) || WorkerResourceStatus.VMResourceState.COMPLETED.equals((Object)state));
    }

    public static Optional<String> getWorkerHostFromWorkerEvent(WorkerEvent event) {
        Optional<String> host = Optional.empty();
        if (event instanceof WorkerLaunched) {
            host = Optional.ofNullable(((WorkerLaunched)event).getHostname());
        } else if (event instanceof WorkerHeartbeat) {
            host = Optional.ofNullable(((WorkerHeartbeat)event).getStatus().getHostname());
        } else {
            LOGGER.warn("Host name unknown for workerId {}", (Object)event.getWorkerId());
        }
        return host;
    }

    public static long calculateRuntimeDuration(long maxRuntimeSecs, Instant startedAt) {
        long elapsedSeconds;
        Instant now;
        long terminateJobInSecs = maxRuntimeSecs;
        if (maxRuntimeSecs > 0L && (now = Instant.now()).isAfter(startedAt) && (terminateJobInSecs = maxRuntimeSecs - (elapsedSeconds = now.getEpochSecond() - startedAt.getEpochSecond())) <= 0L) {
            terminateJobInSecs = 1L;
        }
        return terminateJobInSecs;
    }
}

