/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job.worker;

import java.util.HashMap;
import java.util.Map;

public enum WorkerState {
    Accepted,
    Launched,
    StartInitiated,
    Started,
    Failed,
    Completed,
    Noop,
    Unknown;

    private static final Map<WorkerState, WorkerState[]> STATE_TRANSITION_MAP;
    private static final Map<WorkerState, MetaState> META_STATES;

    public static boolean isWorkerOnSlave(WorkerState state) {
        switch (state) {
            case StartInitiated: 
            case Started: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRunningState(WorkerState state) {
        switch (state) {
            case StartInitiated: 
            case Started: 
            case Launched: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidStateChgTo(WorkerState currentState, WorkerState newState) {
        for (WorkerState validState : STATE_TRANSITION_MAP.get((Object)currentState)) {
            if (validState != newState) continue;
            return true;
        }
        return false;
    }

    public static boolean isTerminalState(WorkerState state) {
        switch (state) {
            case Completed: 
            case Failed: {
                return true;
            }
        }
        return false;
    }

    public static boolean isErrorState(WorkerState state) {
        switch (state) {
            case Failed: {
                return true;
            }
        }
        return false;
    }

    public static MetaState toMetaState(WorkerState state) {
        return META_STATES.get((Object)state);
    }

    static {
        STATE_TRANSITION_MAP = new HashMap<WorkerState, WorkerState[]>();
        STATE_TRANSITION_MAP.put(Accepted, new WorkerState[]{Launched, Failed, Completed});
        STATE_TRANSITION_MAP.put(Launched, new WorkerState[]{StartInitiated, Started, Failed, Completed});
        STATE_TRANSITION_MAP.put(StartInitiated, new WorkerState[]{StartInitiated, Started, Failed, Completed});
        STATE_TRANSITION_MAP.put(Started, new WorkerState[]{Started, Failed, Completed});
        STATE_TRANSITION_MAP.put(Failed, new WorkerState[]{Failed});
        STATE_TRANSITION_MAP.put(Completed, new WorkerState[0]);
        META_STATES = new HashMap<WorkerState, MetaState>();
        META_STATES.put(Accepted, MetaState.Active);
        META_STATES.put(Launched, MetaState.Active);
        META_STATES.put(StartInitiated, MetaState.Active);
        META_STATES.put(Started, MetaState.Active);
        META_STATES.put(Failed, MetaState.Terminal);
        META_STATES.put(Completed, MetaState.Terminal);
    }

    public static enum MetaState {
        Active,
        Terminal;

    }
}

