/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.proto;

import akka.actor.ActorRef;
import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.master.jobcluster.proto.BaseRequest;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.server.core.JobCompletedReason;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.server.master.domain.JobDefinition;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public class JobClusterProto {

    public static final class TriggerCronRequest {
        public final Instant time;

        public TriggerCronRequest(Instant time) {
            this.time = time;
        }

        public TriggerCronRequest() {
            this(Instant.now());
        }
    }

    public static final class BookkeepingRequest {
        public final Instant time;

        public BookkeepingRequest(Instant time) {
            this.time = time;
        }

        public BookkeepingRequest() {
            this(Instant.now());
        }
    }

    public static final class EnforceSLARequest {
        public final Instant timeOfEnforcement;
        public final Optional<JobDefinition> jobDefinitionOp;

        public EnforceSLARequest() {
            this(Instant.now(), Optional.empty());
        }

        public EnforceSLARequest(Instant now) {
            this(now, Optional.empty());
        }

        public EnforceSLARequest(Instant now, Optional<JobDefinition> jobDefnOp) {
            this.timeOfEnforcement = now;
            this.jobDefinitionOp = jobDefnOp;
        }
    }

    public static final class JobStartedEvent {
        public final JobId jobid;

        public JobStartedEvent(JobId jobId) {
            this.jobid = jobId;
        }

        public String toString() {
            return "JobStartedEvent [jobid=" + this.jobid + "]";
        }
    }

    public static final class KillJobResponse
    extends BaseResponse {
        public final JobId jobId;
        public final ActorRef requestor;
        public final JobState state;
        public final String user;
        public final IMantisJobMetadata jobMetadata;

        public KillJobResponse(long requestId, BaseResponse.ResponseCode responseCode, JobState state, String message, JobId jobId, IMantisJobMetadata jobMeta, String user, ActorRef requestor) {
            super(requestId, responseCode, message);
            this.jobId = jobId;
            this.requestor = requestor;
            this.state = state;
            this.user = user;
            this.jobMetadata = jobMeta;
        }

        public String toString() {
            return "KillJobResponse{jobId=" + this.jobId + ", requestor=" + this.requestor + ", state=" + (Object)((Object)this.state) + ", user='" + this.user + '\'' + ", jobMetadata=" + this.jobMetadata + '}';
        }
    }

    public static final class KillJobRequest
    extends BaseRequest {
        public final JobId jobId;
        public final String reason;
        public final JobCompletedReason jobCompletedReason;
        public final String user;
        public final ActorRef requestor;

        public KillJobRequest(JobId jobId, String reason, JobCompletedReason jobCompletedReason, String user, ActorRef requestor) {
            this.jobId = jobId;
            this.reason = reason;
            this.jobCompletedReason = jobCompletedReason;
            this.user = user;
            this.requestor = requestor;
        }

        public String toString() {
            return "KillJobRequest [jobId=" + this.jobId + ", reason=" + this.reason + ", user=" + this.user + ", requestor=" + this.requestor + "]";
        }
    }

    public static final class DeleteJobClusterResponse
    extends BaseResponse {
        public final ActorRef requestingActor;
        public final String clusterName;

        public DeleteJobClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, ActorRef requestingActor, String clusterName) {
            super(requestId, responseCode, message);
            this.requestingActor = requestingActor;
            this.clusterName = clusterName;
        }

        public ActorRef getRequestingActor() {
            return this.requestingActor;
        }

        public String getClusterName() {
            return this.clusterName;
        }
    }

    public static final class DeleteJobClusterRequest
    extends BaseRequest {
        public final String jobClusterName;
        public final String user;
        public final ActorRef requestingActor;

        public DeleteJobClusterRequest(String user, String name, ActorRef requestor) {
            this.jobClusterName = name;
            this.user = user;
            this.requestingActor = requestor;
        }
    }

    public static final class InitializeJobClusterResponse
    extends BaseResponse {
        public final ActorRef requestor;
        public final String jobClusterName;

        public InitializeJobClusterResponse(long requestId, BaseResponse.ResponseCode responseCode, String message, String jobClusterName, ActorRef requestor) {
            super(requestId, responseCode, message);
            this.requestor = requestor;
            this.jobClusterName = jobClusterName;
        }
    }

    public static final class InitializeJobClusterRequest
    extends BaseRequest {
        public final JobClusterDefinitionImpl jobClusterDefinition;
        public final ActorRef requestor;
        public final String user;
        public final boolean isDisabled;
        public final long lastJobNumber;
        public final boolean createInStore;
        public final List<IMantisJobMetadata> jobList;

        public InitializeJobClusterRequest(JobClusterDefinitionImpl jobClusterDefinition, boolean isDisabled, long lastJobNumber, List<IMantisJobMetadata> jobList, String user, ActorRef requestor, boolean createInStore) {
            Preconditions.checkNotNull((Object)jobClusterDefinition, (String)"JobClusterDefn cannot be null");
            this.jobClusterDefinition = jobClusterDefinition;
            this.user = user;
            this.requestor = requestor;
            this.createInStore = createInStore;
            this.isDisabled = isDisabled;
            this.lastJobNumber = lastJobNumber;
            this.jobList = jobList;
        }

        public InitializeJobClusterRequest(JobClusterDefinitionImpl jobClusterDefinition, String user, ActorRef requestor) {
            this(jobClusterDefinition, false, 0L, Lists.newArrayList(), user, requestor, true);
        }

        public String toString() {
            return "InitializeJobClusterRequest{jobClusterDefinition=" + this.jobClusterDefinition + ", requestor=" + this.requestor + ", user='" + this.user + '\'' + ", isDisabled=" + this.isDisabled + ", lastJobNumber=" + this.lastJobNumber + ", createInStore=" + this.createInStore + ", jobList=" + this.jobList + '}';
        }
    }
}

