/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.xml.bind.DatatypeConverter;

public final class DisableTaskExecutorsRequest {
    private final Map<String, String> attributes;
    private final ClusterID clusterID;
    private final Instant expiry;
    private final Optional<TaskExecutorID> taskExecutorID;

    boolean isRequestByAttributes() {
        return this.attributes.size() > 0;
    }

    boolean isExpired(Instant now) {
        return this.expiry.compareTo(now) <= 0;
    }

    boolean targetsSameTaskExecutorsAs(DisableTaskExecutorsRequest another) {
        return this.isRequestByAttributes() && another.isRequestByAttributes() && this.attributes.entrySet().containsAll(another.attributes.entrySet());
    }

    boolean covers(@Nullable TaskExecutorRegistration registration) {
        return this.isRequestByAttributes() && registration != null && registration.containsAttributes(this.attributes);
    }

    public String getHash() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(this.clusterID.getResourceID().getBytes(StandardCharsets.UTF_8));
            this.taskExecutorID.ifPresent(executorID -> messageDigest.update(executorID.getResourceId().getBytes(StandardCharsets.UTF_8)));
            TreeMap<String, String> clone = new TreeMap<String, String>(this.attributes);
            clone.forEach((key, value) -> {
                messageDigest.update(key.getBytes(StandardCharsets.UTF_8));
                messageDigest.update(value.getBytes(StandardCharsets.UTF_8));
            });
            return DatatypeConverter.printHexBinary((byte[])messageDigest.digest());
        }
        catch (NoSuchAlgorithmException exception) {
            throw new RuntimeException(exception);
        }
    }

    @ConstructorProperties(value={"attributes", "clusterID", "expiry", "taskExecutorID"})
    public DisableTaskExecutorsRequest(Map<String, String> attributes, ClusterID clusterID, Instant expiry, Optional<TaskExecutorID> taskExecutorID) {
        this.attributes = attributes;
        this.clusterID = clusterID;
        this.expiry = expiry;
        this.taskExecutorID = taskExecutorID;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public ClusterID getClusterID() {
        return this.clusterID;
    }

    public Instant getExpiry() {
        return this.expiry;
    }

    public Optional<TaskExecutorID> getTaskExecutorID() {
        return this.taskExecutorID;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisableTaskExecutorsRequest)) {
            return false;
        }
        DisableTaskExecutorsRequest other = (DisableTaskExecutorsRequest)o;
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        ClusterID this$clusterID = this.getClusterID();
        ClusterID other$clusterID = other.getClusterID();
        if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
            return false;
        }
        Instant this$expiry = this.getExpiry();
        Instant other$expiry = other.getExpiry();
        if (this$expiry == null ? other$expiry != null : !((Object)this$expiry).equals(other$expiry)) {
            return false;
        }
        Optional<TaskExecutorID> this$taskExecutorID = this.getTaskExecutorID();
        Optional<TaskExecutorID> other$taskExecutorID = other.getTaskExecutorID();
        return !(this$taskExecutorID == null ? other$taskExecutorID != null : !((Object)this$taskExecutorID).equals(other$taskExecutorID));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        ClusterID $clusterID = this.getClusterID();
        result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
        Instant $expiry = this.getExpiry();
        result = result * 59 + ($expiry == null ? 43 : ((Object)$expiry).hashCode());
        Optional<TaskExecutorID> $taskExecutorID = this.getTaskExecutorID();
        result = result * 59 + ($taskExecutorID == null ? 43 : ((Object)$taskExecutorID).hashCode());
        return result;
    }

    public String toString() {
        return "DisableTaskExecutorsRequest(attributes=" + this.getAttributes() + ", clusterID=" + this.getClusterID() + ", expiry=" + this.getExpiry() + ", taskExecutorID=" + this.getTaskExecutorID() + ")";
    }
}

