/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.japi.pf.ReceiveBuilder;
import io.mantisrx.master.akka.MantisActorSupervisorStrategy;
import io.mantisrx.master.resourcecluster.DisableTaskExecutorsRequest;
import io.mantisrx.master.resourcecluster.ResourceClusterActor;
import io.mantisrx.master.resourcecluster.ResourceClusterScalerActor;
import io.mantisrx.master.resourcecluster.proto.SetResourceClusterScalerStatusRequest;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.server.master.persistence.IMantisPersistenceProvider;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorDisconnection;
import io.mantisrx.server.master.resourcecluster.TaskExecutorHeartbeat;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.server.master.resourcecluster.TaskExecutorStatusChange;
import io.mantisrx.server.master.scheduler.JobMessageRouter;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.rpc.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceClustersManagerActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(ResourceClustersManagerActor.class);
    private final MasterConfiguration masterConfiguration;
    private final Clock clock;
    private final RpcService rpcService;
    private final MantisJobStore mantisJobStore;
    private final Map<ClusterID, ActorHolder> resourceClusterActorMap;
    private final ActorRef resourceClusterHostActor;
    private final IMantisPersistenceProvider mantisPersistenceProvider;
    private final JobMessageRouter jobMessageRouter;

    public static Props props(MasterConfiguration masterConfiguration, Clock clock, RpcService rpcService, MantisJobStore mantisJobStore, ActorRef resourceClusterHostActorRef, IMantisPersistenceProvider mantisPersistenceProvider, JobMessageRouter jobMessageRouter) {
        return Props.create(ResourceClustersManagerActor.class, (Object[])new Object[]{masterConfiguration, clock, rpcService, mantisJobStore, resourceClusterHostActorRef, mantisPersistenceProvider, jobMessageRouter});
    }

    public ResourceClustersManagerActor(MasterConfiguration masterConfiguration, Clock clock, RpcService rpcService, MantisJobStore mantisJobStore, ActorRef resourceClusterHostActorRef, IMantisPersistenceProvider mantisPersistenceProvider, JobMessageRouter jobMessageRouter) {
        this.masterConfiguration = masterConfiguration;
        this.clock = clock;
        this.rpcService = rpcService;
        this.mantisJobStore = mantisJobStore;
        this.resourceClusterHostActor = resourceClusterHostActorRef;
        this.mantisPersistenceProvider = mantisPersistenceProvider;
        this.jobMessageRouter = jobMessageRouter;
        this.resourceClusterActorMap = new HashMap<ClusterID, ActorHolder>();
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ListActiveClusters.class, req -> this.sender().tell((Object)this.getActiveClusters(), this.self())).match(ResourceClusterActor.GetRegisteredTaskExecutorsRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.GetBusyTaskExecutorsRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.GetAvailableTaskExecutorsRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.GetUnregisteredTaskExecutorsRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.GetTaskExecutorStatusRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.GetActiveJobsRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.GetAssignedTaskExecutorRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(TaskExecutorRegistration.class, registration -> this.getRCActor(registration.getClusterID()).forward(registration, this.context())).match(TaskExecutorHeartbeat.class, heartbeat -> this.getRCActor(heartbeat.getClusterID()).forward(heartbeat, this.context())).match(TaskExecutorStatusChange.class, statusChange -> this.getRCActor(statusChange.getClusterID()).forward(statusChange, this.context())).match(TaskExecutorDisconnection.class, disconnection -> this.getRCActor(disconnection.getClusterID()).forward(disconnection, this.context())).match(ResourceClusterActor.TaskExecutorBatchAssignmentRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.ResourceOverviewRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.TaskExecutorInfoRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.TaskExecutorGatewayRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(DisableTaskExecutorsRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.AddNewJobArtifactsToCacheRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.RemoveJobArtifactsToCacheRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterActor.GetJobArtifactsToCacheRequest.class, req -> this.getRCActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterScalerActor.TriggerClusterRuleRefreshRequest.class, req -> this.getRCScalerActor(req.getClusterID()).forward(req, this.context())).match(ResourceClusterScalerActor.QueueClusterRuleRefreshRequest.class, req -> this.getRCScalerActor(req.getClusterID()).forward(req, this.context())).match(SetResourceClusterScalerStatusRequest.class, req -> this.getRCScalerActor(req.getClusterID()).forward(req, this.context())).build();
    }

    private ActorRef createResourceClusterActorFor(ClusterID clusterID) {
        log.info("Creating resource cluster actor for {}", (Object)clusterID);
        ActorRef clusterActor = this.getContext().actorOf(ResourceClusterActor.props(clusterID, Duration.ofMillis(this.masterConfiguration.getHeartbeatIntervalInMs()), Duration.ofMillis(this.masterConfiguration.getAssignmentIntervalInMs()), Duration.ofMillis(this.masterConfiguration.getAssignmentIntervalInMs()), this.clock, this.rpcService, this.mantisJobStore, this.jobMessageRouter, this.masterConfiguration.getMaxJobArtifactsToCache(), this.masterConfiguration.getJobClustersWithArtifactCachingEnabled(), this.masterConfiguration.isJobArtifactCachingEnabled(), this.masterConfiguration.getSchedulingConstraints(), this.masterConfiguration.getFitnessCalculator()), "ResourceClusterActor-" + clusterID.getResourceID());
        log.info("Created resource cluster actor for {}", (Object)clusterID);
        return clusterActor;
    }

    private ActorRef createResourceClusterScalerActorFor(ClusterID clusterID, ActorRef rcActor) {
        log.info("Creating resource cluster scaler actor for {}", (Object)clusterID);
        ActorRef clusterScalerActor = this.getContext().actorOf(ResourceClusterScalerActor.props(clusterID, this.clock, Duration.ofSeconds(this.masterConfiguration.getScalerTriggerThresholdInSecs()), Duration.ofSeconds(this.masterConfiguration.getScalerRuleSetRefreshThresholdInSecs()), this.mantisPersistenceProvider, this.resourceClusterHostActor, rcActor), "ResourceClusterScalerActor-" + clusterID.getResourceID());
        log.info("Created resource cluster scaler actor for {}", (Object)clusterID);
        return clusterScalerActor;
    }

    private ActorRef getRCActor(ClusterID clusterID) {
        return this.getOrCreateRCActors(clusterID).getResourceClusterActor();
    }

    private ActorRef getRCScalerActor(ClusterID clusterID) {
        return this.getOrCreateRCActors(clusterID).getResourceClusterScalerActor();
    }

    private ActorHolder getOrCreateRCActors(ClusterID clusterID) {
        if (this.resourceClusterActorMap.get(clusterID) != null) {
            return this.resourceClusterActorMap.get(clusterID);
        }
        return this.resourceClusterActorMap.computeIfAbsent(clusterID, dontCare -> {
            ActorRef rcActorRef = this.createResourceClusterActorFor(clusterID);
            this.getContext().watch(rcActorRef);
            ActorRef scalerActorRef = this.createResourceClusterScalerActorFor(clusterID, rcActorRef);
            this.getContext().watch(scalerActorRef);
            return ActorHolder.builder().resourceClusterActor(rcActorRef).resourceClusterScalerActor(scalerActorRef).build();
        });
    }

    private ClusterIdSet getActiveClusters() {
        return new ClusterIdSet(this.resourceClusterActorMap.keySet());
    }

    public SupervisorStrategy supervisorStrategy() {
        return MantisActorSupervisorStrategy.getInstance().create();
    }

    static final class ActorHolder {
        private final ActorRef resourceClusterActor;
        private final ActorRef resourceClusterScalerActor;

        @ConstructorProperties(value={"resourceClusterActor", "resourceClusterScalerActor"})
        ActorHolder(ActorRef resourceClusterActor, ActorRef resourceClusterScalerActor) {
            this.resourceClusterActor = resourceClusterActor;
            this.resourceClusterScalerActor = resourceClusterScalerActor;
        }

        public static ActorHolderBuilder builder() {
            return new ActorHolderBuilder();
        }

        public ActorRef getResourceClusterActor() {
            return this.resourceClusterActor;
        }

        public ActorRef getResourceClusterScalerActor() {
            return this.resourceClusterScalerActor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActorHolder)) {
                return false;
            }
            ActorHolder other = (ActorHolder)o;
            ActorRef this$resourceClusterActor = this.getResourceClusterActor();
            ActorRef other$resourceClusterActor = other.getResourceClusterActor();
            if (this$resourceClusterActor == null ? other$resourceClusterActor != null : !this$resourceClusterActor.equals(other$resourceClusterActor)) {
                return false;
            }
            ActorRef this$resourceClusterScalerActor = this.getResourceClusterScalerActor();
            ActorRef other$resourceClusterScalerActor = other.getResourceClusterScalerActor();
            return !(this$resourceClusterScalerActor == null ? other$resourceClusterScalerActor != null : !this$resourceClusterScalerActor.equals(other$resourceClusterScalerActor));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ActorRef $resourceClusterActor = this.getResourceClusterActor();
            result = result * 59 + ($resourceClusterActor == null ? 43 : $resourceClusterActor.hashCode());
            ActorRef $resourceClusterScalerActor = this.getResourceClusterScalerActor();
            result = result * 59 + ($resourceClusterScalerActor == null ? 43 : $resourceClusterScalerActor.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClustersManagerActor.ActorHolder(resourceClusterActor=" + this.getResourceClusterActor() + ", resourceClusterScalerActor=" + this.getResourceClusterScalerActor() + ")";
        }

        public static class ActorHolderBuilder {
            private ActorRef resourceClusterActor;
            private ActorRef resourceClusterScalerActor;

            ActorHolderBuilder() {
            }

            public ActorHolderBuilder resourceClusterActor(ActorRef resourceClusterActor) {
                this.resourceClusterActor = resourceClusterActor;
                return this;
            }

            public ActorHolderBuilder resourceClusterScalerActor(ActorRef resourceClusterScalerActor) {
                this.resourceClusterScalerActor = resourceClusterScalerActor;
                return this;
            }

            public ActorHolder build() {
                return new ActorHolder(this.resourceClusterActor, this.resourceClusterScalerActor);
            }

            public String toString() {
                return "ResourceClustersManagerActor.ActorHolder.ActorHolderBuilder(resourceClusterActor=" + this.resourceClusterActor + ", resourceClusterScalerActor=" + this.resourceClusterScalerActor + ")";
            }
        }
    }

    static final class ClusterIdSet {
        private final Set<ClusterID> clusterIDS;

        @ConstructorProperties(value={"clusterIDS"})
        public ClusterIdSet(Set<ClusterID> clusterIDS) {
            this.clusterIDS = clusterIDS;
        }

        public Set<ClusterID> getClusterIDS() {
            return this.clusterIDS;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterIdSet)) {
                return false;
            }
            ClusterIdSet other = (ClusterIdSet)o;
            Set<ClusterID> this$clusterIDS = this.getClusterIDS();
            Set<ClusterID> other$clusterIDS = other.getClusterIDS();
            return !(this$clusterIDS == null ? other$clusterIDS != null : !((Object)this$clusterIDS).equals(other$clusterIDS));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<ClusterID> $clusterIDS = this.getClusterIDS();
            result = result * 59 + ($clusterIDS == null ? 43 : ((Object)$clusterIDS).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClustersManagerActor.ClusterIdSet(clusterIDS=" + this.getClusterIDS() + ")";
        }
    }

    static final class ListActiveClusters {
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ListActiveClusters;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "ResourceClustersManagerActor.ListActiveClusters()";
        }
    }
}

