/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.proto;

import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import java.beans.ConstructorProperties;

public final class GetClusterIdleInstancesRequest {
    private final ClusterID clusterID;
    private final ContainerSkuID skuId;
    private final int maxInstanceCount;
    private final int desireSize;

    @ConstructorProperties(value={"clusterID", "skuId", "maxInstanceCount", "desireSize"})
    GetClusterIdleInstancesRequest(ClusterID clusterID, ContainerSkuID skuId, int maxInstanceCount, int desireSize) {
        this.clusterID = clusterID;
        this.skuId = skuId;
        this.maxInstanceCount = maxInstanceCount;
        this.desireSize = desireSize;
    }

    public static GetClusterIdleInstancesRequestBuilder builder() {
        return new GetClusterIdleInstancesRequestBuilder();
    }

    public ClusterID getClusterID() {
        return this.clusterID;
    }

    public ContainerSkuID getSkuId() {
        return this.skuId;
    }

    public int getMaxInstanceCount() {
        return this.maxInstanceCount;
    }

    public int getDesireSize() {
        return this.desireSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetClusterIdleInstancesRequest)) {
            return false;
        }
        GetClusterIdleInstancesRequest other = (GetClusterIdleInstancesRequest)o;
        if (this.getMaxInstanceCount() != other.getMaxInstanceCount()) {
            return false;
        }
        if (this.getDesireSize() != other.getDesireSize()) {
            return false;
        }
        ClusterID this$clusterID = this.getClusterID();
        ClusterID other$clusterID = other.getClusterID();
        if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
            return false;
        }
        ContainerSkuID this$skuId = this.getSkuId();
        ContainerSkuID other$skuId = other.getSkuId();
        return !(this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxInstanceCount();
        result = result * 59 + this.getDesireSize();
        ClusterID $clusterID = this.getClusterID();
        result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
        ContainerSkuID $skuId = this.getSkuId();
        result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
        return result;
    }

    public String toString() {
        return "GetClusterIdleInstancesRequest(clusterID=" + this.getClusterID() + ", skuId=" + this.getSkuId() + ", maxInstanceCount=" + this.getMaxInstanceCount() + ", desireSize=" + this.getDesireSize() + ")";
    }

    public static class GetClusterIdleInstancesRequestBuilder {
        private ClusterID clusterID;
        private ContainerSkuID skuId;
        private int maxInstanceCount;
        private int desireSize;

        GetClusterIdleInstancesRequestBuilder() {
        }

        public GetClusterIdleInstancesRequestBuilder clusterID(ClusterID clusterID) {
            this.clusterID = clusterID;
            return this;
        }

        public GetClusterIdleInstancesRequestBuilder skuId(ContainerSkuID skuId) {
            this.skuId = skuId;
            return this;
        }

        public GetClusterIdleInstancesRequestBuilder maxInstanceCount(int maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        public GetClusterIdleInstancesRequestBuilder desireSize(int desireSize) {
            this.desireSize = desireSize;
            return this;
        }

        public GetClusterIdleInstancesRequest build() {
            return new GetClusterIdleInstancesRequest(this.clusterID, this.skuId, this.maxInstanceCount, this.desireSize);
        }

        public String toString() {
            return "GetClusterIdleInstancesRequest.GetClusterIdleInstancesRequestBuilder(clusterID=" + this.clusterID + ", skuId=" + this.skuId + ", maxInstanceCount=" + this.maxInstanceCount + ", desireSize=" + this.desireSize + ")";
        }
    }
}

