/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.proto;

import io.mantisrx.master.resourcecluster.proto.MantisResourceClusterEnvType;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.shaded.com.google.common.base.Joiner;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ScaleResourceRequest {
    private final ClusterID clusterId;
    private final ContainerSkuID skuId;
    private final String region;
    private final Optional<MantisResourceClusterEnvType> envType;
    private final int desireSize;
    private final List<TaskExecutorID> idleInstances;

    public String getScaleRequestId() {
        return Joiner.on((char)'-').join((Object)this.clusterId.getResourceID(), (Object)(this.region == null ? "" : this.region), new Object[]{this.envType != null && this.envType.isPresent() ? this.getEnvType().get().name() : "", this.skuId.getResourceID(), this.desireSize});
    }

    @ConstructorProperties(value={"clusterId", "skuId", "region", "envType", "desireSize", "idleInstances"})
    ScaleResourceRequest(ClusterID clusterId, ContainerSkuID skuId, String region, Optional<MantisResourceClusterEnvType> envType, int desireSize, List<TaskExecutorID> idleInstances) {
        this.clusterId = clusterId;
        this.skuId = skuId;
        this.region = region;
        this.envType = envType;
        this.desireSize = desireSize;
        this.idleInstances = idleInstances;
    }

    public static ScaleResourceRequestBuilder builder() {
        return new ScaleResourceRequestBuilder();
    }

    public ClusterID getClusterId() {
        return this.clusterId;
    }

    public ContainerSkuID getSkuId() {
        return this.skuId;
    }

    public String getRegion() {
        return this.region;
    }

    public Optional<MantisResourceClusterEnvType> getEnvType() {
        return this.envType;
    }

    public int getDesireSize() {
        return this.desireSize;
    }

    public List<TaskExecutorID> getIdleInstances() {
        return this.idleInstances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaleResourceRequest)) {
            return false;
        }
        ScaleResourceRequest other = (ScaleResourceRequest)o;
        if (this.getDesireSize() != other.getDesireSize()) {
            return false;
        }
        ClusterID this$clusterId = this.getClusterId();
        ClusterID other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        ContainerSkuID this$skuId = this.getSkuId();
        ContainerSkuID other$skuId = other.getSkuId();
        if (this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        Optional<MantisResourceClusterEnvType> this$envType = this.getEnvType();
        Optional<MantisResourceClusterEnvType> other$envType = other.getEnvType();
        if (this$envType == null ? other$envType != null : !((Object)this$envType).equals(other$envType)) {
            return false;
        }
        List<TaskExecutorID> this$idleInstances = this.getIdleInstances();
        List<TaskExecutorID> other$idleInstances = other.getIdleInstances();
        return !(this$idleInstances == null ? other$idleInstances != null : !((Object)this$idleInstances).equals(other$idleInstances));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDesireSize();
        ClusterID $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        ContainerSkuID $skuId = this.getSkuId();
        result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        Optional<MantisResourceClusterEnvType> $envType = this.getEnvType();
        result = result * 59 + ($envType == null ? 43 : ((Object)$envType).hashCode());
        List<TaskExecutorID> $idleInstances = this.getIdleInstances();
        result = result * 59 + ($idleInstances == null ? 43 : ((Object)$idleInstances).hashCode());
        return result;
    }

    public String toString() {
        return "ScaleResourceRequest(clusterId=" + this.getClusterId() + ", skuId=" + this.getSkuId() + ", region=" + this.getRegion() + ", envType=" + this.getEnvType() + ", desireSize=" + this.getDesireSize() + ", idleInstances=" + this.getIdleInstances() + ")";
    }

    public static class ScaleResourceRequestBuilder {
        private ClusterID clusterId;
        private ContainerSkuID skuId;
        private String region;
        private Optional<MantisResourceClusterEnvType> envType;
        private int desireSize;
        private ArrayList<TaskExecutorID> idleInstances;

        ScaleResourceRequestBuilder() {
        }

        public ScaleResourceRequestBuilder clusterId(ClusterID clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public ScaleResourceRequestBuilder skuId(ContainerSkuID skuId) {
            this.skuId = skuId;
            return this;
        }

        public ScaleResourceRequestBuilder region(String region) {
            this.region = region;
            return this;
        }

        public ScaleResourceRequestBuilder envType(Optional<MantisResourceClusterEnvType> envType) {
            this.envType = envType;
            return this;
        }

        public ScaleResourceRequestBuilder desireSize(int desireSize) {
            this.desireSize = desireSize;
            return this;
        }

        public ScaleResourceRequestBuilder idleInstance(TaskExecutorID idleInstance) {
            if (this.idleInstances == null) {
                this.idleInstances = new ArrayList();
            }
            this.idleInstances.add(idleInstance);
            return this;
        }

        public ScaleResourceRequestBuilder idleInstances(Collection<? extends TaskExecutorID> idleInstances) {
            if (idleInstances == null) {
                throw new NullPointerException("idleInstances cannot be null");
            }
            if (this.idleInstances == null) {
                this.idleInstances = new ArrayList();
            }
            this.idleInstances.addAll(idleInstances);
            return this;
        }

        public ScaleResourceRequestBuilder clearIdleInstances() {
            if (this.idleInstances != null) {
                this.idleInstances.clear();
            }
            return this;
        }

        public ScaleResourceRequest build() {
            List<TaskExecutorID> idleInstances;
            switch (this.idleInstances == null ? 0 : this.idleInstances.size()) {
                case 0: {
                    idleInstances = Collections.emptyList();
                    break;
                }
                case 1: {
                    idleInstances = Collections.singletonList(this.idleInstances.get(0));
                    break;
                }
                default: {
                    idleInstances = Collections.unmodifiableList(new ArrayList<TaskExecutorID>(this.idleInstances));
                }
            }
            return new ScaleResourceRequest(this.clusterId, this.skuId, this.region, this.envType, this.desireSize, idleInstances);
        }

        public String toString() {
            return "ScaleResourceRequest.ScaleResourceRequestBuilder(clusterId=" + this.clusterId + ", skuId=" + this.skuId + ", region=" + this.region + ", envType=" + this.envType + ", desireSize=" + this.desireSize + ", idleInstances=" + this.idleInstances + ")";
        }
    }
}

