/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.proto;

import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;

public final class SkuSizeSpec {
    private final MachineDefinition machineDefinition;
    private final String name;

    @JsonCreator
    public SkuSizeSpec(@JsonProperty(value="machineDefinition") MachineDefinition machineDefinition, @JsonProperty(value="name") String name) {
        this.validateMachineDefinition(machineDefinition);
        this.validateName(name);
        this.name = name.trim();
        this.machineDefinition = machineDefinition;
    }

    private void validateMachineDefinition(MachineDefinition machineDefinition) {
        Validate.isTrue((machineDefinition.getCpuCores() >= 1.0 ? 1 : 0) != 0, (String)"CPU cores must be equal to or greater than 1", (Object[])new Object[0]);
        Validate.isTrue((machineDefinition.getDiskMB() >= 1.0 ? 1 : 0) != 0, (String)"Disk size must be equal to or greater than 1MB", (Object[])new Object[0]);
        Validate.isTrue((machineDefinition.getMemoryMB() >= 1.0 ? 1 : 0) != 0, (String)"Memory size must be equal to or greater than 1MB", (Object[])new Object[0]);
        Validate.isTrue((machineDefinition.getNetworkMbps() >= 1.0 ? 1 : 0) != 0, (String)"Network speed must be equal to or greater than 1Mbps", (Object[])new Object[0]);
    }

    private void validateName(String name) {
        Validate.notNull((Object)name, (String)"Name must not be null", (Object[])new Object[0]);
        Validate.isTrue((!name.trim().isEmpty() ? 1 : 0) != 0, (String)"Name must not be empty or only whitespace", (Object[])new Object[0]);
    }

    public static SkuSizeSpecBuilder builder() {
        return new SkuSizeSpecBuilder();
    }

    public MachineDefinition getMachineDefinition() {
        return this.machineDefinition;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkuSizeSpec)) {
            return false;
        }
        SkuSizeSpec other = (SkuSizeSpec)o;
        MachineDefinition this$machineDefinition = this.getMachineDefinition();
        MachineDefinition other$machineDefinition = other.getMachineDefinition();
        if (this$machineDefinition == null ? other$machineDefinition != null : !this$machineDefinition.equals(other$machineDefinition)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MachineDefinition $machineDefinition = this.getMachineDefinition();
        result = result * 59 + ($machineDefinition == null ? 43 : $machineDefinition.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "SkuSizeSpec(machineDefinition=" + this.getMachineDefinition() + ", name=" + this.getName() + ")";
    }

    public static class SkuSizeSpecBuilder {
        private MachineDefinition machineDefinition;
        private String name;

        SkuSizeSpecBuilder() {
        }

        public SkuSizeSpecBuilder machineDefinition(MachineDefinition machineDefinition) {
            this.machineDefinition = machineDefinition;
            return this;
        }

        public SkuSizeSpecBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SkuSizeSpec build() {
            return new SkuSizeSpec(this.machineDefinition, this.name);
        }

        public String toString() {
            return "SkuSizeSpec.SkuSizeSpecBuilder(machineDefinition=" + this.machineDefinition + ", name=" + this.name + ")";
        }
    }
}

