/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.resourceprovider;

import io.mantisrx.master.resourcecluster.proto.MantisResourceClusterEnvType;
import io.mantisrx.master.resourcecluster.proto.MantisResourceClusterSpec;
import io.mantisrx.master.resourcecluster.proto.UpgradeClusterContainersRequest;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;

public final class ResourceClusterProviderUpgradeRequest {
    private final ClusterID clusterId;
    private final String region;
    @Nullable
    private final String optionalImageId;
    @Nullable
    private final String optionalSkuId;
    private final MantisResourceClusterEnvType optionalEnvType;
    private final int optionalBatchMaxSize;
    private final boolean forceUpgradeOnSameImage;
    private final boolean enableSkuSpecUpgrade;
    @Nullable
    private final MantisResourceClusterSpec resourceClusterSpec;

    public static ResourceClusterProviderUpgradeRequest from(UpgradeClusterContainersRequest req) {
        return ResourceClusterProviderUpgradeRequest.from(req, null);
    }

    public static ResourceClusterProviderUpgradeRequest from(UpgradeClusterContainersRequest req, MantisResourceClusterSpec resourceClusterSpec) {
        return ResourceClusterProviderUpgradeRequest.builder().clusterId(req.getClusterId()).region(req.getRegion()).optionalImageId(req.getOptionalImageId()).optionalSkuId(req.getOptionalSkuId()).optionalEnvType(req.getOptionalEnvType()).optionalBatchMaxSize(req.getOptionalBatchMaxSize()).forceUpgradeOnSameImage(req.isForceUpgradeOnSameImage()).enableSkuSpecUpgrade(req.isEnableSkuSpecUpgrade()).resourceClusterSpec(resourceClusterSpec).build();
    }

    @ConstructorProperties(value={"clusterId", "region", "optionalImageId", "optionalSkuId", "optionalEnvType", "optionalBatchMaxSize", "forceUpgradeOnSameImage", "enableSkuSpecUpgrade", "resourceClusterSpec"})
    ResourceClusterProviderUpgradeRequest(ClusterID clusterId, String region, @Nullable String optionalImageId, @Nullable String optionalSkuId, MantisResourceClusterEnvType optionalEnvType, int optionalBatchMaxSize, boolean forceUpgradeOnSameImage, boolean enableSkuSpecUpgrade, @Nullable MantisResourceClusterSpec resourceClusterSpec) {
        this.clusterId = clusterId;
        this.region = region;
        this.optionalImageId = optionalImageId;
        this.optionalSkuId = optionalSkuId;
        this.optionalEnvType = optionalEnvType;
        this.optionalBatchMaxSize = optionalBatchMaxSize;
        this.forceUpgradeOnSameImage = forceUpgradeOnSameImage;
        this.enableSkuSpecUpgrade = enableSkuSpecUpgrade;
        this.resourceClusterSpec = resourceClusterSpec;
    }

    public static ResourceClusterProviderUpgradeRequestBuilder builder() {
        return new ResourceClusterProviderUpgradeRequestBuilder();
    }

    public ResourceClusterProviderUpgradeRequestBuilder toBuilder() {
        return new ResourceClusterProviderUpgradeRequestBuilder().clusterId(this.clusterId).region(this.region).optionalImageId(this.optionalImageId).optionalSkuId(this.optionalSkuId).optionalEnvType(this.optionalEnvType).optionalBatchMaxSize(this.optionalBatchMaxSize).forceUpgradeOnSameImage(this.forceUpgradeOnSameImage).enableSkuSpecUpgrade(this.enableSkuSpecUpgrade).resourceClusterSpec(this.resourceClusterSpec);
    }

    public ClusterID getClusterId() {
        return this.clusterId;
    }

    public String getRegion() {
        return this.region;
    }

    @Nullable
    public String getOptionalImageId() {
        return this.optionalImageId;
    }

    @Nullable
    public String getOptionalSkuId() {
        return this.optionalSkuId;
    }

    public MantisResourceClusterEnvType getOptionalEnvType() {
        return this.optionalEnvType;
    }

    public int getOptionalBatchMaxSize() {
        return this.optionalBatchMaxSize;
    }

    public boolean isForceUpgradeOnSameImage() {
        return this.forceUpgradeOnSameImage;
    }

    public boolean isEnableSkuSpecUpgrade() {
        return this.enableSkuSpecUpgrade;
    }

    @Nullable
    public MantisResourceClusterSpec getResourceClusterSpec() {
        return this.resourceClusterSpec;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceClusterProviderUpgradeRequest)) {
            return false;
        }
        ResourceClusterProviderUpgradeRequest other = (ResourceClusterProviderUpgradeRequest)o;
        if (this.getOptionalBatchMaxSize() != other.getOptionalBatchMaxSize()) {
            return false;
        }
        if (this.isForceUpgradeOnSameImage() != other.isForceUpgradeOnSameImage()) {
            return false;
        }
        if (this.isEnableSkuSpecUpgrade() != other.isEnableSkuSpecUpgrade()) {
            return false;
        }
        ClusterID this$clusterId = this.getClusterId();
        ClusterID other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$optionalImageId = this.getOptionalImageId();
        String other$optionalImageId = other.getOptionalImageId();
        if (this$optionalImageId == null ? other$optionalImageId != null : !this$optionalImageId.equals(other$optionalImageId)) {
            return false;
        }
        String this$optionalSkuId = this.getOptionalSkuId();
        String other$optionalSkuId = other.getOptionalSkuId();
        if (this$optionalSkuId == null ? other$optionalSkuId != null : !this$optionalSkuId.equals(other$optionalSkuId)) {
            return false;
        }
        MantisResourceClusterEnvType this$optionalEnvType = this.getOptionalEnvType();
        MantisResourceClusterEnvType other$optionalEnvType = other.getOptionalEnvType();
        if (this$optionalEnvType == null ? other$optionalEnvType != null : !((Object)((Object)this$optionalEnvType)).equals((Object)other$optionalEnvType)) {
            return false;
        }
        MantisResourceClusterSpec this$resourceClusterSpec = this.getResourceClusterSpec();
        MantisResourceClusterSpec other$resourceClusterSpec = other.getResourceClusterSpec();
        return !(this$resourceClusterSpec == null ? other$resourceClusterSpec != null : !((Object)this$resourceClusterSpec).equals(other$resourceClusterSpec));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOptionalBatchMaxSize();
        result = result * 59 + (this.isForceUpgradeOnSameImage() ? 79 : 97);
        result = result * 59 + (this.isEnableSkuSpecUpgrade() ? 79 : 97);
        ClusterID $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $optionalImageId = this.getOptionalImageId();
        result = result * 59 + ($optionalImageId == null ? 43 : $optionalImageId.hashCode());
        String $optionalSkuId = this.getOptionalSkuId();
        result = result * 59 + ($optionalSkuId == null ? 43 : $optionalSkuId.hashCode());
        MantisResourceClusterEnvType $optionalEnvType = this.getOptionalEnvType();
        result = result * 59 + ($optionalEnvType == null ? 43 : ((Object)((Object)$optionalEnvType)).hashCode());
        MantisResourceClusterSpec $resourceClusterSpec = this.getResourceClusterSpec();
        result = result * 59 + ($resourceClusterSpec == null ? 43 : ((Object)$resourceClusterSpec).hashCode());
        return result;
    }

    public String toString() {
        return "ResourceClusterProviderUpgradeRequest(clusterId=" + this.getClusterId() + ", region=" + this.getRegion() + ", optionalImageId=" + this.getOptionalImageId() + ", optionalSkuId=" + this.getOptionalSkuId() + ", optionalEnvType=" + (Object)((Object)this.getOptionalEnvType()) + ", optionalBatchMaxSize=" + this.getOptionalBatchMaxSize() + ", forceUpgradeOnSameImage=" + this.isForceUpgradeOnSameImage() + ", enableSkuSpecUpgrade=" + this.isEnableSkuSpecUpgrade() + ", resourceClusterSpec=" + this.getResourceClusterSpec() + ")";
    }

    public static class ResourceClusterProviderUpgradeRequestBuilder {
        private ClusterID clusterId;
        private String region;
        private String optionalImageId;
        private String optionalSkuId;
        private MantisResourceClusterEnvType optionalEnvType;
        private int optionalBatchMaxSize;
        private boolean forceUpgradeOnSameImage;
        private boolean enableSkuSpecUpgrade;
        private MantisResourceClusterSpec resourceClusterSpec;

        ResourceClusterProviderUpgradeRequestBuilder() {
        }

        public ResourceClusterProviderUpgradeRequestBuilder clusterId(ClusterID clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public ResourceClusterProviderUpgradeRequestBuilder region(String region) {
            this.region = region;
            return this;
        }

        public ResourceClusterProviderUpgradeRequestBuilder optionalImageId(@Nullable String optionalImageId) {
            this.optionalImageId = optionalImageId;
            return this;
        }

        public ResourceClusterProviderUpgradeRequestBuilder optionalSkuId(@Nullable String optionalSkuId) {
            this.optionalSkuId = optionalSkuId;
            return this;
        }

        public ResourceClusterProviderUpgradeRequestBuilder optionalEnvType(MantisResourceClusterEnvType optionalEnvType) {
            this.optionalEnvType = optionalEnvType;
            return this;
        }

        public ResourceClusterProviderUpgradeRequestBuilder optionalBatchMaxSize(int optionalBatchMaxSize) {
            this.optionalBatchMaxSize = optionalBatchMaxSize;
            return this;
        }

        public ResourceClusterProviderUpgradeRequestBuilder forceUpgradeOnSameImage(boolean forceUpgradeOnSameImage) {
            this.forceUpgradeOnSameImage = forceUpgradeOnSameImage;
            return this;
        }

        public ResourceClusterProviderUpgradeRequestBuilder enableSkuSpecUpgrade(boolean enableSkuSpecUpgrade) {
            this.enableSkuSpecUpgrade = enableSkuSpecUpgrade;
            return this;
        }

        public ResourceClusterProviderUpgradeRequestBuilder resourceClusterSpec(@Nullable MantisResourceClusterSpec resourceClusterSpec) {
            this.resourceClusterSpec = resourceClusterSpec;
            return this;
        }

        public ResourceClusterProviderUpgradeRequest build() {
            return new ResourceClusterProviderUpgradeRequest(this.clusterId, this.region, this.optionalImageId, this.optionalSkuId, this.optionalEnvType, this.optionalBatchMaxSize, this.forceUpgradeOnSameImage, this.enableSkuSpecUpgrade, this.resourceClusterSpec);
        }

        public String toString() {
            return "ResourceClusterProviderUpgradeRequest.ResourceClusterProviderUpgradeRequestBuilder(clusterId=" + this.clusterId + ", region=" + this.region + ", optionalImageId=" + this.optionalImageId + ", optionalSkuId=" + this.optionalSkuId + ", optionalEnvType=" + (Object)((Object)this.optionalEnvType) + ", optionalBatchMaxSize=" + this.optionalBatchMaxSize + ", forceUpgradeOnSameImage=" + this.forceUpgradeOnSameImage + ", enableSkuSpecUpgrade=" + this.enableSkuSpecUpgrade + ", resourceClusterSpec=" + this.resourceClusterSpec + ")";
        }
    }
}

