/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.plugins.BinPackingFitnessCalculators;
import io.mantisrx.server.master.ClusterFitnessCalculator;
import io.mantisrx.server.master.DurationTypeFitnessCalculator;
import io.mantisrx.server.master.config.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentFitnessCalculator
implements VMTaskFitnessCalculator {
    private static final Logger logger = LoggerFactory.getLogger(AgentFitnessCalculator.class);
    final VMTaskFitnessCalculator binPacker = BinPackingFitnessCalculators.cpuMemNetworkBinPacker;
    final VMTaskFitnessCalculator durationTypeFitnessCalculator = new DurationTypeFitnessCalculator();
    final VMTaskFitnessCalculator clusterFitnessCalculator = new ClusterFitnessCalculator();
    private final double binPackingWeight = ConfigurationProvider.getConfig().getBinPackingFitnessWeight();
    private final double clusterWeight = ConfigurationProvider.getConfig().getPreferredClusterFitnessWeight();
    private final double durationTypeWeight = ConfigurationProvider.getConfig().getDurationTypeFitnessWeight();
    private final double goodEnoughThreshold = ConfigurationProvider.getConfig().getFitnessGoodEnoughThreshold();
    private final Func1<Double, Boolean> fitnessGoodEnoughFunc;

    public AgentFitnessCalculator() {
        logger.info("clusterWeight {} durationTypeWeight {} binPackingWeight {} goodEnoughThreshold {}", new Object[]{this.clusterWeight, this.durationTypeWeight, this.binPackingWeight, this.goodEnoughThreshold});
        this.fitnessGoodEnoughFunc = f -> f > this.goodEnoughThreshold;
    }

    public String getName() {
        return "Mantis Agent Task Fitness Calculator";
    }

    public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        double binPackingValue = this.binPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
        double durationTypeFitness = this.durationTypeFitnessCalculator.calculateFitness(taskRequest, targetVM, taskTrackerState);
        double clusterFitnessValue = this.clusterFitnessCalculator.calculateFitness(taskRequest, targetVM, taskTrackerState);
        if (logger.isDebugEnabled()) {
            logger.debug("cluster {} duration {} binpack score {} total {}", new Object[]{clusterFitnessValue * this.clusterWeight, durationTypeFitness * this.durationTypeWeight, binPackingValue * this.binPackingWeight, binPackingValue * this.binPackingWeight + durationTypeFitness * this.durationTypeWeight + clusterFitnessValue * this.clusterWeight});
        }
        return (binPackingValue * this.binPackingWeight + durationTypeFitness * this.durationTypeWeight + clusterFitnessValue * this.clusterWeight) / (this.binPackingWeight + this.durationTypeWeight + this.clusterWeight);
    }

    public Func1<Double, Boolean> getFitnessGoodEnoughFunc() {
        return this.fitnessGoodEnoughFunc;
    }
}

