/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import io.mantisrx.runtime.MantisJobDurationType;
import io.mantisrx.server.master.scheduler.ScheduleRequest;

public class DurationTypeFitnessCalculator
implements VMTaskFitnessCalculator {
    public String getName() {
        return "Mantis Job Duration Type Task Fitness Calculator";
    }

    public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        MantisJobDurationType durationType = ((ScheduleRequest)taskRequest).getDurationType();
        int totalTasks = 0;
        int sameTypeTasks = 0;
        for (TaskRequest request : targetVM.getRunningTasks()) {
            ++totalTasks;
            if (((ScheduleRequest)request).getDurationType() != durationType) continue;
            ++sameTypeTasks;
        }
        for (TaskAssignmentResult result : targetVM.getTasksCurrentlyAssigned()) {
            ++totalTasks;
            if (((ScheduleRequest)result.getRequest()).getDurationType() != durationType) continue;
            ++sameTypeTasks;
        }
        if (totalTasks == 0) {
            return 0.9;
        }
        return (double)sameTypeTasks / (double)totalTasks;
    }
}

