/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.runtime.JobSla;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.parameter.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class WorkerRequest {
    private final long subscriptionTimeoutSecs;
    private final long minRuntimeSecs;
    private final long jobSubmittedAt;
    private final String user;
    private final Optional<String> preferredCluster;
    private String jobName;
    private String jobId;
    private int workerIndex;
    private int workerNumber;
    private URL jobJarUrl;
    private int workerStage;
    private int totalStages;
    private MachineDefinition definition;
    private int numInstancesAtStage;
    private int numPortsPerInstance;
    private int metricsPort = -1;
    private int debugPort = -1;
    private int consolePort = -1;
    private int customPort = -1;
    private List<Integer> ports;
    private List<Parameter> parameters;
    private JobSla jobSla;
    private List<JobConstraints> hardConstraints;
    private List<JobConstraints> softConstraints;
    private SchedulingInfo schedulingInfo;

    public WorkerRequest(MachineDefinition definition, String jobId, int workerIndex, int workerNumber, URL jobJarUrl, int workerStage, int totalStages, int numInstancesAtStage, String jobName, int numPortsPerInstance, List<Parameter> parameters, JobSla jobSla, List<JobConstraints> hardConstraints, List<JobConstraints> softConstraints, SchedulingInfo schedulingInfo, long subscriptionTimeoutSecs, long minRuntimeSecs, long jobSubmittedAt, String user, Optional<String> preferredCluster) {
        this.definition = definition;
        this.jobId = jobId;
        this.workerIndex = workerIndex;
        this.workerNumber = workerNumber;
        this.jobJarUrl = jobJarUrl;
        this.workerStage = workerStage;
        this.totalStages = totalStages;
        this.numInstancesAtStage = numInstancesAtStage;
        this.jobName = jobName;
        this.numPortsPerInstance = numPortsPerInstance + 4;
        this.ports = new ArrayList<Integer>();
        this.parameters = parameters;
        this.jobSla = jobSla;
        this.hardConstraints = hardConstraints;
        this.softConstraints = softConstraints;
        this.schedulingInfo = schedulingInfo;
        this.subscriptionTimeoutSecs = subscriptionTimeoutSecs;
        this.minRuntimeSecs = minRuntimeSecs;
        this.jobSubmittedAt = jobSubmittedAt;
        this.user = user;
        this.preferredCluster = preferredCluster;
    }

    public static int getNumPortsPerInstance(MachineDefinition machineDefinition) {
        return machineDefinition.getNumPorts() + 1;
    }

    public SchedulingInfo getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public MachineDefinition getDefinition() {
        return this.definition;
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    public int getWorkerNumber() {
        return this.workerNumber;
    }

    public URL getJobJarUrl() {
        return this.jobJarUrl;
    }

    public int getWorkerStage() {
        return this.workerStage;
    }

    public int getTotalStages() {
        return this.totalStages;
    }

    public int getNumInstancesAtStage() {
        return this.numInstancesAtStage;
    }

    public String getJobName() {
        return this.jobName;
    }

    public int getNumPortsPerInstance() {
        return this.numPortsPerInstance;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public int getConsolePort() {
        return this.consolePort;
    }

    public int getCustomPort() {
        return this.customPort;
    }

    public void addPort(int port) {
        if (this.metricsPort == -1) {
            this.metricsPort = port;
        } else if (this.debugPort == -1) {
            this.debugPort = port;
        } else if (this.consolePort == -1) {
            this.consolePort = port;
        } else if (this.customPort == -1) {
            this.customPort = port;
        } else {
            this.ports.add(port);
        }
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public List<Integer> getAllPortsUsed() {
        ArrayList<Integer> allPorts = new ArrayList<Integer>(this.ports);
        allPorts.add(this.metricsPort);
        allPorts.add(this.debugPort);
        allPorts.add(this.consolePort);
        allPorts.add(this.customPort);
        return allPorts;
    }

    public JobSla getJobSla() {
        return this.jobSla;
    }

    public List<JobConstraints> getHardConstraints() {
        return this.hardConstraints;
    }

    public List<JobConstraints> getSoftConstraints() {
        return this.softConstraints;
    }

    public long getSubscriptionTimeoutSecs() {
        return this.subscriptionTimeoutSecs;
    }

    public long getMinRuntimeSecs() {
        return this.minRuntimeSecs;
    }

    public long getJobSubmittedAt() {
        return this.jobSubmittedAt;
    }

    public String getUser() {
        return this.user;
    }

    public Optional<String> getPreferredCluster() {
        return this.preferredCluster;
    }

    public String toString() {
        return this.jobId + "-Stage-" + this.workerStage + "-Worker-" + this.workerIndex;
    }
}

