/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.agentdeploy;

import io.mantisrx.runtime.MigrationStrategy;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.utils.MantisClock;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneWorkerPerTickMigrationStrategy
extends MigrationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(OneWorkerPerTickMigrationStrategy.class);
    private final String jobId;
    private final MantisClock clock;
    private long intervalMoveWorkersOnDisabledVMsMillis;

    public OneWorkerPerTickMigrationStrategy(MantisClock clock, String jobId, WorkerMigrationConfig config) {
        super(config);
        this.clock = clock;
        this.jobId = jobId;
        try {
            this.intervalMoveWorkersOnDisabledVMsMillis = ConfigurationProvider.getConfig().getIntervalMoveWorkersOnDisabledVMsMillis();
        }
        catch (IllegalStateException ise) {
            logger.warn("[{}] Error reading intervalMoveWorkersOnDisabledVMsMillis from config Provider, will default to 1 minute", (Object)jobId);
            this.intervalMoveWorkersOnDisabledVMsMillis = 60000L;
        }
    }

    public List<Integer> execute(ConcurrentSkipListSet<Integer> workersOnDisabledVms, int numRunningWorkers, int totalNumWorkers, long lastMovedWorkerOnDisabledVM) {
        if (lastMovedWorkerOnDisabledVM > this.clock.now() - this.intervalMoveWorkersOnDisabledVMsMillis) {
            return Collections.emptyList();
        }
        Integer workerNumber = workersOnDisabledVms.pollFirst();
        if (workerNumber != null) {
            return Collections.singletonList(workerNumber);
        }
        return Collections.emptyList();
    }
}

