/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.config;

import io.mantisrx.server.core.MetricsCoercer;
import io.mantisrx.server.master.config.ConfigurationFactory;
import io.mantisrx.server.master.config.MasterConfiguration;
import java.util.Properties;
import org.skife.config.Coercible;
import org.skife.config.ConfigurationObjectFactory;

public class StaticPropertiesConfigurationFactory
implements ConfigurationFactory {
    private final ConfigurationObjectFactory delegate;
    private final MasterConfiguration config;
    private final Properties properties;

    public StaticPropertiesConfigurationFactory(Properties props) {
        this.properties = props;
        this.delegate = new ConfigurationObjectFactory(props);
        this.delegate.addCoercible((Coercible)new MetricsCoercer(props));
        this.delegate.addCoercible(clazz -> className -> {
            try {
                if (clazz.isAssignableFrom(Class.forName(className))) {
                    try {
                        return Class.forName(className).newInstance();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("The value %s is not a valid class name for %s implementation. ", className, clazz.getName()));
                    }
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
        this.config = (MasterConfiguration)this.delegate.build(MasterConfiguration.class);
    }

    @Override
    public MasterConfiguration getConfig() {
        return this.config;
    }

    public String toString() {
        return "StaticPropertiesConfigurationFactory{delegate=" + this.delegate + ", config=" + this.config + '}';
    }
}

