/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.domain;

import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import java.util.Objects;

public class JobClusterConfig {
    private final String artifactName;
    private final String version;
    private final long uploadedAt;
    private final SchedulingInfo schedulingInfo;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobClusterConfig(@JsonProperty(value="artifactName") String artifactName, @JsonProperty(value="uploadedAt") long uploadedAt, @JsonProperty(value="version") String version, @JsonProperty(value="schedulingInfo") SchedulingInfo schedulingInfo) {
        this.artifactName = artifactName;
        this.uploadedAt = uploadedAt;
        this.version = version == null || version.isEmpty() ? "" + System.currentTimeMillis() : version;
        this.schedulingInfo = schedulingInfo;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public long getUploadedAt() {
        return this.uploadedAt;
    }

    public String getVersion() {
        return this.version;
    }

    public SchedulingInfo getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public String toString() {
        return "JobClusterConfig [artifactName=" + this.artifactName + ", version=" + this.version + ", uploadedAt=" + this.uploadedAt + ", schedulingInfo=" + this.schedulingInfo + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobClusterConfig that = (JobClusterConfig)o;
        return this.uploadedAt == that.uploadedAt && Objects.equals(this.artifactName, that.artifactName) && Objects.equals(this.version, that.version) && Objects.equals(this.schedulingInfo, that.schedulingInfo);
    }

    public int hashCode() {
        return Objects.hash(this.artifactName, this.version, this.uploadedAt, this.schedulingInfo);
    }

    public static class Builder {
        String artifactName;
        String version;
        long uploadedAt = -1L;
        SchedulingInfo schedulingInfo;

        public Builder withArtifactName(String artifactName) {
            Preconditions.checkNotNull((Object)artifactName, (Object)"artifactName cannot be null");
            Preconditions.checkArgument((!artifactName.isEmpty() ? 1 : 0) != 0, (Object)"ArtifactName cannot be empty");
            this.artifactName = artifactName;
            return this;
        }

        public Builder withVersion(String version) {
            Preconditions.checkNotNull((Object)version, (Object)"version cannot be null");
            Preconditions.checkArgument((!version.isEmpty() ? 1 : 0) != 0, (Object)"version cannot be empty");
            this.version = version;
            return this;
        }

        public Builder withUploadedAt(long uAt) {
            Preconditions.checkArgument((uAt > 0L ? 1 : 0) != 0, (Object)"uploaded At cannot be <= 0");
            this.uploadedAt = uAt;
            return this;
        }

        public Builder withSchedulingInfo(SchedulingInfo sInfo) {
            Preconditions.checkNotNull((Object)sInfo, (Object)"schedulingInfo cannot be null");
            this.schedulingInfo = sInfo;
            return this;
        }

        public Builder from(JobClusterConfig config) {
            this.artifactName = config.getArtifactName();
            this.version = config.getVersion();
            this.uploadedAt = config.getUploadedAt();
            this.schedulingInfo = config.getSchedulingInfo();
            return this;
        }

        public JobClusterConfig build() {
            Preconditions.checkNotNull((Object)this.artifactName);
            Preconditions.checkNotNull((Object)this.schedulingInfo);
            this.uploadedAt = this.uploadedAt == -1L ? System.currentTimeMillis() : this.uploadedAt;
            this.version = this.version == null || this.version.isEmpty() ? "" + System.currentTimeMillis() : this.version;
            return new JobClusterConfig(this.artifactName, this.uploadedAt, this.version, this.schedulingInfo);
        }
    }
}

