/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.domain;

import io.mantisrx.common.Label;
import io.mantisrx.master.jobcluster.LabelManager;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.runtime.JobOwner;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.domain.IJobClusterDefinition;
import io.mantisrx.server.master.domain.JobClusterConfig;
import io.mantisrx.server.master.domain.SLA;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClusterDefinitionImpl
implements IJobClusterDefinition {
    private static final Logger logger = LoggerFactory.getLogger(JobClusterDefinitionImpl.class);
    private final String name;
    private final String user;
    private final JobOwner owner;
    private final SLA sla;
    private final WorkerMigrationConfig migrationConfig;
    private final List<JobClusterConfig> jobClusterConfigs = Lists.newArrayList();
    private final List<Parameter> parameters;
    private final List<Label> labels;
    private boolean isReadyForJobMaster = false;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobClusterDefinitionImpl(@JsonProperty(value="name") String name, @JsonProperty(value="jobClusterConfigs") List<JobClusterConfig> jobClusterConfigs, @JsonProperty(value="owner") JobOwner owner, @JsonProperty(value="user") String user, @JsonProperty(value="sla") SLA sla, @JsonProperty(value="migrationConfig") WorkerMigrationConfig migrationConfig, @JsonProperty(value="isReadyForJobMaster") boolean isReadyForJobMaster, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="labels") List<Label> labels, @JsonProperty(value="isDisabled") boolean isDisabled) {
        Preconditions.checkNotNull(jobClusterConfigs);
        Preconditions.checkArgument((!jobClusterConfigs.isEmpty() ? 1 : 0) != 0);
        this.owner = owner;
        this.name = name;
        this.sla = Optional.ofNullable(sla).orElse(new SLA(0, 0, null, IJobClusterDefinition.CronPolicy.KEEP_EXISTING));
        this.migrationConfig = Optional.ofNullable(migrationConfig).orElse(WorkerMigrationConfig.DEFAULT);
        this.isReadyForJobMaster = isReadyForJobMaster;
        this.jobClusterConfigs.addAll(jobClusterConfigs);
        this.labels = Optional.ofNullable(labels).orElse(Lists.newArrayList());
        this.parameters = Optional.ofNullable(parameters).orElse(Lists.newArrayList());
        this.user = user;
        if (!isDisabled) {
            Preconditions.checkNotNull(labels, (Object)"labels cannot be empty.");
            Preconditions.checkArgument((boolean)labels.stream().anyMatch(l -> l.getName().equalsIgnoreCase(LabelManager.SystemLabels.MANTIS_RESOURCE_CLUSTER_NAME_LABEL.label)), (Object)("Missing required label: " + LabelManager.SystemLabels.MANTIS_RESOURCE_CLUSTER_NAME_LABEL.label));
        }
    }

    public JobClusterDefinitionImpl(String name, List<JobClusterConfig> jobClusterConfigs, JobOwner owner, String user, SLA sla, WorkerMigrationConfig migrationConfig, boolean isReadyForJobMaster, List<Parameter> parameters, List<Label> labels) {
        this(name, jobClusterConfigs, owner, user, sla, migrationConfig, isReadyForJobMaster, parameters, labels, false);
    }

    @Override
    public JobOwner getOwner() {
        return this.owner;
    }

    @Override
    public SLA getSLA() {
        return this.sla;
    }

    @Override
    public WorkerMigrationConfig getWorkerMigrationConfig() {
        return this.migrationConfig;
    }

    @Override
    public boolean getIsReadyForJobMaster() {
        return this.isReadyForJobMaster;
    }

    @Override
    public List<JobClusterConfig> getJobClusterConfigs() {
        return Collections.unmodifiableList(this.jobClusterConfigs);
    }

    @Override
    public JobClusterConfig getJobClusterConfig() {
        return this.jobClusterConfigs.get(this.jobClusterConfigs.size() - 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<Label> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    @Override
    public String toString() {
        return "JobClusterDefinitionImpl{name='" + this.name + '\'' + ", user='" + this.user + '\'' + ", owner=" + this.owner + ", sla=" + this.sla + ", migrationConfig=" + this.migrationConfig + ", isReadyForJobMaster=" + this.isReadyForJobMaster + ", jobClusterConfigs=" + this.jobClusterConfigs + ", parameters=" + this.parameters + ", labels=" + this.labels + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobClusterDefinitionImpl that = (JobClusterDefinitionImpl)o;
        return this.isReadyForJobMaster == that.isReadyForJobMaster && Objects.equals(this.name, that.name) && Objects.equals(this.user, that.user) && Objects.equals(this.owner, that.owner) && Objects.equals(this.sla, that.sla) && Objects.equals(this.migrationConfig, that.migrationConfig) && Objects.equals(this.jobClusterConfigs, that.jobClusterConfigs) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.labels, that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.user, this.owner, this.sla, this.migrationConfig, this.isReadyForJobMaster, this.jobClusterConfigs, this.parameters, this.labels);
    }

    public static class Builder {
        List<JobClusterConfig> jobClusterConfigs = new ArrayList<JobClusterConfig>();
        JobOwner owner = null;
        SLA sla = new SLA(0, 0, null, null);
        WorkerMigrationConfig migrationConfig = WorkerMigrationConfig.DEFAULT;
        boolean isReadyForJobMaster = true;
        String name = null;
        String user = "default";
        List<Parameter> parameters = Lists.newArrayList();
        List<Label> labels = Lists.newArrayList();
        boolean isDisabled = false;

        public Builder withName(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"Cluster name cannot be null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"cluster Name cannot be empty");
            this.name = name;
            return this;
        }

        public Builder withUser(String user) {
            Preconditions.checkNotNull((Object)user, (Object)"user  cannot be null");
            Preconditions.checkArgument((!user.isEmpty() ? 1 : 0) != 0, (Object)"user cannot be empty");
            this.user = user;
            return this;
        }

        public Builder withJobClusterConfig(JobClusterConfig config) {
            Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
            if (!this.jobClusterConfigs.contains(config)) {
                this.jobClusterConfigs.add(config);
            }
            return this;
        }

        public Builder withJobClusterConfigs(List<JobClusterConfig> jars) {
            Preconditions.checkNotNull(jars, (Object)"config list cannot be null");
            this.jobClusterConfigs = jars;
            return this;
        }

        public Builder withOwner(JobOwner owner) {
            Preconditions.checkNotNull((Object)owner, (Object)"owner  cannot be null");
            this.owner = owner;
            return this;
        }

        public Builder withSla(SLA sla) {
            Preconditions.checkNotNull((Object)sla, (Object)"sla  cannot be null");
            this.sla = sla;
            return this;
        }

        public Builder withMigrationConfig(WorkerMigrationConfig config) {
            Preconditions.checkNotNull((Object)config, (Object)"migration config cannot be null");
            this.migrationConfig = config;
            return this;
        }

        public Builder withIsReadyForJobMaster(boolean ready) {
            this.isReadyForJobMaster = ready;
            return this;
        }

        public Builder withParameters(List<Parameter> ps) {
            this.parameters = ps;
            return this;
        }

        public Builder withLabels(List<Label> labels) {
            this.labels = labels;
            return this;
        }

        public Builder withLabel(Label label) {
            Preconditions.checkNotNull((Object)label, (Object)"label cannot be null");
            this.labels.add(label);
            return this;
        }

        public Builder withIsDisabled(boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public Builder from(IJobClusterDefinition defn) {
            this.migrationConfig = defn.getWorkerMigrationConfig();
            this.name = defn.getName();
            this.sla = defn.getSLA();
            this.isReadyForJobMaster = defn.getIsReadyForJobMaster();
            this.owner = defn.getOwner();
            this.user = defn.getUser();
            this.parameters = defn.getParameters();
            this.labels = defn.getLabels();
            for (JobClusterConfig jcConfig : defn.getJobClusterConfigs()) {
                if (this.jobClusterConfigs.contains(jcConfig)) continue;
                this.jobClusterConfigs.add(jcConfig);
            }
            return this;
        }

        public Builder mergeConfigsAndOverrideRest(IJobClusterDefinition oldDefn, IJobClusterDefinition newDefn) {
            List<JobClusterConfig> oldConfigs = oldDefn.getJobClusterConfigs();
            logger.info("Existing JobClusterConfigs {} ", oldConfigs);
            logger.info("New JobClusterConfig {} ", (Object)newDefn.getJobClusterConfig());
            if (oldConfigs != null) {
                List<JobClusterConfig> subList = Collections.unmodifiableList(oldConfigs.subList(Math.max(0, oldConfigs.size() - 3), oldConfigs.size()));
                this.jobClusterConfigs.addAll(subList);
            }
            this.jobClusterConfigs.add(newDefn.getJobClusterConfig());
            logger.info("Merged JobClusterConfigs {} ", this.jobClusterConfigs);
            this.sla = newDefn.getSLA();
            this.parameters = newDefn.getParameters();
            this.labels = newDefn.getLabels();
            this.user = newDefn.getUser();
            this.migrationConfig = newDefn.getWorkerMigrationConfig();
            this.owner = newDefn.getOwner();
            this.isReadyForJobMaster = newDefn.getIsReadyForJobMaster();
            this.name = oldDefn.getName();
            return this;
        }

        public JobClusterDefinitionImpl build() {
            Preconditions.checkNotNull((Object)this.owner);
            Preconditions.checkNotNull((Object)this.name);
            Preconditions.checkNotNull((Object)this.user);
            Preconditions.checkNotNull(this.jobClusterConfigs);
            Preconditions.checkArgument((!this.jobClusterConfigs.isEmpty() ? 1 : 0) != 0);
            return new JobClusterDefinitionImpl(this.name, this.jobClusterConfigs, this.owner, this.user, this.sla, this.migrationConfig, this.isReadyForJobMaster, this.parameters, this.labels, this.isDisabled);
        }
    }

    public static class CompletedJob {
        private final String name;
        private final String jobId;
        private final String version;
        private final JobState state;
        private final long submittedAt;
        private final long terminatedAt;
        private final String user;
        private final List<Label> labelList;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public CompletedJob(@JsonProperty(value="name") String name, @JsonProperty(value="jobId") String jobId, @JsonProperty(value="version") String version, @JsonProperty(value="state") JobState state, @JsonProperty(value="submittedAt") long submittedAt, @JsonProperty(value="terminatedAt") long terminatedAt, @JsonProperty(value="user") String user, @JsonProperty(value="labels") List<Label> labels) {
            this.name = name;
            this.jobId = jobId;
            this.version = version;
            this.state = state;
            this.submittedAt = submittedAt;
            this.terminatedAt = terminatedAt;
            this.user = user;
            this.labelList = labels;
        }

        public String getName() {
            return this.name;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getVersion() {
            return this.version;
        }

        public JobState getState() {
            return this.state;
        }

        public long getSubmittedAt() {
            return this.submittedAt;
        }

        public long getTerminatedAt() {
            return this.terminatedAt;
        }

        public String getUser() {
            return this.user;
        }

        public List<Label> getLabelList() {
            return this.labelList;
        }

        public String toString() {
            return "CompletedJob{name='" + this.name + '\'' + ", jobId='" + this.jobId + '\'' + ", version='" + this.version + '\'' + ", state=" + (Object)((Object)this.state) + ", submittedAt=" + this.submittedAt + ", terminatedAt=" + this.terminatedAt + ", user='" + this.user + '\'' + ", labelList=" + this.labelList + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletedJob that = (CompletedJob)o;
            return this.submittedAt == that.submittedAt && this.terminatedAt == that.terminatedAt && Objects.equals(this.name, that.name) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.version, that.version) && this.state == that.state && Objects.equals(this.user, that.user);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.jobId, this.version, this.state, this.submittedAt, this.terminatedAt, this.user});
        }
    }
}

