/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.domain;

import io.mantisrx.common.Label;
import io.mantisrx.master.jobcluster.LabelManager;
import io.mantisrx.runtime.JobSla;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.MantisJobDurationType;
import io.mantisrx.runtime.command.InvalidJobException;
import io.mantisrx.runtime.descriptor.DeploymentStrategy;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.base.Strings;
import io.mantisrx.shaded.com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class JobDefinition {
    private final String name;
    private final String user;
    private final String artifactName;
    private final String version;
    private final List<Parameter> parameters;
    private final JobSla jobSla;
    private final long subscriptionTimeoutSecs;
    private final SchedulingInfo schedulingInfo;
    private final DeploymentStrategy deploymentStrategy;
    private final int withNumberOfStages;
    private Map<String, Label> labels;
    private final Map<String, String> schedulingConstraints;
    private static final Pattern MANTIS_SCHEDULING_ATTRIBUTE_LABEL_REGEX = Pattern.compile("_mantis\\.schedulingAttribute\\.(.+)", 2);

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobDefinition(@JsonProperty(value="name") String name, @JsonProperty(value="user") String user, @JsonProperty(value="artifactName") String artifactName, @JsonProperty(value="version") String version, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="jobSla") JobSla jobSla, @JsonProperty(value="subscriptionTimeoutSecs") long subscriptionTimeoutSecs, @JsonProperty(value="schedulingInfo") SchedulingInfo schedulingInfo, @JsonProperty(value="numberOfStages") int withNumberOfStages, @JsonProperty(value="labels") List<Label> labels, @JsonProperty(value="deploymentStrategy") DeploymentStrategy deploymentStrategy) throws InvalidJobException {
        this.name = name;
        this.user = user;
        this.artifactName = artifactName;
        this.version = version;
        this.parameters = parameters != null ? parameters : new LinkedList<Parameter>();
        this.labels = labels != null ? labels.stream().collect(Collectors.toMap(Label::getName, Function.identity(), (l1, l2) -> l2)) : new HashMap<String, Label>();
        this.jobSla = jobSla;
        this.subscriptionTimeoutSecs = subscriptionTimeoutSecs > 0L ? subscriptionTimeoutSecs : 0L;
        this.schedulingInfo = schedulingInfo;
        this.deploymentStrategy = deploymentStrategy;
        this.withNumberOfStages = withNumberOfStages;
        this.schedulingConstraints = this.labels.entrySet().stream().map(label -> {
            Matcher matcher = MANTIS_SCHEDULING_ATTRIBUTE_LABEL_REGEX.matcher((CharSequence)label.getKey());
            return matcher.find() ? Pair.of((Object)matcher.group(1), (Object)((Label)label.getValue()).getValue()) : null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        this.postProcess();
        this.validate(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinition that = (JobDefinition)o;
        return this.subscriptionTimeoutSecs == that.subscriptionTimeoutSecs && this.withNumberOfStages == that.withNumberOfStages && Objects.equals(this.name, that.name) && Objects.equals(this.user, that.user) && Objects.equals(this.artifactName, that.artifactName) && Objects.equals(this.version, that.version) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.jobSla, that.jobSla) && Objects.equals(this.labels, that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.user, this.artifactName, this.version, this.parameters, this.jobSla, this.subscriptionTimeoutSecs, this.labels, this.withNumberOfStages);
    }

    public void validate(boolean schedulingInfoOptional) throws InvalidJobException {
        this.validateSla();
        this.validateSchedulingInfo(schedulingInfoOptional);
    }

    public boolean requireInheritInstanceCheck() {
        return this.schedulingInfo != null && this.deploymentStrategy != null && this.getDeploymentStrategy().requireInheritInstanceCheck();
    }

    public boolean requireInheritInstanceCheck(int stageNum) {
        return this.schedulingInfo != null && this.getSchedulingInfo().getStages().containsKey(stageNum) && this.deploymentStrategy != null && this.getDeploymentStrategy().requireInheritInstanceCheck(stageNum);
    }

    private void validateSla() throws InvalidJobException {
        if (this.jobSla == null) {
            throw new InvalidJobException("No Job SLA provided (likely incorrect job submit request)");
        }
        if (this.jobSla.getDurationType() == null) {
            throw new InvalidJobException("Invalid null duration type in job sla (likely incorrect job submit request");
        }
    }

    public void validateSchedulingInfo() throws InvalidJobException {
        this.validateSchedulingInfo(false);
    }

    private void postProcess() {
        if (this.deploymentStrategy != null && !Strings.isNullOrEmpty((String)this.deploymentStrategy.getResourceClusterId())) {
            this.labels.put(LabelManager.SystemLabels.MANTIS_RESOURCE_CLUSTER_NAME_LABEL.label, new Label(LabelManager.SystemLabels.MANTIS_RESOURCE_CLUSTER_NAME_LABEL.label, this.deploymentStrategy.getResourceClusterId()));
        }
    }

    private void validateSchedulingInfo(boolean schedulingInfoOptional) throws InvalidJobException {
        if (schedulingInfoOptional && this.schedulingInfo == null) {
            return;
        }
        if (this.schedulingInfo == null) {
            throw new InvalidJobException("No scheduling info provided");
        }
        if (this.schedulingInfo.getStages() == null) {
            throw new InvalidJobException("No stages defined in scheduling info");
        }
        int withNumberOfStages = this.schedulingInfo.getStages().size();
        int startingIdx = 1;
        if (this.schedulingInfo.forStage(0) != null) {
            startingIdx = 0;
            --withNumberOfStages;
        }
        for (int i = startingIdx; i <= withNumberOfStages; ++i) {
            StageSchedulingInfo stage = (StageSchedulingInfo)this.schedulingInfo.getStages().get(i);
            if (stage == null) {
                throw new InvalidJobException("No definition for stage " + i + " in scheduling info for " + withNumberOfStages + " stage job");
            }
            if (stage.getNumberOfInstances() < 1) {
                throw new InvalidJobException("Number of instance for stage " + i + " must be >0, not " + stage.getNumberOfInstances());
            }
            MachineDefinition machineDefinition = stage.getMachineDefinition();
            if (machineDefinition.getCpuCores() <= 0.0) {
                throw new InvalidJobException("cpuCores must be >0.0, not " + machineDefinition.getCpuCores());
            }
            if (machineDefinition.getMemoryMB() <= 0.0) {
                throw new InvalidJobException("memory must be <0.0, not " + machineDefinition.getMemoryMB());
            }
            if (machineDefinition.getDiskMB() < 0.0) {
                throw new InvalidJobException("disk must be >=0, not " + machineDefinition.getDiskMB());
            }
            if (machineDefinition.getNumPorts() >= 0) continue;
            throw new InvalidJobException("numPorts must be >=0, not " + machineDefinition.getNumPorts());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public JobSla getJobSla() {
        return this.jobSla;
    }

    public long getSubscriptionTimeoutSecs() {
        return this.subscriptionTimeoutSecs;
    }

    public SchedulingInfo getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public Map<String, String> getSchedulingConstraints() {
        return this.schedulingConstraints;
    }

    public DeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    public List<Label> getLabels() {
        return ImmutableList.copyOf(this.labels.values());
    }

    public int getNumberOfStages() {
        return this.withNumberOfStages;
    }

    public Optional<ClusterID> getResourceCluster() {
        return this.getLabels().stream().filter(label -> label.getName().equals(LabelManager.SystemLabels.MANTIS_RESOURCE_CLUSTER_NAME_LABEL.label)).findFirst().map(l -> ClusterID.of((String)l.getValue()));
    }

    @JsonIgnore
    public int getIntSystemParameter(String paramName, int defaultValue) {
        return this.getParameters().stream().filter(p -> paramName.equals(p.getName())).map(Parameter::getValue).filter(Objects::nonNull).map(v -> {
            try {
                return Integer.parseInt(v);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }).findFirst().orElse(defaultValue);
    }

    public String toString() {
        return "JobDefinition(name=" + this.getName() + ", user=" + this.getUser() + ", artifactName=" + this.getArtifactName() + ", version=" + this.getVersion() + ", parameters=" + this.getParameters() + ", jobSla=" + this.getJobSla() + ", subscriptionTimeoutSecs=" + this.getSubscriptionTimeoutSecs() + ", schedulingInfo=" + this.getSchedulingInfo() + ", deploymentStrategy=" + this.getDeploymentStrategy() + ", withNumberOfStages=" + this.withNumberOfStages + ", labels=" + this.getLabels() + ", schedulingConstraints=" + this.getSchedulingConstraints() + ")";
    }

    public static class Builder {
        private String name;
        private String user;
        private List<Parameter> parameters;
        private List<Label> labels;
        private String artifactName = null;
        private String version = null;
        private JobSla jobSla = new JobSla(0L, 0L, JobSla.StreamSLAType.Lossy, MantisJobDurationType.Transient, null);
        private long subscriptionTimeoutSecs = 0L;
        private SchedulingInfo schedulingInfo;
        private DeploymentStrategy deploymentStrategy;
        private int withNumberOfStages = 1;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withArtifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public Builder withJobSla(JobSla sla) {
            this.jobSla = sla;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withSchedulingInfo(SchedulingInfo schedInfo) {
            this.schedulingInfo = schedInfo;
            return this;
        }

        public Builder withDeploymentStrategy(DeploymentStrategy strategy) {
            this.deploymentStrategy = strategy;
            return this;
        }

        public Builder withNumberOfStages(int stages) {
            this.withNumberOfStages = stages;
            return this;
        }

        public Builder withSubscriptionTimeoutSecs(long t) {
            this.subscriptionTimeoutSecs = t;
            return this;
        }

        public Builder withParameters(List<Parameter> params) {
            this.parameters = params;
            return this;
        }

        public Builder withLabels(List<Label> labels) {
            this.labels = labels;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder from(JobDefinition jobDefinition) {
            this.withJobSla(jobDefinition.getJobSla());
            this.withNumberOfStages(jobDefinition.getNumberOfStages());
            this.withSubscriptionTimeoutSecs(jobDefinition.getSubscriptionTimeoutSecs());
            this.withUser(jobDefinition.user);
            this.withSchedulingInfo(jobDefinition.getSchedulingInfo());
            this.withDeploymentStrategy(jobDefinition.getDeploymentStrategy());
            this.withParameters(jobDefinition.getParameters());
            this.withLabels(jobDefinition.getLabels());
            this.withName(jobDefinition.name);
            this.withArtifactName(jobDefinition.artifactName);
            this.withVersion(jobDefinition.getVersion());
            return this;
        }

        public Builder fromWithInstanceCountInheritance(JobDefinition jobDefinition, boolean forceInheritance, Function<Integer, Optional<Integer>> getExistingInstanceCountForStage) {
            this.from(jobDefinition);
            SchedulingInfo.Builder mergedSInfoBuilder = new SchedulingInfo.Builder().createWithInstanceInheritance(jobDefinition.getSchedulingInfo().getStages(), getExistingInstanceCountForStage, jobDefinition::requireInheritInstanceCheck, forceInheritance);
            this.withSchedulingInfo(mergedSInfoBuilder.build());
            return this;
        }

        public JobDefinition build() throws InvalidJobException {
            Preconditions.checkNotNull((Object)this.name, (Object)"cluster name cannot be null");
            Preconditions.checkNotNull((Object)this.jobSla, (Object)"job sla cannot be null");
            if (this.schedulingInfo != null) {
                this.withNumberOfStages = this.schedulingInfo.getStages().size();
            }
            Preconditions.checkArgument((this.withNumberOfStages > 0 ? 1 : 0) != 0, (Object)"Number of stages cannot be less than 0");
            return new JobDefinition(this.name, this.user, this.artifactName, this.version, this.parameters, this.jobSla, this.subscriptionTimeoutSecs, this.schedulingInfo, this.withNumberOfStages, this.labels, this.deploymentStrategy);
        }
    }
}

