/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.domain;

import com.netflix.fenzo.triggers.CronTrigger;
import com.netflix.fenzo.triggers.TriggerOperator;
import com.netflix.fenzo.triggers.exceptions.SchedulerException;
import com.netflix.fenzo.triggers.exceptions.TriggerNotFoundException;
import io.mantisrx.server.master.domain.IJobClusterDefinition;
import io.mantisrx.server.master.store.NamedJob;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLA {
    private static final Logger logger = LoggerFactory.getLogger(SLA.class);
    @JsonIgnore
    private static final int MaxValueForSlaMin = 5;
    @JsonIgnore
    private static final int MaxValueForSlaMax = 100;
    @JsonIgnore
    private static final TriggerOperator triggerOperator = new TriggerOperator(1);
    private final int min;
    private final int max;
    private final String cronSpec;
    private final IJobClusterDefinition.CronPolicy cronPolicy;
    @JsonIgnore
    private final boolean hasCronSpec;
    @JsonIgnore
    private final IJobClusterDefinition.CronPolicy defaultPolicy = IJobClusterDefinition.CronPolicy.KEEP_EXISTING;
    @JsonIgnore
    private CronTrigger<NamedJob> scheduledTrigger;
    @JsonIgnore
    private String triggerGroup = null;
    @JsonIgnore
    private String triggerId = null;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public SLA(@JsonProperty(value="min") int min, @JsonProperty(value="max") int max, @JsonProperty(value="cronSpec") String cronSpec, @JsonProperty(value="cronPolicy") IJobClusterDefinition.CronPolicy cronPolicy) {
        if (cronSpec != null && !cronSpec.isEmpty()) {
            this.cronSpec = cronSpec;
            this.hasCronSpec = true;
            this.max = 1;
            this.min = 0;
            this.cronPolicy = cronPolicy == null ? this.defaultPolicy : cronPolicy;
        } else {
            this.hasCronSpec = false;
            this.min = min;
            this.max = max;
            this.cronSpec = null;
            this.cronPolicy = null;
        }
        this.validate();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String getCronSpec() {
        return this.cronSpec;
    }

    public IJobClusterDefinition.CronPolicy getCronPolicy() {
        return this.cronPolicy;
    }

    private void validate() throws IllegalArgumentException {
        if (this.max < this.min) {
            throw new IllegalArgumentException("Cannot have max=" + this.max + " < min=" + this.min);
        }
        if (this.min > 5) {
            throw new IllegalArgumentException("Specified min sla value " + this.min + " cannot be >" + 5);
        }
        if (this.max > 100) {
            throw new IllegalArgumentException("Max sla value " + this.max + " cannot be >" + 100);
        }
    }

    private void initCron(NamedJob job) throws SchedulerException {
        if (!this.hasCronSpec || this.triggerId != null) {
            return;
        }
        logger.info("Init'ing cron for " + job.getName());
        this.triggerGroup = job.getName() + "-" + this;
        try {
            this.scheduledTrigger = new CronTrigger(this.cronSpec, job.getName(), (Object)job, NamedJob.class, NamedJob.CronTriggerAction.class);
            this.triggerId = triggerOperator.registerTrigger(this.triggerGroup, this.scheduledTrigger);
        }
        catch (IllegalArgumentException e) {
            throw new SchedulerException(e.getMessage(), (Throwable)e);
        }
    }

    private void destroyCron() {
        try {
            if (this.triggerId != null) {
                logger.info("Destroying cron " + this.triggerId);
                triggerOperator.deleteTrigger(this.triggerGroup, this.triggerId);
                this.triggerId = null;
            }
        }
        catch (SchedulerException | TriggerNotFoundException e) {
            logger.warn("Couldn't delete trigger group " + this.triggerGroup + ", id " + this.triggerId);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cronPolicy == null ? 0 : this.cronPolicy.hashCode());
        result = 31 * result + (this.cronSpec == null ? 0 : this.cronSpec.hashCode());
        result = 31 * result + (this.defaultPolicy == null ? 0 : this.defaultPolicy.hashCode());
        result = 31 * result + (this.hasCronSpec ? 1231 : 1237);
        result = 31 * result + this.max;
        result = 31 * result + this.min;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SLA other = (SLA)obj;
        if (this.cronPolicy != other.cronPolicy) {
            return false;
        }
        if (this.cronSpec == null ? other.cronSpec != null : !this.cronSpec.equals(other.cronSpec)) {
            return false;
        }
        if (this.defaultPolicy != other.defaultPolicy) {
            return false;
        }
        if (this.hasCronSpec != other.hasCronSpec) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        return this.min == other.min;
    }

    public String toString() {
        return "SLA [min=" + this.min + ", max=" + this.max + ", cronSpec=" + this.cronSpec + ", cronPolicy=" + (Object)((Object)this.cronPolicy) + ", hasCronSpec=" + this.hasCronSpec + ", defaultPolicy=" + (Object)((Object)this.defaultPolicy) + ", scheduledTrigger=" + this.scheduledTrigger + ", triggerGroup=" + this.triggerGroup + ", triggerId=" + this.triggerId + "]";
    }

    static {
        try {
            triggerOperator.initialize();
        }
        catch (SchedulerException e) {
            logger.error("Unexpected: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

