/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.http.api;

import io.mantisrx.common.Label;
import io.mantisrx.runtime.JobOwner;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.store.NamedJob;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class JobClusterInfo {
    private final String name;
    private final String latestVersion;
    private final NamedJob.SLA sla;
    private final JobOwner owner;
    private final boolean disabled;
    private final boolean cronActive;
    private final List<JarInfo> jars;
    private final List<Parameter> parameters;
    private final List<Label> labels;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobClusterInfo(@JsonProperty(value="name") String name, @JsonProperty(value="sla") NamedJob.SLA sla, @JsonProperty(value="owner") JobOwner owner, @JsonProperty(value="disabled") boolean disabled, @JsonProperty(value="cronActive") boolean cronActive, @JsonProperty(value="jars") List<JarInfo> jars, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="labels") List<Label> labels) {
        this.name = name;
        this.sla = sla;
        this.owner = owner;
        this.disabled = disabled;
        this.cronActive = cronActive;
        this.jars = jars;
        this.labels = labels;
        if (jars == null || jars.isEmpty()) {
            this.latestVersion = "";
        } else {
            JarInfo latest = null;
            for (JarInfo ji : jars) {
                if (latest != null && ji.uploadedAt <= latest.uploadedAt) continue;
                latest = ji;
            }
            this.latestVersion = latest == null ? "" : latest.version;
        }
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public NamedJob.SLA getSla() {
        return this.sla;
    }

    public JobOwner getOwner() {
        return this.owner;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isCronActive() {
        return this.cronActive;
    }

    public List<JarInfo> getJars() {
        return this.jars;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public static class JarInfo {
        private final String version;
        private final long uploadedAt;
        private final String url;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public JarInfo(@JsonProperty(value="version") String version, @JsonProperty(value="uploadedAt") long uploadedAt, @JsonProperty(value="url") String url) {
            this.version = version;
            this.uploadedAt = uploadedAt;
            this.url = url;
        }

        public String getVersion() {
            return this.version;
        }

        public long getUploadedAt() {
            return this.uploadedAt;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

