/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.scheduler;

import io.mantisrx.common.WorkerPorts;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import java.util.Objects;
import java.util.Optional;

public class WorkerLaunched
implements WorkerEvent {
    private final WorkerId workerId;
    private final int stageNum;
    private final String hostname;
    private final String vmId;
    private final Optional<String> clusterName;
    private final Optional<ClusterID> resourceCluster;
    private final WorkerPorts ports;
    private final long eventTimeMs = System.currentTimeMillis();

    public WorkerLaunched(WorkerId workerId, int stageNum, String hostname, String vmId, Optional<String> clusterName, Optional<ClusterID> resourceCluster, WorkerPorts ports) {
        this.workerId = workerId;
        this.stageNum = stageNum;
        this.hostname = hostname;
        this.vmId = vmId;
        this.clusterName = clusterName;
        this.resourceCluster = resourceCluster;
        this.ports = ports;
    }

    @Override
    public WorkerId getWorkerId() {
        return this.workerId;
    }

    public int getStageNum() {
        return this.stageNum;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getVmId() {
        return this.vmId;
    }

    public Optional<String> getClusterName() {
        return this.clusterName;
    }

    public Optional<ClusterID> getResourceCluster() {
        return this.resourceCluster;
    }

    public WorkerPorts getPorts() {
        return this.ports;
    }

    @Override
    public long getEventTimeMs() {
        return this.eventTimeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerLaunched that = (WorkerLaunched)o;
        return this.stageNum == that.stageNum && this.eventTimeMs == that.eventTimeMs && Objects.equals(this.workerId, that.workerId) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.vmId, that.vmId) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.ports, that.ports);
    }

    public int hashCode() {
        return Objects.hash(this.workerId, this.stageNum, this.hostname, this.vmId, this.clusterName, this.ports, this.eventTimeMs);
    }

    public String toString() {
        return "WorkerLaunched{workerId=" + this.workerId + ", stageNum=" + this.stageNum + ", hostname='" + this.hostname + '\'' + ", vmId='" + this.vmId + '\'' + ", clusterName=" + this.clusterName + ", ports=" + this.ports + ", eventTimeMs=" + this.eventTimeMs + '}';
    }
}

