/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.scheduler;

import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import java.util.Objects;

public class WorkerResourceStatus
implements WorkerEvent {
    private final WorkerId workerId;
    private final String message;
    private final VMResourceState state;
    private final long eventTimeMs = System.currentTimeMillis();

    public WorkerResourceStatus(WorkerId workerId, String message, VMResourceState state) {
        this.workerId = workerId;
        this.message = message;
        this.state = state;
    }

    @Override
    public WorkerId getWorkerId() {
        return this.workerId;
    }

    public String getMessage() {
        return this.message;
    }

    public VMResourceState getState() {
        return this.state;
    }

    @Override
    public long getEventTimeMs() {
        return this.eventTimeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerResourceStatus that = (WorkerResourceStatus)o;
        return this.eventTimeMs == that.eventTimeMs && Objects.equals(this.workerId, that.workerId) && Objects.equals(this.message, that.message) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workerId, this.message, this.state, this.eventTimeMs});
    }

    public String toString() {
        return "WorkerResourceStatus{workerId=" + this.workerId + ", message='" + this.message + '\'' + ", state=" + (Object)((Object)this.state) + ", eventTimeMs=" + this.eventTimeMs + '}';
    }

    public static enum VMResourceState {
        STARTED,
        START_INITIATED,
        COMPLETED,
        FAILED;

    }
}

