/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.store;

import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.server.master.store.InvalidJobException;
import io.mantisrx.server.master.store.MantisStageMetadata;
import io.mantisrx.server.master.store.MantisWorkerMetadata;
import io.mantisrx.server.master.store.MantisWorkerMetadataWritable;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisStageMetadataWritable
implements MantisStageMetadata {
    private static final Logger logger = LoggerFactory.getLogger(MantisStageMetadataWritable.class);
    @JsonIgnore
    private final ConcurrentMap<Integer, MantisWorkerMetadata> workerByIndexMetadataSet;
    @JsonIgnore
    private final ConcurrentMap<Integer, MantisWorkerMetadata> workerByNumberMetadataSet;
    private String jobId;
    private int stageNum;
    private int numStages;
    private MachineDefinition machineDefinition;
    private int numWorkers;
    private List<JobConstraints> hardConstraints;
    private List<JobConstraints> softConstraints;
    private StageScalingPolicy scalingPolicy;
    private boolean scalable;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisStageMetadataWritable(@JsonProperty(value="jobId") String jobId, @JsonProperty(value="stageNum") int stageNum, @JsonProperty(value="numStages") int numStages, @JsonProperty(value="machineDefinition") MachineDefinition machineDefinition, @JsonProperty(value="numWorkers") int numWorkers, @JsonProperty(value="hardConstraints") List<JobConstraints> hardConstraints, @JsonProperty(value="softConstraints") List<JobConstraints> softConstraints, @JsonProperty(value="scalingPolicy") StageScalingPolicy scalingPolicy, @JsonProperty(value="scalable") boolean scalable) {
        this.jobId = jobId;
        this.stageNum = stageNum;
        this.numStages = numStages;
        this.machineDefinition = machineDefinition;
        this.numWorkers = numWorkers;
        this.hardConstraints = hardConstraints;
        this.softConstraints = softConstraints;
        this.scalingPolicy = scalingPolicy;
        this.scalable = scalable;
        this.workerByIndexMetadataSet = new ConcurrentHashMap<Integer, MantisWorkerMetadata>();
        this.workerByNumberMetadataSet = new ConcurrentHashMap<Integer, MantisWorkerMetadata>();
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public int getStageNum() {
        return this.stageNum;
    }

    @Override
    public int getNumStages() {
        return this.numStages;
    }

    @Override
    public int getNumWorkers() {
        return this.numWorkers;
    }

    @JsonIgnore
    public int getNumActiveWorkers() {
        int active = 0;
        for (MantisWorkerMetadata w : this.workerByIndexMetadataSet.values()) {
            if (MantisJobState.isTerminalState((MantisJobState)w.getState())) continue;
            ++active;
        }
        return active;
    }

    public void unsafeSetNumWorkers(int numWorkers) {
        this.numWorkers = numWorkers;
    }

    public boolean unsafeRemoveWorker(int index, int number) {
        MantisWorkerMetadata removedIdx = (MantisWorkerMetadata)this.workerByIndexMetadataSet.remove(index);
        MantisWorkerMetadata removedNum = (MantisWorkerMetadata)this.workerByNumberMetadataSet.remove(number);
        return removedIdx != null && removedNum != null && removedIdx.getWorkerNumber() == number && removedNum.getWorkerIndex() == index;
    }

    @Override
    public List<JobConstraints> getHardConstraints() {
        return this.hardConstraints;
    }

    @Override
    public List<JobConstraints> getSoftConstraints() {
        return this.softConstraints;
    }

    @Override
    public StageScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    public void setScalingPolicy(StageScalingPolicy scalingPolicy) {
        this.scalingPolicy = scalingPolicy;
    }

    @Override
    public boolean getScalable() {
        return this.scalable;
    }

    public void setScalable(boolean scalable) {
        this.scalable = scalable;
    }

    @Override
    public MachineDefinition getMachineDefinition() {
        return this.machineDefinition;
    }

    @Override
    @JsonIgnore
    public Collection<MantisWorkerMetadata> getWorkerByIndexMetadataSet() {
        return this.workerByIndexMetadataSet.values();
    }

    @Override
    @JsonIgnore
    public Collection<MantisWorkerMetadata> getAllWorkers() {
        return this.workerByNumberMetadataSet.values();
    }

    @Override
    @JsonIgnore
    public MantisWorkerMetadata getWorkerByIndex(int workerId) throws InvalidJobException {
        MantisWorkerMetadata mwmd = (MantisWorkerMetadata)this.workerByIndexMetadataSet.get(workerId);
        if (mwmd == null) {
            throw new InvalidJobException(this.jobId, -1, workerId);
        }
        return mwmd;
    }

    @Override
    @JsonIgnore
    public MantisWorkerMetadata getWorkerByWorkerNumber(int workerNumber) throws InvalidJobException {
        MantisWorkerMetadata mwmd = (MantisWorkerMetadata)this.workerByNumberMetadataSet.get(workerNumber);
        if (mwmd == null) {
            throw new InvalidJobException(this.jobId, -1, workerNumber);
        }
        return mwmd;
    }

    MantisWorkerMetadataWritable removeWorkerInErrorState(int workerNumber) {
        MantisWorkerMetadataWritable mwmd = (MantisWorkerMetadataWritable)this.workerByNumberMetadataSet.get(workerNumber);
        if (mwmd != null && MantisJobState.isErrorState((MantisJobState)mwmd.getState())) {
            this.workerByNumberMetadataSet.remove(workerNumber);
            return mwmd;
        }
        return null;
    }

    Collection<MantisWorkerMetadataWritable> removeArchiveableWorkers() {
        LinkedList<MantisWorkerMetadataWritable> removedWorkers = new LinkedList<MantisWorkerMetadataWritable>();
        HashSet workerNumbers = new HashSet(this.workerByNumberMetadataSet.keySet());
        for (Integer w : workerNumbers) {
            MantisWorkerMetadata mwmd = (MantisWorkerMetadata)this.workerByNumberMetadataSet.get(w);
            MantisWorkerMetadata wi = (MantisWorkerMetadata)this.workerByIndexMetadataSet.get(mwmd.getWorkerIndex());
            if (wi != null && wi.getWorkerNumber() == mwmd.getWorkerNumber()) continue;
            this.workerByNumberMetadataSet.remove(w);
            removedWorkers.add((MantisWorkerMetadataWritable)mwmd);
        }
        return removedWorkers;
    }

    public boolean replaceWorkerIndex(MantisWorkerMetadata newWorker) {
        int index = newWorker.getWorkerIndex();
        boolean result = true;
        if (this.workerByIndexMetadataSet.containsKey(index)) {
            MantisWorkerMetadata existingWorker = (MantisWorkerMetadata)this.workerByIndexMetadataSet.get(index);
            int existingWorkerNum = existingWorker.getWorkerNumber();
            if (existingWorkerNum >= newWorker.getWorkerNumber()) {
                logger.warn("Encounter stale worker: {} when newer worker exist: {}, ignore.", (Object)newWorker, (Object)existingWorker);
                result = false;
            } else {
                logger.warn("Replace stale worker {} with {}.", (Object)existingWorker, (Object)newWorker);
                this.addNewWorker(newWorker);
            }
        } else {
            this.addNewWorker(newWorker);
        }
        return result;
    }

    private void addNewWorker(MantisWorkerMetadata newWorker) {
        this.workerByIndexMetadataSet.put(newWorker.getWorkerIndex(), newWorker);
        this.workerByNumberMetadataSet.put(newWorker.getWorkerNumber(), newWorker);
    }
}

