/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.store;

import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.server.core.JobCompletedReason;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.store.InvalidJobStateChangeException;
import io.mantisrx.server.master.store.MantisWorkerMetadata;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

public class MantisWorkerMetadataWritable
implements MantisWorkerMetadata {
    @JsonIgnore
    private final WorkerId workerId;
    @JsonIgnore
    private final ReentrantLock lock = new ReentrantLock();
    private int workerIndex;
    private int workerNumber;
    private String jobId;
    private int stageNum;
    private int numberOfPorts;
    private int metricsPort;
    private int consolePort;
    private int debugPort = -1;
    private int customPort;
    private List<Integer> ports;
    private volatile MantisJobState state;
    private String slave;
    private String slaveID;
    private Optional<String> cluster = Optional.empty();
    private Optional<ClusterID> resourceCluster = Optional.empty();
    private long acceptedAt = 0L;
    private long launchedAt = 0L;
    private long startingAt = 0L;
    private long startedAt = 0L;
    private long completedAt = 0L;
    private JobCompletedReason reason;
    private int resubmitOf = -1;
    private int totalResubmitCount = 0;
    @JsonIgnore
    private volatile long lastHeartbeatAt = 0L;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisWorkerMetadataWritable(@JsonProperty(value="workerIndex") int workerIndex, @JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="jobId") String jobId, @JsonProperty(value="stageNum") int stageNum, @JsonProperty(value="numberOfPorts") int numberOfPorts) {
        this.workerIndex = workerIndex;
        this.workerNumber = workerNumber;
        this.jobId = jobId;
        this.workerId = new WorkerId(jobId, workerIndex, workerNumber);
        this.stageNum = stageNum;
        this.numberOfPorts = numberOfPorts;
        this.state = MantisJobState.Accepted;
        this.acceptedAt = System.currentTimeMillis();
        this.ports = new ArrayList<Integer>();
    }

    @Override
    public int getWorkerIndex() {
        return this.workerIndex;
    }

    @Override
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @Override
    public WorkerId getWorkerId() {
        return this.workerId;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public int getStageNum() {
        return this.stageNum;
    }

    @Override
    public int getNumberOfPorts() {
        return this.numberOfPorts;
    }

    @Override
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    public void addPorts(List<Integer> ports) {
        this.ports.addAll(ports);
    }

    @Override
    public int getTotalResubmitCount() {
        return this.totalResubmitCount;
    }

    @Override
    public int getMetricsPort() {
        return this.metricsPort;
    }

    public void setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
    }

    @Override
    public int getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    @Override
    public int getConsolePort() {
        return this.consolePort;
    }

    public void setConsolePort(int port) {
        this.consolePort = port;
    }

    @Override
    public int getCustomPort() {
        return this.customPort;
    }

    public void setCustomPort(int port) {
        this.customPort = port;
    }

    @Override
    public int getResubmitOf() {
        return this.resubmitOf;
    }

    @JsonIgnore
    public void setResubmitInfo(int resubmitOf, int totalCount) {
        this.resubmitOf = resubmitOf;
        this.totalResubmitCount = totalCount;
    }

    @JsonIgnore
    public long getLastHeartbeatAt() {
        return this.lastHeartbeatAt;
    }

    @JsonIgnore
    public void setLastHeartbeatAt(long lastHeartbeatAt) {
        this.lastHeartbeatAt = lastHeartbeatAt;
    }

    private void validateStateChange(MantisJobState newState) throws InvalidJobStateChangeException {
        if (!this.state.isValidStateChgTo(newState)) {
            throw new InvalidJobStateChangeException(this.jobId, this.state, newState);
        }
    }

    public void setStateNoValidation(MantisJobState state, long when, JobCompletedReason reason) {
        this.state = state;
        switch (state) {
            case Accepted: {
                this.acceptedAt = when;
                break;
            }
            case Launched: {
                this.launchedAt = when;
                break;
            }
            case StartInitiated: {
                this.startingAt = when;
                break;
            }
            case Started: {
                this.startedAt = when;
                break;
            }
            case Failed: {
                this.completedAt = when;
                this.reason = reason == null ? JobCompletedReason.Lost : reason;
                break;
            }
            case Completed: {
                this.completedAt = when;
                this.reason = reason == null ? JobCompletedReason.Normal : reason;
                break;
            }
            default: {
                assert (false) : "Unexpected job state to set";
                break;
            }
        }
    }

    public void setState(MantisJobState state, long when, JobCompletedReason reason) throws InvalidJobStateChangeException {
        this.validateStateChange(state);
        this.state = state;
        switch (state) {
            case Accepted: {
                this.acceptedAt = when;
                break;
            }
            case Launched: {
                this.launchedAt = when;
                break;
            }
            case StartInitiated: {
                this.startingAt = when;
                break;
            }
            case Started: {
                this.startedAt = when;
                break;
            }
            case Failed: {
                this.completedAt = when;
                this.reason = reason == null ? JobCompletedReason.Lost : reason;
                break;
            }
            case Completed: {
                this.completedAt = when;
                this.reason = reason == null ? JobCompletedReason.Normal : reason;
                break;
            }
            default: {
                assert (false) : "Unexpected job state to set";
                break;
            }
        }
    }

    @Override
    public MantisJobState getState() {
        return this.state;
    }

    @Override
    public String getSlave() {
        return this.slave;
    }

    public void setSlave(String slave) {
        this.slave = slave;
    }

    @Override
    public Optional<String> getCluster() {
        return this.cluster;
    }

    public void setCluster(Optional<String> cluster) {
        this.cluster = cluster;
    }

    @Override
    public Optional<ClusterID> getResourceCluster() {
        return this.resourceCluster;
    }

    public void setResourceCluster(Optional<ClusterID> resourceCluster) {
        this.resourceCluster = resourceCluster;
    }

    @Override
    public String getSlaveID() {
        return this.slaveID;
    }

    public void setSlaveID(String slaveID) {
        this.slaveID = slaveID;
    }

    @Override
    public long getAcceptedAt() {
        return this.acceptedAt;
    }

    public void setAcceptedAt(long when) {
        this.acceptedAt = when;
    }

    @Override
    public long getLaunchedAt() {
        return this.launchedAt;
    }

    public void setLaunchedAt(long when) {
        this.launchedAt = when;
    }

    @Override
    public long getStartingAt() {
        return this.startingAt;
    }

    public void setStartingAt(long when) {
        this.startingAt = when;
    }

    @Override
    public long getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(long when) {
        this.startedAt = when;
    }

    @Override
    public long getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(long when) {
        this.completedAt = when;
    }

    @Override
    public JobCompletedReason getReason() {
        return this.reason;
    }

    public void setReason(JobCompletedReason reason) {
        this.reason = reason;
    }

    public String toString() {
        return "Worker " + this.workerNumber + " state=" + this.state + ", acceptedAt=" + this.acceptedAt + (this.launchedAt == 0L ? "" : ", launchedAt=" + this.launchedAt) + (this.startingAt == 0L ? "" : ", startingAt=" + this.startingAt) + (this.startedAt == 0L ? "" : ", startedAt=" + this.startedAt) + (this.completedAt == 0L ? "" : ", completedAt=" + this.completedAt) + ", #ports=" + this.ports.size() + ", ports=" + this.ports;
    }
}

