/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.store;

import com.netflix.fenzo.triggers.CronTrigger;
import com.netflix.fenzo.triggers.TriggerOperator;
import com.netflix.fenzo.triggers.exceptions.SchedulerException;
import io.mantisrx.common.Label;
import io.mantisrx.runtime.JobOwner;
import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.runtime.NamedJobDefinition;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.MantisJobOperations;
import io.mantisrx.server.master.store.InvalidNamedJobException;
import io.mantisrx.server.master.store.NamedJobDeleteException;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action1;

public class NamedJob {
    private static final Logger logger = LoggerFactory.getLogger(NamedJob.class);
    private static final int MaxValueForSlaMin = 5;
    private static final int MaxValueForSlaMax = 100;
    private final String name;
    private final List<Jar> jars = new ArrayList<Jar>();
    private JobOwner owner;
    private volatile SLA sla;
    private List<Parameter> parameters;
    private boolean isReadyForJobMaster = false;
    private WorkerMigrationConfig migrationConfig;
    private volatile long lastJobCount = 0L;
    private volatile boolean disabled = false;
    private volatile boolean cronActive = false;
    private volatile boolean isActive = true;
    private MantisJobOperations jobOps;
    private List<Label> labels;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public NamedJob(@JsonProperty(value="jobOps") MantisJobOperations jobOps, @JsonProperty(value="name") String name, @JsonProperty(value="jars") List<Jar> jars, @JsonProperty(value="sla") SLA sla, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="owner") JobOwner owner, @JsonProperty(value="lastJobCount") long lastJobCount, @JsonProperty(value="disabled") boolean disabled, @JsonProperty(value="isReadyForJobMaster") boolean isReadyForJobMaster, @JsonProperty(value="migrationConfig") WorkerMigrationConfig migrationConfig, @JsonProperty(value="labels") List<Label> labels) {
        this.jobOps = jobOps;
        this.name = name;
        if (sla == null) {
            sla = new SLA(0, 0, null, null);
        }
        this.disabled = disabled;
        this.isReadyForJobMaster = isReadyForJobMaster;
        this.migrationConfig = Optional.ofNullable(migrationConfig).orElse(WorkerMigrationConfig.DEFAULT);
        this.sla = sla;
        try {
            this.sla.validate();
        }
        catch (InvalidNamedJobException e) {
            logger.warn(name + ": disabling due to unexpected error validating sla: " + e.getMessage());
            this.disabled = true;
        }
        this.labels = labels != null ? labels : new LinkedList<Label>();
        this.parameters = parameters;
        this.owner = owner;
        this.lastJobCount = lastJobCount;
        if (jars != null) {
            this.jars.addAll(jars);
        }
    }

    public static String getJobId(String name, long number) {
        return name + "-" + number;
    }

    static String getJobName(String jobId) {
        return jobId.substring(0, jobId.lastIndexOf(45));
    }

    private static long getJobIdNumber(String jobId) {
        return Long.parseLong(jobId.substring(jobId.lastIndexOf(45) + 1));
    }

    public String toString() {
        return "NamedJob [name=" + this.name + ", jars=" + this.jars + ", owner=" + this.owner + ", sla=" + this.sla + ", parameters=" + this.parameters + ", isReadyForJobMaster=" + this.isReadyForJobMaster + ", migrationConfig=" + this.migrationConfig + ", lastJobCount=" + this.lastJobCount + ", disabled=" + this.disabled + ", isActive=" + this.isActive + ", labels=" + this.labels + "]";
    }

    void setJobOps(MantisJobOperations jobOps) {
        this.jobOps = jobOps;
    }

    public String getName() {
        return this.name;
    }

    public List<Jar> getJars() {
        return Collections.unmodifiableList(this.jars);
    }

    public SLA getSla() {
        return this.sla;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public JobOwner getOwner() {
        return this.owner;
    }

    void setOwner(JobOwner owner) {
        this.owner = owner;
    }

    public long getLastJobCount() {
        return this.lastJobCount;
    }

    @JsonIgnore
    public long getNextJobNumber() {
        return ++this.lastJobCount;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean getIsReadyForJobMaster() {
        return this.isReadyForJobMaster;
    }

    public void setIsReadyForJobMaster(boolean b) {
        this.isReadyForJobMaster = b;
    }

    public WorkerMigrationConfig getMigrationConfig() {
        return this.migrationConfig;
    }

    public void setMigrationConfig(WorkerMigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
    }

    @JsonIgnore
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonIgnore
    public void setInactive() throws NamedJobDeleteException {
        this.isActive = false;
    }

    public boolean getCronActive() {
        return this.cronActive;
    }

    @JsonIgnore
    Jar getJar(String version) {
        if (version == null || version.isEmpty()) {
            return this.jars.get(this.jars.size() - 1);
        }
        for (Jar j : this.jars) {
            if (!version.equals(j.version)) continue;
            return j;
        }
        return null;
    }

    public static class CronTriggerAction
    implements Action1<NamedJob> {
        public void call(NamedJob job) {
            logger.info("Cron fired for " + job.getName());
        }
    }

    public static class SLA {
        @JsonIgnore
        private static final TriggerOperator triggerOperator = new TriggerOperator(1);
        private final int min;
        private final int max;
        private final String cronSpec;
        private final NamedJobDefinition.CronPolicy cronPolicy;
        @JsonIgnore
        private final boolean hasCronSpec;
        @JsonIgnore
        private final NamedJobDefinition.CronPolicy defaultPolicy = NamedJobDefinition.CronPolicy.KEEP_EXISTING;
        @JsonIgnore
        private CronTrigger<NamedJob> scheduledTrigger;
        @JsonIgnore
        private String triggerGroup = null;
        @JsonIgnore
        private String triggerId = null;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public SLA(@JsonProperty(value="min") int min, @JsonProperty(value="max") int max, @JsonProperty(value="cronSpec") String cronSpec, @JsonProperty(value="cronPolicy") NamedJobDefinition.CronPolicy cronPolicy) {
            if (cronSpec != null && !cronSpec.isEmpty()) {
                this.cronSpec = cronSpec;
                this.hasCronSpec = true;
                this.max = 1;
                this.min = 0;
                this.cronPolicy = cronPolicy == null ? this.defaultPolicy : cronPolicy;
            } else {
                this.hasCronSpec = false;
                this.min = min;
                this.max = max;
                this.cronSpec = null;
                this.cronPolicy = null;
            }
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public String getCronSpec() {
            return this.cronSpec;
        }

        public NamedJobDefinition.CronPolicy getCronPolicy() {
            return this.cronPolicy;
        }

        private void validate() throws InvalidNamedJobException {
            if (this.max < this.min) {
                throw new InvalidNamedJobException("Cannot have max=" + this.max + " < min=" + this.min);
            }
            if (this.min > 5) {
                throw new InvalidNamedJobException("Specified min sla value " + this.min + " cannot be >" + 5);
            }
            if (this.max > 100) {
                throw new InvalidNamedJobException("Max sla value " + this.max + " cannot be >" + 100);
            }
        }

        private void initCron(NamedJob job) throws SchedulerException {
        }

        private void destroyCron() {
        }

        static {
            try {
                triggerOperator.initialize();
            }
            catch (SchedulerException e) {
                logger.error("Unexpected: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static class Jar {
        private final URL url;
        private final String version;
        private final long uploadedAt;
        private final SchedulingInfo schedulingInfo;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public Jar(@JsonProperty(value="url") URL url, @JsonProperty(value="uploadedAt") long uploadedAt, @JsonProperty(value="version") String version, @JsonProperty(value="schedulingInfo") SchedulingInfo schedulingInfo) {
            this.url = url;
            this.uploadedAt = uploadedAt;
            this.version = version == null || version.isEmpty() ? "" + System.currentTimeMillis() : version;
            this.schedulingInfo = schedulingInfo;
        }

        public URL getUrl() {
            return this.url;
        }

        public long getUploadedAt() {
            return this.uploadedAt;
        }

        public String getVersion() {
            return this.version;
        }

        public SchedulingInfo getSchedulingInfo() {
            return this.schedulingInfo;
        }
    }

    public static class CompletedJob {
        private final String name;
        private final String jobId;
        private final String version;
        private final MantisJobState state;
        private final long submittedAt;
        private final long terminatedAt;
        private final String user;
        private final List<Label> labels;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public CompletedJob(@JsonProperty(value="name") String name, @JsonProperty(value="jobId") String jobId, @JsonProperty(value="version") String version, @JsonProperty(value="state") MantisJobState state, @JsonProperty(value="submittedAt") long submittedAt, @JsonProperty(value="terminatedAt") long terminatedAt, @JsonProperty(value="user") String user, @JsonProperty(value="labels") List<Label> labels) {
            this.name = name;
            this.jobId = jobId;
            this.version = version;
            this.state = state;
            this.submittedAt = submittedAt;
            this.terminatedAt = terminatedAt;
            this.user = user;
            this.labels = labels != null ? labels : new ArrayList<Label>();
        }

        public String getName() {
            return this.name;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getVersion() {
            return this.version;
        }

        public MantisJobState getState() {
            return this.state;
        }

        public long getSubmittedAt() {
            return this.submittedAt;
        }

        public long getTerminatedAt() {
            return this.terminatedAt;
        }

        public String getUser() {
            return this.user;
        }

        public List<Label> getLabels() {
            return this.labels;
        }

        public String toString() {
            return "CompletedJob{name='" + this.name + '\'' + ", jobId='" + this.jobId + '\'' + ", version='" + this.version + '\'' + ", state=" + this.state + ", submittedAt=" + this.submittedAt + ", terminatedAt=" + this.terminatedAt + ", user='" + this.user + '\'' + ", labels=" + this.labels + '}';
        }
    }
}

