/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master;

import akka.actor.AbstractActor;
import akka.actor.DeadLetter;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.JsonSerializer;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadLetterActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(DeadLetterActor.class);
    private final Counter numDeadLetterMsgs;
    private final JsonSerializer serializer;

    public DeadLetterActor() {
        Metrics m = new Metrics.Builder().id("DeadLetterActor", new Tag[0]).addCounter("numDeadLetterMsgs").build();
        Metrics metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.numDeadLetterMsgs = metrics.getCounter("numDeadLetterMsgs");
        this.serializer = new JsonSerializer();
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(DeadLetter.class, msg -> {
            this.numDeadLetterMsgs.increment();
            String m = this.toString(msg.message());
            log.error("Dead Letter from {} to {} msg type: {} payload: {}", new Object[]{msg.sender(), msg.recipient(), msg.message().getClass().getSimpleName(), m.substring(0, Math.min(250, m.length() - 1))});
        }).build();
    }

    private String toString(Object o) {
        try {
            return this.serializer.toJson(o);
        }
        catch (Exception e) {
            log.error("Failed to serialize {}", o, (Object)e);
            return o.toString();
        }
    }
}

