/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.akka;

import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;

public final class ActorSystemMetrics {
    private final Counter actorKilledCount;
    private final Counter actorInitExceptionCount;
    private final Counter actorDeathPactExcCount;
    private final Counter actorResumeCount;
    private static final ActorSystemMetrics INSTANCE = new ActorSystemMetrics();

    private ActorSystemMetrics() {
        Metrics m = new Metrics.Builder().id("ActorSystemMetrics", new Tag[0]).addCounter("actorKilledCount").addCounter("actorInitExceptionCount").addCounter("actorDeathPactExcCount").addCounter("actorResumeCount").build();
        Metrics metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.actorKilledCount = metrics.getCounter("actorKilledCount");
        this.actorInitExceptionCount = metrics.getCounter("actorInitExceptionCount");
        this.actorDeathPactExcCount = metrics.getCounter("actorDeathPactExcCount");
        this.actorResumeCount = metrics.getCounter("actorResumeCount");
    }

    public static ActorSystemMetrics getInstance() {
        return INSTANCE;
    }

    public void incrementActorKilledCount() {
        this.actorKilledCount.increment();
    }

    public void incrementActorInitExceptionCount() {
        this.actorInitExceptionCount.increment();
    }

    public void incrementActorDeathPactExcCount() {
        this.actorDeathPactExcCount.increment();
    }

    public void incrementActorResumeCount() {
        this.actorResumeCount.increment();
    }
}

