/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.akka;

import akka.actor.ActorInitializationException;
import akka.actor.ActorKilledException;
import akka.actor.DeathPactException;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.actor.SupervisorStrategyConfigurator;
import akka.japi.pf.DeciderBuilder;
import io.mantisrx.master.akka.ActorSystemMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisActorSupervisorStrategy
implements SupervisorStrategyConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisActorSupervisorStrategy.class);
    private static final MantisActorSupervisorStrategy INSTANCE = new MantisActorSupervisorStrategy();

    public static MantisActorSupervisorStrategy getInstance() {
        return INSTANCE;
    }

    public SupervisorStrategy create() {
        return new OneForOneStrategy(DeciderBuilder.match(ActorInitializationException.class, e -> {
            ActorSystemMetrics.getInstance().incrementActorInitExceptionCount();
            LOGGER.error("Stopping the actor because of exception", (Throwable)e);
            return SupervisorStrategy.stop();
        }).match(ActorKilledException.class, e -> {
            ActorSystemMetrics.getInstance().incrementActorKilledCount();
            LOGGER.error("Stopping the actor because of exception", (Throwable)e);
            return SupervisorStrategy.stop();
        }).match(DeathPactException.class, e -> {
            ActorSystemMetrics.getInstance().incrementActorDeathPactExcCount();
            LOGGER.error("Stopping the actor because of exception", (Throwable)e);
            return SupervisorStrategy.stop();
        }).match(Exception.class, e -> {
            LOGGER.error("resuming actor on exception {}", (Object)e.getMessage(), e);
            ActorSystemMetrics.getInstance().incrementActorResumeCount();
            return SupervisorStrategy.resume();
        }).build());
    }
}

