/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route;

import akka.http.javadsl.marshalling.Marshaller;
import akka.http.javadsl.model.HttpEntity;
import akka.http.javadsl.model.MediaType;
import akka.http.javadsl.model.MediaTypes;
import akka.http.javadsl.model.RequestEntity;
import akka.http.javadsl.unmarshalling.Unmarshaller;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.Module;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.FilterProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson {
    private static final Logger logger = LoggerFactory.getLogger(Jackson.class);
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new Jdk8Module());
    public static final SimpleFilterProvider DEFAULT_FILTER_PROVIDER = new SimpleFilterProvider();

    public static <T> Marshaller<T, RequestEntity> marshaller() {
        return Jackson.marshaller(defaultObjectMapper, null);
    }

    public static <T> Marshaller<T, RequestEntity> marshaller(FilterProvider filterProvider) {
        return Jackson.marshaller(defaultObjectMapper, filterProvider);
    }

    public static <T> Marshaller<T, RequestEntity> marshaller(ObjectMapper mapper) {
        return Marshaller.wrapEntity(u -> {
            try {
                return Jackson.toJSON(mapper, null, u);
            }
            catch (JsonProcessingException e) {
                String objStr = u.toString();
                String errMsg = "cannot marshal to Json " + objStr.substring(0, Math.min(objStr.length(), 100));
                logger.warn(errMsg, (Throwable)e);
                throw new IllegalArgumentException(errMsg);
            }
        }, (Marshaller)Marshaller.stringToEntity(), (MediaType)MediaTypes.APPLICATION_JSON);
    }

    public static <T> Marshaller<T, RequestEntity> marshaller(ObjectMapper mapper, FilterProvider filterProvider) {
        return Marshaller.wrapEntity(u -> {
            try {
                return Jackson.toJSON(mapper, filterProvider, u);
            }
            catch (JsonProcessingException e) {
                String objStr = u.toString();
                String errMsg = "cannot marshal to Json " + objStr.substring(0, Math.min(objStr.length(), 100));
                logger.warn(errMsg, (Throwable)e);
                throw new IllegalArgumentException(errMsg);
            }
        }, (Marshaller)Marshaller.stringToEntity(), (MediaType)MediaTypes.APPLICATION_JSON);
    }

    public static <T> Unmarshaller<HttpEntity, T> unmarshaller(Class<T> expectedType) {
        return Jackson.unmarshaller(defaultObjectMapper, expectedType);
    }

    public static <T> Unmarshaller<HttpEntity, T> unmarshaller(TypeReference<T> expectedType) {
        return Jackson.unmarshaller(defaultObjectMapper, expectedType);
    }

    public static <T> Unmarshaller<HttpEntity, T> optionalEntityUnmarshaller(Class<T> expectedType) {
        return Unmarshaller.forMediaType((MediaType)MediaTypes.APPLICATION_JSON, (Unmarshaller)Unmarshaller.entityToString()).thenApply(s -> {
            if (s.isEmpty()) {
                return null;
            }
            try {
                return Jackson.fromJSON(defaultObjectMapper, s, expectedType);
            }
            catch (IOException e) {
                logger.warn("cannot unmarshal json", (Throwable)e);
                throw new IllegalArgumentException("cannot unmarshall Json as " + expectedType.getSimpleName());
            }
        });
    }

    public static <T> Unmarshaller<HttpEntity, T> unmarshaller(ObjectMapper mapper, Class<T> expectedType) {
        return Unmarshaller.forMediaType((MediaType)MediaTypes.APPLICATION_JSON, (Unmarshaller)Unmarshaller.entityToString()).thenApply(s -> {
            try {
                return Jackson.fromJSON(mapper, s, expectedType);
            }
            catch (IOException e) {
                logger.warn("cannot unmarshal json", (Throwable)e);
                throw new IllegalArgumentException("cannot unmarshall Json as " + expectedType.getSimpleName());
            }
        });
    }

    public static <T> Unmarshaller<HttpEntity, T> unmarshaller(ObjectMapper mapper, TypeReference<T> expectedType) {
        return Unmarshaller.forMediaType((MediaType)MediaTypes.APPLICATION_JSON, (Unmarshaller)Unmarshaller.entityToString()).thenApply(s -> {
            try {
                return Jackson.fromJSON(mapper, s, expectedType);
            }
            catch (IOException e) {
                logger.warn("cannot unmarshal json", (Throwable)e);
                throw new IllegalArgumentException("cannot unmarshall Json as " + expectedType.getType().getTypeName());
            }
        });
    }

    public static String toJSON(ObjectMapper mapper, FilterProvider filters, Object object) throws JsonProcessingException {
        if (filters == null) {
            filters = DEFAULT_FILTER_PROVIDER;
        }
        return mapper.writer(filters).writeValueAsString(object);
    }

    public static <T> T fromJSON(ObjectMapper mapper, String json, TypeReference<T> expectedType) throws IOException {
        return (T)mapper.readerFor(expectedType).readValue(json);
    }

    public static <T> T fromJSON(ObjectMapper mapper, String json, Class<T> expectedType) throws IOException {
        return (T)mapper.readerFor(expectedType).readValue(json);
    }

    public static <T> T fromJSON(String json, Class<T> expectedType) throws IOException {
        return (T)defaultObjectMapper.readerFor(expectedType).readValue(json);
    }

    public static <T> T fromJSON(String json, TypeReference<T> expectedType) throws IOException {
        return (T)defaultObjectMapper.readerFor(expectedType).readValue(json);
    }

    public static String toJson(Object object) throws IOException {
        return defaultObjectMapper.writeValueAsString(object);
    }

    static {
        DEFAULT_FILTER_PROVIDER.setFailOnUnknownId(false);
    }
}

