/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route;

import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;

public class MasterApiMetrics {
    private final Counter resp2xx;
    private final Counter resp4xx;
    private final Counter resp5xx;
    private final Counter incomingRequestCount;
    private final Counter throttledRequestCount;
    private final Counter askTimeOutCount;
    private static final MasterApiMetrics INSTANCE = new MasterApiMetrics();

    private MasterApiMetrics() {
        Metrics m = new Metrics.Builder().id("MasterApiMetrics", new Tag[0]).addCounter("incomingRequestCount").addCounter("throttledRequestCount").addCounter("resp2xx").addCounter("resp4xx").addCounter("resp5xx").addCounter("askTimeOutCount").build();
        Metrics metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.askTimeOutCount = metrics.getCounter("askTimeOutCount");
        this.resp2xx = metrics.getCounter("resp2xx");
        this.resp4xx = metrics.getCounter("resp4xx");
        this.resp5xx = metrics.getCounter("resp5xx");
        this.incomingRequestCount = metrics.getCounter("incomingRequestCount");
        this.throttledRequestCount = metrics.getCounter("throttledRequestCount");
    }

    public static final MasterApiMetrics getInstance() {
        return INSTANCE;
    }

    public void incrementResp2xx() {
        this.resp2xx.increment();
    }

    public void incrementResp4xx() {
        this.resp4xx.increment();
    }

    public void incrementResp5xx() {
        this.resp5xx.increment();
    }

    public void incrementAskTimeOutCount() {
        this.askTimeOutCount.increment();
    }

    public void incrementIncomingRequestCount() {
        this.incomingRequestCount.increment();
    }

    public void incrementThrottledRequestCount() {
        this.throttledRequestCount.increment();
    }
}

