/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.handlers;

import io.mantisrx.master.api.akka.route.handlers.JobArtifactRouteHandler;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobArtifactProto;
import io.mantisrx.server.core.domain.JobArtifact;
import io.mantisrx.server.master.persistence.IMantisPersistenceProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobArtifactRouteHandlerImpl
implements JobArtifactRouteHandler {
    private static final Logger log = LoggerFactory.getLogger(JobArtifactRouteHandlerImpl.class);
    private final IMantisPersistenceProvider mantisStorageProvider;

    public JobArtifactRouteHandlerImpl(IMantisPersistenceProvider mantisStorageProvider) {
        this.mantisStorageProvider = mantisStorageProvider;
    }

    @Override
    public CompletionStage<JobArtifactProto.SearchJobArtifactsResponse> search(JobArtifactProto.SearchJobArtifactsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List<JobArtifact> jobArtifactList = this.mantisStorageProvider.listJobArtifacts(request.getName(), request.getVersion());
                return new JobArtifactProto.SearchJobArtifactsResponse(request.requestId, BaseResponse.ResponseCode.SUCCESS, "", jobArtifactList);
            }
            catch (IOException e) {
                log.warn("Error while fetching job artifacts. Traceback: {}", (Object)e.getMessage(), (Object)e);
                return new JobArtifactProto.SearchJobArtifactsResponse(request.requestId, BaseResponse.ResponseCode.SERVER_ERROR, e.getMessage(), Collections.emptyList());
            }
        });
    }

    @Override
    public CompletionStage<JobArtifactProto.ListJobArtifactsByNameResponse> listArtifactsByName(JobArtifactProto.ListJobArtifactsByNameRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List<String> artifactNames = this.mantisStorageProvider.listJobArtifactsByName(request.getPrefix(), request.getContains());
                return new JobArtifactProto.ListJobArtifactsByNameResponse(request.requestId, BaseResponse.ResponseCode.SUCCESS, "", artifactNames);
            }
            catch (IOException e) {
                log.warn("Error while searching job artifact names. Traceback: {}", (Object)e.getMessage(), (Object)e);
                return new JobArtifactProto.ListJobArtifactsByNameResponse(request.requestId, BaseResponse.ResponseCode.SERVER_ERROR, e.getMessage(), Collections.emptyList());
            }
        });
    }

    @Override
    public CompletionStage<JobArtifactProto.UpsertJobArtifactResponse> upsert(JobArtifactProto.UpsertJobArtifactRequest request) {
        JobArtifact jobArtifact = request.getJobArtifact();
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.mantisStorageProvider.addNewJobArtifact(jobArtifact);
                return new JobArtifactProto.UpsertJobArtifactResponse(request.requestId, BaseResponse.ResponseCode.SUCCESS, "", jobArtifact.getArtifactID());
            }
            catch (IOException e) {
                log.warn("Error while storing new job artifact. Traceback: {}", (Object)e.getMessage(), (Object)e);
                return new JobArtifactProto.UpsertJobArtifactResponse(request.requestId, BaseResponse.ResponseCode.SERVER_ERROR, e.getMessage(), jobArtifact.getArtifactID());
            }
        });
    }
}

