/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.handlers;

import akka.actor.ActorRef;
import akka.pattern.PatternsCS;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.master.JobClustersManagerActor;
import io.mantisrx.master.api.akka.route.handlers.JobClusterRouteHandler;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.server.master.config.ConfigurationProvider;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClusterRouteHandlerAkkaImpl
implements JobClusterRouteHandler {
    private static final Logger logger = LoggerFactory.getLogger(JobClusterRouteHandlerAkkaImpl.class);
    private final ActorRef jobClustersManagerActor;
    private final Counter allJobClustersGET;
    private final Duration timeout;

    public JobClusterRouteHandlerAkkaImpl(ActorRef jobClusterManagerActor) {
        this.jobClustersManagerActor = jobClusterManagerActor;
        long timeoutMs = Optional.ofNullable(ConfigurationProvider.getConfig().getMasterApiAskTimeoutMs()).orElse(1000L);
        this.timeout = Duration.ofMillis(timeoutMs);
        Metrics m = new Metrics.Builder().id("JobClusterRouteHandler", new Tag[0]).addCounter("allJobClustersGET").build();
        Metrics metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.allJobClustersGET = metrics.getCounter("allJobClustersGET");
    }

    @Override
    public CompletionStage<JobClusterManagerProto.CreateJobClusterResponse> create(JobClusterManagerProto.CreateJobClusterRequest request) {
        CompletionStage<JobClusterManagerProto.CreateJobClusterResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.CreateJobClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.UpdateJobClusterResponse> update(JobClusterManagerProto.UpdateJobClusterRequest request) {
        CompletionStage<JobClusterManagerProto.UpdateJobClusterResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.UpdateJobClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.DeleteJobClusterResponse> delete(JobClusterManagerProto.DeleteJobClusterRequest request) {
        CompletionStage<JobClusterManagerProto.DeleteJobClusterResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.DeleteJobClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.DisableJobClusterResponse> disable(JobClusterManagerProto.DisableJobClusterRequest request) {
        CompletionStage<JobClusterManagerProto.DisableJobClusterResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.DisableJobClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.EnableJobClusterResponse> enable(JobClusterManagerProto.EnableJobClusterRequest request) {
        CompletionStage<JobClusterManagerProto.EnableJobClusterResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.EnableJobClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.UpdateJobClusterArtifactResponse> updateArtifact(JobClusterManagerProto.UpdateJobClusterArtifactRequest request) {
        CompletionStage<JobClusterManagerProto.UpdateJobClusterArtifactResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.UpdateJobClusterArtifactResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.UpdateSchedulingInfoResponse> updateSchedulingInfo(String clusterName, JobClusterManagerProto.UpdateSchedulingInfoRequest request) {
        CompletionStage<JobClusterManagerProto.UpdateSchedulingInfoResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)new JobClustersManagerActor.UpdateSchedulingInfo(request.requestId, clusterName, request.getSchedulingInfo(), request.getVersion()), (Duration)this.timeout).thenApply(JobClusterManagerProto.UpdateSchedulingInfoResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.UpdateJobClusterSLAResponse> updateSLA(JobClusterManagerProto.UpdateJobClusterSLARequest request) {
        CompletionStage<JobClusterManagerProto.UpdateJobClusterSLAResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.UpdateJobClusterSLAResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse> updateWorkerMigrateStrategy(JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyRequest request) {
        CompletionStage<JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.UpdateJobClusterLabelsResponse> updateLabels(JobClusterManagerProto.UpdateJobClusterLabelsRequest request) {
        CompletionStage<JobClusterManagerProto.UpdateJobClusterLabelsResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.UpdateJobClusterLabelsResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.SubmitJobResponse> submit(JobClusterManagerProto.SubmitJobRequest request) {
        CompletionStage<JobClusterManagerProto.SubmitJobResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.SubmitJobResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.GetJobClusterResponse> getJobClusterDetails(JobClusterManagerProto.GetJobClusterRequest request) {
        CompletionStage<JobClusterManagerProto.GetJobClusterResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.GetJobClusterResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.ListJobClustersResponse> getAllJobClusters(JobClusterManagerProto.ListJobClustersRequest request) {
        this.allJobClustersGET.increment();
        CompletionStage<JobClusterManagerProto.ListJobClustersResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.ListJobClustersResponse.class::cast);
        return response;
    }

    @Override
    public CompletionStage<JobClusterManagerProto.GetLatestJobDiscoveryInfoResponse> getLatestJobDiscoveryInfo(JobClusterManagerProto.GetLatestJobDiscoveryInfoRequest request) {
        CompletionStage<JobClusterManagerProto.GetLatestJobDiscoveryInfoResponse> response = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.GetLatestJobDiscoveryInfoResponse.class::cast);
        return response;
    }
}

