/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.handlers;

import akka.actor.ActorRef;
import akka.pattern.PatternsCS;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.master.api.akka.route.handlers.JobRouteHandler;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRouteHandlerAkkaImpl
implements JobRouteHandler {
    private static final Logger logger = LoggerFactory.getLogger(JobRouteHandlerAkkaImpl.class);
    private final ActorRef jobClustersManagerActor;
    private final Counter listAllJobs;
    private final Counter listJobIds;
    private final Counter listArchivedWorkers;
    private final Duration timeout;

    public JobRouteHandlerAkkaImpl(ActorRef jobClusterManagerActor) {
        this.jobClustersManagerActor = jobClusterManagerActor;
        long timeoutMs = Optional.ofNullable(ConfigurationProvider.getConfig().getMasterApiAskTimeoutMs()).orElse(1000L);
        this.timeout = Duration.ofMillis(timeoutMs);
        Metrics m = new Metrics.Builder().id("JobRouteHandler", new Tag[0]).addCounter("listAllJobs").addCounter("listJobIds").addCounter("listArchivedWorkers").build();
        Metrics metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.listAllJobs = metrics.getCounter("listAllJobs");
        this.listJobIds = metrics.getCounter("listJobIds");
        this.listArchivedWorkers = metrics.getCounter("listArchivedWorkers");
    }

    @Override
    public CompletionStage<JobClusterManagerProto.KillJobResponse> kill(JobClusterManagerProto.KillJobRequest request) {
        return PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.KillJobResponse.class::cast);
    }

    @Override
    public CompletionStage<JobClusterManagerProto.ResubmitWorkerResponse> resubmitWorker(JobClusterManagerProto.ResubmitWorkerRequest request) {
        return PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.ResubmitWorkerResponse.class::cast);
    }

    @Override
    public CompletionStage<JobClusterManagerProto.ScaleStageResponse> scaleStage(JobClusterManagerProto.ScaleStageRequest request) {
        return PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.ScaleStageResponse.class::cast);
    }

    @Override
    public CompletionStage<BaseResponse> workerStatus(WorkerEvent request) {
        this.jobClustersManagerActor.tell((Object)request, ActorRef.noSender());
        return CompletableFuture.completedFuture(new BaseResponse(0L, BaseResponse.ResponseCode.SUCCESS, "forwarded worker status"));
    }

    @Override
    public CompletionStage<JobClusterManagerProto.GetJobDetailsResponse> getJobDetails(JobClusterManagerProto.GetJobDetailsRequest request) {
        return PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.GetJobDetailsResponse.class::cast);
    }

    @Override
    public CompletionStage<JobClusterManagerProto.ListJobsResponse> listJobs(JobClusterManagerProto.ListJobsRequest request) {
        logger.debug("request {}", (Object)request);
        this.listAllJobs.increment();
        return PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.ListJobsResponse.class::cast);
    }

    @Override
    public CompletionStage<JobClusterManagerProto.ListJobIdsResponse> listJobIds(JobClusterManagerProto.ListJobIdsRequest request) {
        logger.debug("request {}", (Object)request);
        this.listJobIds.increment();
        return PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.ListJobIdsResponse.class::cast);
    }

    @Override
    public CompletionStage<JobClusterManagerProto.ListArchivedWorkersResponse> listArchivedWorkers(JobClusterManagerProto.ListArchivedWorkersRequest request) {
        this.listArchivedWorkers.increment();
        return PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)request, (Duration)this.timeout).thenApply(JobClusterManagerProto.ListArchivedWorkersResponse.class::cast);
    }
}

