/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.pagination;

import akka.http.javadsl.model.Uri;
import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.master.api.akka.route.v1.ParamName;
import io.mantisrx.shaded.com.google.common.base.Strings;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import io.mantisrx.shaded.com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListObject<T> {
    private static final Logger logger = LoggerFactory.getLogger(ListObject.class);
    public List<T> list;
    public String prev;
    public String next;
    public int total;

    ListObject(List<T> objects, int limit, int offset, Comparator<T> sorter, Uri uri) {
        if (objects == null) {
            this.list = Lists.newArrayList();
            this.total = 0;
        } else {
            this.total = objects.size();
            if (sorter != null) {
                objects.sort(sorter);
            }
            int toIndex = offset + limit > objects.size() - 1 ? objects.size() : offset + limit;
            this.list = offset > toIndex ? Lists.newArrayList() : objects.subList(offset, toIndex);
            if (limit < Integer.MAX_VALUE && uri != null) {
                if (offset == 0) {
                    this.prev = null;
                } else {
                    int prevOffset = offset - limit >= 0 ? offset - limit : 0;
                    this.prev = this.generateNewUri(uri, prevOffset);
                }
                if (offset + limit >= objects.size()) {
                    this.next = null;
                } else {
                    int nextOffset = offset + limit;
                    this.next = this.generateNewUri(uri, nextOffset);
                }
            }
        }
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public String getPrev() {
        return this.prev;
    }

    public void setPrev(String prev) {
        this.prev = prev;
    }

    private String generateNewUri(Uri originalUri, int offset) {
        LinkedHashMap queryMap = Maps.newLinkedHashMap((Map)originalUri.query().toMap());
        queryMap.put(ParamName.PAGINATION_OFFSET, String.valueOf(offset));
        StringBuilder stringBuilder = new StringBuilder(originalUri.path());
        String dividerChar = "?";
        for (Map.Entry entry : queryMap.entrySet()) {
            stringBuilder.append(dividerChar);
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append((String)entry.getValue());
            dividerChar = "&";
        }
        return stringBuilder.toString();
    }

    public static class Builder<T> {
        private List<T> objects = null;
        private Class<T> targetType;
        private int limit = Integer.MAX_VALUE;
        private int offset = 0;
        private String sortField = null;
        private boolean sortAscending = true;
        private Uri uri = null;

        public Builder<T> withObjects(List<T> objects, Class<T> targetType) {
            this.objects = objects;
            this.targetType = targetType;
            return this;
        }

        public Builder<T> withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder<T> withOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder<T> withSortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public Builder<T> withSortAscending(boolean isAscending) {
            this.sortAscending = isAscending;
            return this;
        }

        public Builder<T> withUri(Uri uri) {
            this.uri = uri;
            return this;
        }

        public ListObject<T> build() {
            Preconditions.checkNotNull(this.objects, (String)"Objects cannot be null");
            Preconditions.checkNotNull(this.targetType, (String)"Target type cannot be null");
            Preconditions.checkState((this.limit > 0 ? 1 : 0) != 0, (String)"limit needs to be greater than 0");
            Preconditions.checkState((this.offset >= 0 ? 1 : 0) != 0, (String)"offset has to be equal or greater than 0.");
            return new ListObject<T>(this.objects, this.limit, this.offset, this.getSorter(), this.uri);
        }

        private Comparator<T> getSorter() {
            if (Strings.isNullOrEmpty((String)this.sortField)) {
                return null;
            }
            try {
                Field field = this.targetType.getDeclaredField(this.sortField);
                if (field == null) {
                    throw new RuntimeException(String.format("Specified sort field is invalid. [%s]", this.sortField));
                }
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException(String.format("Specified sort field is invalid. [%s]", this.sortField), ex);
            }
            return (t1, t2) -> {
                int result;
                if (t1 == null && t2 == null) {
                    result = 0;
                } else if (t1 == null) {
                    result = -1;
                } else if (t2 == null) {
                    result = 1;
                } else {
                    Comparable f1 = Builder.getComparableFromFieldName(this.sortField, t1, this.targetType);
                    Comparable f2 = Builder.getComparableFromFieldName(this.sortField, t2, this.targetType);
                    result = f1 != null ? f1.compareTo(f2) : (f2 != null ? f2.compareTo(f1) : 0);
                }
                return this.sortAscending ? result : -result;
            };
        }

        private static <T> Comparable getComparableFromFieldName(String fieldName, T val, Class<T> targetType) {
            try {
                Field field = targetType.getDeclaredField(fieldName);
                Object fieldValue = null;
                try {
                    fieldValue = field.get(val);
                }
                catch (IllegalAccessException ex) {
                    logger.warn("Unable to access field {}, trying Bean getter method instead...", (Object)fieldName);
                }
                if (fieldValue == null) {
                    BeanInfo info = Introspector.getBeanInfo(targetType);
                    MethodDescriptor[] methods = info.getMethodDescriptors();
                    if (methods == null) {
                        throw new RuntimeException("Cannot access sort field. " + fieldName);
                    }
                    for (MethodDescriptor methodDescriptor : methods) {
                        if (!methodDescriptor.getName().equalsIgnoreCase("get" + fieldName)) continue;
                        fieldValue = methodDescriptor.getMethod().invoke(val, new Object[0]);
                        break;
                    }
                }
                if (fieldValue == null) {
                    throw new RuntimeException("Cannot access sort field. " + fieldName);
                }
                if (!(fieldValue instanceof Comparable)) {
                    throw new RuntimeException(String.format("Specified sort field is invalid. [%s]", fieldName));
                }
                return (Comparable)fieldValue;
            }
            catch (IntrospectionException | IllegalAccessException | NoSuchFieldException | InvocationTargetException ex) {
                throw new RuntimeException(String.format("Specified sort field is invalid. [%s]", fieldName), ex);
            }
        }
    }
}

