/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.utils;

import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParamUtils {
    private static final Logger logger = LoggerFactory.getLogger(QueryParamUtils.class);

    public static Optional<String> paramValue(Map<String, List<String>> params, String key) {
        List<String> values = params.get(key);
        return Optional.ofNullable(values).filter(vs -> vs.size() > 0).map(x -> (String)x.get(0));
    }

    public static Optional<Integer> paramValueAsInt(Map<String, List<String>> params, String key) {
        List<String> values = params.get(key);
        return Optional.ofNullable(values).filter(vs -> vs.size() > 0).map(x -> {
            try {
                return Integer.parseInt((String)x.get(0));
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
    }

    public static Optional<Boolean> paramValueAsBool(Map<String, List<String>> params, String key) {
        List<String> values = params.get(key);
        return Optional.ofNullable(values).filter(vs -> vs.size() > 0).map(x -> {
            try {
                return Boolean.valueOf((String)x.get(0));
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
    }

    public static List<Integer> paramValuesAsInt(Map<String, List<String>> params, String key) {
        List<String> values = params.get(key);
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().map(s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).collect(Collectors.toList());
    }

    public static List<WorkerState.MetaState> paramValuesAsMetaState(Map<String, List<String>> params, String key) {
        List<String> values = params.get(key);
        if (values != null) {
            return new ArrayList<WorkerState.MetaState>(values.stream().map(s -> WorkerState.MetaState.valueOf(s)).collect(Collectors.toSet()));
        }
        return Collections.emptyList();
    }
}

