/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.utils;

import akka.http.javadsl.model.sse.ServerSentEvent;
import io.mantisrx.master.api.akka.route.proto.JobClusterInfo;
import io.mantisrx.master.api.akka.route.utils.JobDiscoveryHeartbeats;
import io.mantisrx.server.core.JobSchedulingInfo;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamingUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static volatile Optional<ServerSentEvent> cachedSchedInfoHbEvent = Optional.empty();
    private static volatile Optional<ServerSentEvent> cachedJobClusterInfoHbEvent = Optional.empty();

    public static Optional<ServerSentEvent> from(JobSchedulingInfo jsi) {
        try {
            if (jsi.getJobId().equals("HB_JobId") && cachedSchedInfoHbEvent.isPresent()) {
                return cachedSchedInfoHbEvent;
            }
            return Optional.ofNullable(ServerSentEvent.create((String)mapper.writeValueAsString((Object)jsi)));
        }
        catch (JsonProcessingException e) {
            logger.warn("failed to serialize Job Scheduling Info {}", (Object)jsi);
            return Optional.empty();
        }
    }

    public static Optional<ServerSentEvent> from(JobClusterInfo jci) {
        try {
            if (jci.getName().equals("HB_JobId") && cachedJobClusterInfoHbEvent.isPresent()) {
                return cachedJobClusterInfoHbEvent;
            }
            return Optional.ofNullable(ServerSentEvent.create((String)mapper.writeValueAsString((Object)jci)));
        }
        catch (JsonProcessingException e) {
            logger.warn("failed to serialize Job Cluster Info {}", (Object)jci);
            return Optional.empty();
        }
    }

    static {
        try {
            cachedJobClusterInfoHbEvent = Optional.of(ServerSentEvent.create((String)mapper.writeValueAsString((Object)JobDiscoveryHeartbeats.JOB_CLUSTER_INFO_HB_INSTANCE)));
            cachedSchedInfoHbEvent = Optional.of(ServerSentEvent.create((String)mapper.writeValueAsString((Object)JobDiscoveryHeartbeats.SCHED_INFO_HB_INSTANCE)));
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to cache serialized Heartbeat event", (Throwable)e);
        }
    }
}

