/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v0;

import akka.actor.ActorSystem;
import akka.http.caching.LfuCache;
import akka.http.caching.javadsl.Cache;
import akka.http.caching.javadsl.CachingSettings;
import akka.http.caching.javadsl.LfuCacheSettings;
import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.Uri;
import akka.http.javadsl.server.AllDirectives;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.RouteResult;
import akka.http.javadsl.server.directives.RouteAdapter;
import akka.japi.pf.PFBuilder;
import akka.pattern.AskTimeoutException;
import io.mantisrx.master.api.akka.route.MasterApiMetrics;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

abstract class BaseRoute
extends AllDirectives {
    private static final Logger log = LoggerFactory.getLogger(BaseRoute.class);

    BaseRoute() {
    }

    protected HttpResponse toHttpResponse(BaseResponse r) {
        switch (r.responseCode) {
            case SUCCESS: 
            case SUCCESS_CREATED: {
                MasterApiMetrics.getInstance().incrementResp2xx();
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, r.message)).withStatus(StatusCodes.OK);
            }
            case CLIENT_ERROR: 
            case CLIENT_ERROR_NOT_FOUND: 
            case CLIENT_ERROR_CONFLICT: {
                MasterApiMetrics.getInstance().incrementResp4xx();
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, "{\"error\": \"" + r.message + "\"}")).withStatus(StatusCodes.BAD_REQUEST);
            }
            case OPERATION_NOT_ALLOWED: {
                MasterApiMetrics.getInstance().incrementResp4xx();
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, "{\"error\": \"" + r.message + "\"}")).withStatus(StatusCodes.METHOD_NOT_ALLOWED);
            }
        }
        MasterApiMetrics.getInstance().incrementResp5xx();
        log.error("Non-matched response code error: {}", (Object)r.message);
        return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, "{\"error\": \"" + r.message + "\"}")).withStatus(StatusCodes.INTERNAL_SERVER_ERROR);
    }

    protected <T extends BaseResponse> RouteAdapter completeAsync(CompletionStage<T> stage, Function<T, RouteAdapter> successTransform) {
        return this.completeAsync(stage, successTransform, r -> this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"" + r.message + "\"}"));
    }

    protected <T extends BaseResponse> RouteAdapter completeAsync(CompletionStage<T> stage, Function<T, RouteAdapter> successTransform, Function<T, RouteAdapter> clientFailureTransform) {
        return this.onComplete(stage, resp -> (Route)resp.map(r -> {
            switch (r.responseCode) {
                case SUCCESS: 
                case SUCCESS_CREATED: {
                    MasterApiMetrics.getInstance().incrementResp2xx();
                    return (RouteAdapter)successTransform.apply(r);
                }
                case CLIENT_ERROR: 
                case CLIENT_ERROR_NOT_FOUND: 
                case CLIENT_ERROR_CONFLICT: {
                    return (RouteAdapter)clientFailureTransform.apply(r);
                }
            }
            MasterApiMetrics.getInstance().incrementResp5xx();
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, r.message);
        }).recover(new PFBuilder().match(AskTimeoutException.class, te -> {
            MasterApiMetrics.getInstance().incrementAskTimeOutCount();
            MasterApiMetrics.getInstance().incrementResp5xx();
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "{\"error\": \"" + te.getMessage() + "\"}");
        }).matchAny(ex -> {
            MasterApiMetrics.getInstance().incrementResp5xx();
            log.error("Internal server error from completeAsync: ", ex);
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "{\"error\": \"" + ex.getMessage() + "\"}");
        }).build()).get());
    }

    protected Cache<Uri, RouteResult> createCache(ActorSystem actorSystem, int initialCapacity, int maxCapacity, int ttlMillis) {
        CachingSettings defaultCachingSettings = CachingSettings.create((ActorSystem)actorSystem);
        LfuCacheSettings lfuCacheSettings = defaultCachingSettings.lfuCacheSettings().withInitialCapacity(initialCapacity).withMaxCapacity(maxCapacity).withTimeToLive((Duration)Duration.create((long)ttlMillis, (TimeUnit)TimeUnit.MILLISECONDS));
        CachingSettings cachingSettings = defaultCachingSettings.withLfuCacheSettings(lfuCacheSettings);
        return LfuCache.create((CachingSettings)cachingSettings);
    }
}

